/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.plugins.git.GitAPI;
import hudson.plugins.git.GitException;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Revision;
import hudson.plugins.git.SubmoduleConfig;
import hudson.plugins.git.util.GitUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.spearce.jgit.lib.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmoduleCombinator {
    IGitAPI git;
    File workspace;
    TaskListener listener;
    long tid = new Date().getTime();
    long idx = 1L;
    Collection<SubmoduleConfig> submoduleConfig;

    public SubmoduleCombinator(IGitAPI git, TaskListener listener, File workspace, Collection<SubmoduleConfig> cfg) {
        this.git = git;
        this.listener = listener;
        this.workspace = workspace;
        this.submoduleConfig = cfg;
    }

    public void createSubmoduleCombinations() throws GitException, IOException {
        GitUtils gitUtils = new GitUtils(this.listener, this.git);
        HashMap<IndexEntry, Collection> moduleBranches = new HashMap<IndexEntry, Collection>();
        for (IndexEntry submodule : gitUtils.getSubmodules("HEAD")) {
            File subdir = new File(this.workspace, submodule.getFile());
            GitAPI subGit = new GitAPI(this.git.getGitExe(), new FilePath(subdir), this.listener);
            GitUtils gu = new GitUtils(this.listener, (IGitAPI)subGit);
            Collection items = gu.filterTipBranches(gu.getAllBranchRevisions());
            this.filterRevisions(submodule.getFile(), items);
            moduleBranches.put(submodule, items);
        }
        for (IndexEntry entry : moduleBranches.keySet()) {
            this.listener.getLogger().print("Submodule " + entry.getFile() + " branches");
            for (Revision br : (Collection)moduleBranches.get(entry)) {
                this.listener.getLogger().print(" " + br.toString());
            }
            this.listener.getLogger().print("\n");
        }
        List combinations = this.createCombinations(moduleBranches);
        this.listener.getLogger().println("There are " + combinations.size() + " submodule/revision combinations possible");
        HashMap<ObjectId, List> entriesMap = new HashMap<ObjectId, List>();
        for (ObjectId sha1 : this.git.revListAll()) {
            List entries = gitUtils.getSubmodules(sha1.name());
            entriesMap.put(sha1, entries);
        }
        block4: for (List entries : entriesMap.values()) {
            Iterator it = combinations.iterator();
            while (it.hasNext()) {
                Map item = (Map)it.next();
                if (!this.matches(item, entries)) continue;
                it.remove();
                continue block4;
            }
        }
        this.listener.getLogger().println("There are " + combinations.size() + " configurations that could be generated.");
        ObjectId headSha1 = this.git.revParse("HEAD");
        for (Map combination : combinations) {
            ObjectId sha1 = headSha1;
            int min = Integer.MAX_VALUE;
            for (ObjectId sha : entriesMap.keySet()) {
                List entries = (List)entriesMap.get(sha);
                int value = this.difference(combination, entries);
                if (value > 0 && value < min) {
                    min = value;
                    sha1 = sha;
                }
                if (min != 1) continue;
                break;
            }
            this.git.checkout(sha1.name());
            this.makeCombination(combination);
        }
    }

    private Collection<Revision> filterRevisions(String name, Collection<Revision> items) {
        SubmoduleConfig config = this.getSubmoduleConfig(name);
        if (config == null) {
            return items;
        }
        Iterator<Revision> it = items.iterator();
        while (it.hasNext()) {
            Revision r = it.next();
            if (config.revisionMatchesInterest(r)) continue;
            it.remove();
        }
        return items;
    }

    private SubmoduleConfig getSubmoduleConfig(String name) {
        for (SubmoduleConfig config : this.submoduleConfig) {
            if (!config.getSubmoduleName().equals(name)) continue;
            return config;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeCombination(Map<IndexEntry, Revision> settings) {
        Revision branch;
        String name = "combine-" + this.tid + "-" + this.idx++;
        this.git.branch(name);
        this.git.checkout(name);
        String commit = "Hudson generated combination of:\n";
        for (IndexEntry submodule : settings.keySet()) {
            branch = settings.get(submodule);
            commit = commit + "  " + submodule.getFile() + " " + branch.toString() + "\n";
        }
        this.listener.getLogger().print(commit);
        for (IndexEntry submodule : settings.keySet()) {
            branch = settings.get(submodule);
            File subdir = new File(this.workspace, submodule.getFile());
            GitAPI subGit = new GitAPI(this.git.getGitExe(), new FilePath(subdir), this.listener);
            subGit.checkout(branch.sha1.name());
            this.git.add(submodule.file);
        }
        try {
            File f = File.createTempFile("gitcommit", ".txt");
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                fos.write(commit.getBytes());
            }
            finally {
                fos.close();
            }
            this.git.commit(f);
            f.delete();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int difference(Map<IndexEntry, Revision> item, List<IndexEntry> entries) {
        int difference = 0;
        if (entries.size() != item.keySet().size()) {
            return -1;
        }
        for (IndexEntry entry : entries) {
            Revision b = null;
            for (IndexEntry e : item.keySet()) {
                if (!e.getFile().equals(entry.getFile())) continue;
                b = item.get(e);
            }
            if (b == null) {
                return -1;
            }
            if (entry.object.equals(b.getSha1())) continue;
            ++difference;
        }
        return difference;
    }

    protected boolean matches(Map<IndexEntry, Revision> item, List<IndexEntry> entries) {
        return this.difference(item, entries) == 0;
    }

    public List<Map<IndexEntry, Revision>> createCombinations(Map<IndexEntry, Collection<Revision>> moduleBranches) {
        if (moduleBranches.keySet().size() == 0) {
            return new ArrayList<Map<IndexEntry, Revision>>();
        }
        ArrayList<Map<IndexEntry, Revision>> thisLevel = new ArrayList<Map<IndexEntry, Revision>>();
        IndexEntry e = moduleBranches.keySet().iterator().next();
        for (Revision b : moduleBranches.remove(e)) {
            HashMap<IndexEntry, Revision> result = new HashMap<IndexEntry, Revision>();
            result.put(e, b);
            thisLevel.add(result);
        }
        List children = this.createCombinations(moduleBranches);
        if (children.size() == 0) {
            return thisLevel;
        }
        ArrayList<Map<IndexEntry, Revision>> result = new ArrayList<Map<IndexEntry, Revision>>();
        for (Map map : thisLevel) {
            for (Map childLevelEntry : children) {
                HashMap r = new HashMap();
                r.putAll(map);
                r.putAll(childLevelEntry);
                result.add(r);
            }
        }
        return result;
    }
}

