/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.plugins.git.Branch;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchSpec
implements Serializable {
    private String name;

    public String getName() {
        return this.name;
    }

    public BranchSpec(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.name = name.length() == 0 ? "*" : name;
    }

    public boolean matches(String item) {
        if (this.name.contains("*")) {
            String regex = this.name.replace("*", ".*");
            return Pattern.matches(regex, item);
        }
        return this.name.equals(item);
    }

    public List<String> filterMatching(Collection<String> branches) {
        ArrayList<String> items = new ArrayList<String>();
        for (String b : branches) {
            if (!this.matches(b)) continue;
            items.add(b);
        }
        return items;
    }

    public List<Branch> filterMatchingBranches(Collection<Branch> branches) {
        ArrayList<Branch> items = new ArrayList<Branch>();
        for (Branch b : branches) {
            if (!this.matches(b.getName())) continue;
            items.add(b);
        }
        return items;
    }
}

