/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.scm.RepositoryBrowser;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitWeb
extends RepositoryBrowser<GitChangeSet> {
    private final URL url;
    public static final Descriptor<RepositoryBrowser<?>> DESCRIPTOR = new Descriptor<RepositoryBrowser<?>>(GitWeb.class){

        public String getDisplayName() {
            return "gitweb";
        }

        public GitWeb newInstance(StaplerRequest req) throws Descriptor.FormException {
            return (GitWeb)((Object)req.bindParameters(GitWeb.class, "gitweb."));
        }
    };
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public GitWeb(String url) throws MalformedURLException {
        this.url = new URL(url);
    }

    public URL getUrl() {
        return this.url;
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        String queryPart = "a=commit;h=" + changeSet.getId();
        String q = this.url.getQuery();
        q = q == null ? queryPart : q + ";" + queryPart;
        try {
            return new URL(this.url, this.url.getPath() + "?" + q);
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
    }

    public Descriptor<RepositoryBrowser<?>> getDescriptor() {
        return DESCRIPTOR;
    }
}

