/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import hudson.model.Action;
import hudson.plugins.git.Branch;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.Build;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.kohsuke.stapler.export.ExportedBean;
import org.spearce.jgit.lib.ObjectId;

@ExportedBean(defaultVisibility=999)
public class BuildData
implements Action,
Serializable {
    private static final long serialVersionUID = 1L;
    public Map<String, Build> buildsByBranchName = new HashMap<String, Build>();
    public Build lastBuild;

    public String getDisplayName() {
        return "Git Build Data";
    }

    public String getIconFileName() {
        return "/plugin/git/icons/git-32x32.png";
    }

    public String getUrlName() {
        return "git";
    }

    public boolean hasBeenBuilt(ObjectId sha1) {
        try {
            for (Build b : this.buildsByBranchName.values()) {
                if (!b.revision.getSha1().equals(sha1)) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void saveBuild(Build build) {
        this.lastBuild = build;
        for (Branch branch : build.revision.getBranches()) {
            this.buildsByBranchName.put(branch.getName(), build);
        }
    }

    public Build getLastBuildOfBranch(String branch) {
        try {
            return this.buildsByBranchName.get(branch);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Revision getLastBuiltRevision() {
        return this.lastBuild == null ? null : this.lastBuild.revision;
    }
}

