/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import hudson.model.Result;
import hudson.plugins.git.Revision;
import java.io.Serializable;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.spearce.jgit.lib.ObjectId;

@ExportedBean(defaultVisibility=999)
public class Build
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public Revision revision;
    public Revision mergeRevision;
    public int hudsonBuildNumber;
    public Result hudsonBuildResult;

    public Build(Revision revision, int buildNumber, Result result) {
        this.revision = revision;
        this.hudsonBuildNumber = buildNumber;
        this.hudsonBuildResult = result;
    }

    public ObjectId getSHA1() {
        return this.revision.getSha1();
    }

    @Exported
    public Revision getRevision() {
        return this.revision;
    }

    @Exported
    public int getBuildNumber() {
        return this.hudsonBuildNumber;
    }

    @Exported
    public Result getBuildResult() {
        return this.hudsonBuildResult;
    }

    public String toString() {
        String str = "Build #" + this.hudsonBuildNumber + " of " + this.revision.toString();
        if (this.mergeRevision != null) {
            str = str + " merged with " + this.mergeRevision;
        }
        return str;
    }

    public Build clone() {
        Build clone;
        try {
            clone = (Build)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Error cloning Build", e);
        }
        if (this.revision != null) {
            clone.revision = this.revision.clone();
        }
        if (this.mergeRevision != null) {
            clone.mergeRevision = this.mergeRevision.clone();
        }
        return clone;
    }
}

