/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import hudson.model.Action;
import hudson.model.Result;
import hudson.plugins.git.Branch;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.GitUtils;
import hudson.plugins.git.util.IBuildChooser;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.spearce.jgit.lib.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildChooser
implements IBuildChooser {
    private final IGitAPI git;
    private final GitUtils utils;
    private final GitSCM gitSCM;
    private final BuildData data;

    public BuildChooser(GitSCM gitSCM, IGitAPI git, GitUtils utils, BuildData data) {
        this.gitSCM = gitSCM;
        this.git = git;
        this.utils = utils;
        this.data = data == null ? new BuildData() : data;
    }

    @Override
    public Collection<Revision> getCandidateRevisions(boolean isPollCall, String singleBranch) throws GitException, IOException {
        Set<String> tags;
        if (singleBranch == null || singleBranch.contains("*")) {
            return this.getAdvancedCandidateRevisions(isPollCall);
        }
        if (!isPollCall && singleBranch.matches("[0-9a-f]{6,40}")) {
            try {
                ObjectId sha1 = this.git.revParse(singleBranch);
                Revision revision = new Revision(sha1);
                revision.getBranches().add(new Branch("detached", sha1));
                return Collections.singletonList(revision);
            }
            catch (GitException e) {
                // empty catch block
            }
        }
        if (!singleBranch.contains("/") && (tags = this.git.getTagNames(singleBranch)).size() == 0) {
            String repository = this.gitSCM.getRepositories().get(0).getName();
            singleBranch = repository + "/" + singleBranch;
        }
        try {
            ObjectId sha1 = this.git.revParse(singleBranch);
            if (isPollCall && this.data.hasBeenBuilt(sha1)) {
                return Collections.emptyList();
            }
            Revision revision = new Revision(sha1);
            revision.getBranches().add(new Branch(singleBranch, sha1));
            return Collections.singletonList(revision);
        }
        catch (GitException e) {
            return Collections.emptyList();
        }
    }

    private Collection<Revision> getAdvancedCandidateRevisions(boolean isPollCall) throws GitException, IOException {
        Revision r;
        Collection<Revision> revs = this.utils.getAllBranchRevisions();
        Iterator<Revision> i = revs.iterator();
        while (i.hasNext()) {
            r = i.next();
            Iterator<Branch> j = r.getBranches().iterator();
            while (j.hasNext()) {
                Branch b = j.next();
                boolean keep = false;
                for (BranchSpec bspec : this.gitSCM.getBranches()) {
                    if (!bspec.matches(b.getName())) continue;
                    keep = true;
                    break;
                }
                if (keep) continue;
                j.remove();
            }
            if (r.getBranches().size() != 0) continue;
            i.remove();
        }
        revs = this.utils.filterTipBranches(revs);
        i = revs.iterator();
        while (i.hasNext()) {
            r = i.next();
            if (!this.data.hasBeenBuilt(r.getSha1())) continue;
            i.remove();
        }
        if (!isPollCall && revs.size() == 0 && this.data.getLastBuiltRevision() != null) {
            return Collections.singletonList(this.data.getLastBuiltRevision());
        }
        return revs;
    }

    @Override
    public Build revisionBuilt(Revision revision, int buildNumber, Result result) {
        Build build = new Build(revision, buildNumber, result);
        this.data.saveBuild(build);
        return build;
    }

    @Override
    public Action getData() {
        return this.data;
    }
}

