/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.Util;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.plugins.git.GitChangeSet;
import hudson.scm.ChangeLogSet;
import hudson.tasks.Mailer;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitChangeSet
extends ChangeLogSet.Entry {
    private static final Pattern FILE_LOG_ENTRY = Pattern.compile("^:[0-9]{6} [0-9]{6} ([0-9a-f]{40}) ([0-9a-f]{40}) ([ACDMRTUX])(?>[0-9]+)?\t(.*)$");
    private static final String NULL_HASH = "0000000000000000000000000000000000000000";
    private String author;
    private String authorEmail;
    private String comment;
    private String title;
    private String id;
    private String parentCommit;
    private Collection<Path> paths = new HashSet();

    public GitChangeSet(List<String> lines) {
        if (lines.size() > 0) {
            this.parseCommit(lines);
        }
    }

    private void parseCommit(List<String> lines) {
        String message = "";
        for (String line : lines) {
            String mode;
            Matcher fileMatcher;
            if (line.length() <= 0) continue;
            if (line.startsWith("commit ")) {
                this.id = line.split(" ")[1];
                continue;
            }
            if (line.startsWith("tree ")) continue;
            if (line.startsWith("parent ")) {
                this.parentCommit = line.split(" ")[1];
                continue;
            }
            if (line.startsWith("committer ")) {
                this.author = line.substring(10, line.indexOf(" <"));
                this.authorEmail = line.substring(line.indexOf(" <") + 2, line.indexOf("> "));
                continue;
            }
            if (line.startsWith("author ")) continue;
            if (line.startsWith("    ")) {
                message = message + line.substring(4) + "\n";
                continue;
            }
            if (':' != line.charAt(0) || !(fileMatcher = FILE_LOG_ENTRY.matcher(line)).matches() || fileMatcher.groupCount() < 4 || (mode = fileMatcher.group(3)).length() != 1) continue;
            String src = null;
            String dst = null;
            char editMode = mode.charAt(0);
            if (editMode == 'M' || editMode == 'A' || editMode == 'D') {
                src = this.parseHash(fileMatcher.group(1));
                dst = this.parseHash(fileMatcher.group(2));
            }
            String path = fileMatcher.group(4);
            this.paths.add(new Path(src, dst, editMode, path, this, null));
        }
        this.comment = message;
        int endOfFirstLine = this.comment.indexOf(10);
        this.title = endOfFirstLine == -1 ? this.comment : this.comment.substring(0, endOfFirstLine);
    }

    private String parseHash(String hash) {
        return NULL_HASH.equals(hash) ? null : hash;
    }

    public void setParent(ChangeLogSet parent) {
        super.setParent(parent);
    }

    public String getParentCommit() {
        return this.parentCommit;
    }

    public Collection<Path> getPaths() {
        return this.paths;
    }

    public Collection<String> getAffectedPaths() {
        HashSet<String> affectedPaths = new HashSet<String>(this.paths.size());
        for (Path file : this.paths) {
            affectedPaths.add(file.getPath());
        }
        return affectedPaths;
    }

    public User getAuthor() {
        if (this.author == null) {
            throw new RuntimeException("No author in this changeset!");
        }
        User user = User.get((String)this.author, (boolean)true);
        if (Util.fixEmpty((String)this.authorEmail) != null && user.getProperty(Mailer.UserProperty.class) == null) {
            try {
                user.addProperty((UserProperty)new Mailer.UserProperty(this.authorEmail));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return user;
    }

    public String getMsg() {
        return this.title;
    }

    public String getId() {
        return this.id;
    }

    public String getComment() {
        return this.comment;
    }
}

