/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Revision;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.spearce.jgit.lib.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitUtils {
    IGitAPI git;
    TaskListener listener;

    public GitUtils(TaskListener listener, IGitAPI git) {
        this.git = git;
        this.listener = listener;
    }

    public List<IndexEntry> getSubmodules(String treeIsh) {
        List submodules = this.git.lsTree(treeIsh);
        Iterator it = submodules.iterator();
        while (it.hasNext()) {
            if (((IndexEntry)it.next()).getMode().equals("160000")) continue;
            it.remove();
        }
        return submodules;
    }

    public Collection<Revision> getAllBranchRevisions() throws GitException, IOException {
        HashMap<ObjectId, Revision> revisions = new HashMap<ObjectId, Revision>();
        List branches = this.git.getRemoteBranches();
        for (Branch b : branches) {
            Revision r = (Revision)revisions.get(b.getSHA1());
            if (r == null) {
                r = new Revision(b.getSHA1());
                revisions.put(b.getSHA1(), r);
            }
            r.getBranches().add(b);
        }
        return revisions.values();
    }

    public Revision getRevisionContainingBranch(String branchName) throws GitException, IOException {
        for (Revision revision : this.getAllBranchRevisions()) {
            for (Branch b : revision.getBranches()) {
                if (!b.getName().equals(branchName)) continue;
                return revision;
            }
        }
        return null;
    }

    public Revision getRevisionForSHA1(ObjectId sha1) throws GitException, IOException {
        for (Revision revision : this.getAllBranchRevisions()) {
            if (!revision.getSha1().equals(sha1)) continue;
            return revision;
        }
        return null;
    }

    public Collection<Revision> filterTipBranches(Collection<Revision> revisions) {
        Iterator<Revision> it = revisions.iterator();
        while (it.hasNext()) {
            Revision r = it.next();
            boolean remove = false;
            for (Revision r2 : revisions) {
                ObjectId commonAncestor;
                if (r == r2 || (commonAncestor = this.git.mergeBase(r.getSha1(), r2.getSha1())) == null || !commonAncestor.equals(r.getSha1())) continue;
                remove = true;
                break;
            }
            if (!remove) continue;
            it.remove();
        }
        return revisions;
    }

    public static String[] fixupNames(String[] names, String[] urls) {
        String[] returnNames = new String[urls.length];
        HashSet<String> usedNames = new HashSet<String>();
        for (int i = 0; i < urls.length; ++i) {
            String name = names[i];
            if (name == null || name.trim().length() == 0) {
                name = "origin";
            }
            String baseName = name;
            int j = 1;
            while (usedNames.contains(name)) {
                name = baseName + j++;
            }
            usedNames.add(name);
            returnNames[i] = name;
        }
        return returnNames;
    }
}

