/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.util.ArgumentListBuilder;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.Ref;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.lib.Tag;
import org.spearce.jgit.transport.RefSpec;
import org.spearce.jgit.transport.RemoteConfig;
import org.spearce.jgit.transport.URIish;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitAPI
implements IGitAPI {
    Launcher launcher;
    FilePath workspace;
    TaskListener listener;
    String gitExe;
    EnvVars environment;

    public GitAPI(String gitExe, FilePath workspace, TaskListener listener, EnvVars environment) {
        this.workspace = workspace;
        this.listener = listener;
        this.gitExe = gitExe;
        this.environment = environment;
        PrintStream log = listener.getLogger();
        log.println("GitAPI created");
        for (Map.Entry ent : environment.entrySet()) {
        }
        this.launcher = new Launcher.LocalLauncher(listener);
    }

    public String getGitExe() {
        return this.gitExe;
    }

    public EnvVars getEnvironment() {
        return this.environment;
    }

    public void init() throws GitException {
        if (this.hasGitRepo()) {
            throw new GitException(".git directory already exists! Has it already been initialised?");
        }
        try {
            Repository repo = new Repository(new File(this.workspace.child(".git").getRemote()));
            repo.create();
        }
        catch (IOException ioe) {
            throw new GitException("Error initiating git repo.", (Throwable)ioe);
        }
    }

    public boolean hasGitRepo() throws GitException {
        try {
            FilePath dotGit = this.workspace.child(".git");
            return dotGit.exists();
        }
        catch (SecurityException ex) {
            throw new GitException("Security error when trying to check for .git. Are you sure you have correct permissions?", (Throwable)ex);
        }
        catch (Exception e) {
            throw new GitException("Couldn't check for .git", (Throwable)e);
        }
    }

    public boolean hasGitModules() throws GitException {
        try {
            FilePath dotGit = this.workspace.child(".gitmodules");
            return dotGit.exists();
        }
        catch (SecurityException ex) {
            throw new GitException("Security error when trying to check for .gitmodules. Are you sure you have correct permissions?", (Throwable)ex);
        }
        catch (Exception e) {
            throw new GitException("Couldn't check for .gitmodules", (Throwable)e);
        }
    }

    public void fetch(String repository, String refspec) throws GitException {
        this.listener.getLogger().println("Fetching upstream changes" + (repository != null ? " from " + repository : ""));
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "fetch", "-t"});
        if (repository != null) {
            args.add(repository);
            if (refspec != null) {
                args.add(refspec);
            }
        }
        try {
            if (this.launcher.launch().cmds(args).envs((Map)this.environment).stdout((OutputStream)this.listener.getLogger()).pwd(this.workspace).join() != 0) {
                throw new GitException("Failed to fetch");
            }
        }
        catch (IOException e) {
            throw new GitException("Failed to fetch", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new GitException("Failed to fetch", (Throwable)e);
        }
    }

    public void fetch() throws GitException {
        this.fetch(null, null);
    }

    public void clone(RemoteConfig remoteConfig) throws GitException {
        this.listener.getLogger().println("Cloning repository " + remoteConfig.getName());
        try {
            this.workspace.deleteRecursive();
        }
        catch (Exception e) {
            e.printStackTrace(this.listener.error("Failed to clean the workspace"));
            throw new GitException("Failed to delete workspace", (Throwable)e);
        }
        String source = ((URIish)remoteConfig.getURIs().get(0)).toString();
        try {
            this.workspace.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            throw new GitException("Could not clone " + source, (Throwable)e);
        }
    }

    public void clean() throws GitException {
        this.launchCommand(new String[]{"clean", "-fdx"});
    }

    public ObjectId revParse(String revName) throws GitException {
        String result = this.launchCommand(new String[]{"rev-parse", revName});
        return ObjectId.fromString((String)this.firstLine(result).trim());
    }

    public String describe(String commitIsh) throws GitException {
        String result = this.launchCommand(new String[]{"describe", "--tags", commitIsh});
        return this.firstLine(result).trim();
    }

    private String firstLine(String result) {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(result));
        try {
            line = reader.readLine();
            if (line == null) {
                return null;
            }
            if (reader.readLine() != null) {
                throw new GitException("Result has multiple lines");
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing result", (Throwable)e);
        }
        return line;
    }

    private void log(String revFrom, String revTo, OutputStream fos, String ... extraargs) throws GitException {
        String revSpec = revFrom == null ? revTo : revFrom + ".." + revTo;
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "log"});
        args.add(extraargs);
        args.add(revSpec);
        try {
            if (this.launcher.launch().cmds(args).envs((Map)this.environment).stdout(fos).pwd(this.workspace).join() != 0) {
                throw new GitException("Error launching git log");
            }
        }
        catch (Exception e) {
            throw new GitException("Error performing git log", (Throwable)e);
        }
    }

    private void treeDiff(String rev, OutputStream fos, String ... extraargs) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "diff-tree"});
        args.add(extraargs);
        args.add(rev);
        try {
            fos.write("\n".getBytes());
            if (this.launcher.launch().cmds(args).envs((Map)this.environment).stdout(fos).pwd(this.workspace).join() != 0) {
                throw new GitException("Error launching git diff-tree");
            }
        }
        catch (Exception e) {
            throw new GitException("Error performing git diff-tree", (Throwable)e);
        }
    }

    public void changelog(String revFrom, String revTo, OutputStream fos) throws GitException {
        List commits = this.getChangeLogCommits(revFrom, revTo);
        for (String commit : commits) {
            this.logCommit(commit, fos);
        }
    }

    private List<String> getChangeLogCommits(String revFrom, String revTo) throws GitException {
        ByteArrayOutputStream commitStream = new ByteArrayOutputStream();
        this.log(revFrom, revTo, (OutputStream)commitStream, new String[]{"--pretty=format:%H"});
        BufferedReader commitReader = new BufferedReader(new StringReader(commitStream.toString()));
        ArrayList<String> commits = new ArrayList<String>();
        try {
            String line = commitReader.readLine();
            while (line != null) {
                commits.add(line);
                line = commitReader.readLine();
            }
        }
        catch (Exception e) {
            throw new GitException("Could not process change log", (Throwable)e);
        }
        finally {
            try {
                commitStream.close();
            }
            catch (IOException ioe) {}
        }
        return commits;
    }

    private void logCommit(String commit, OutputStream fos) throws GitException {
        this.log(null, commit, fos, new String[]{"-M", "--summary", "--pretty=raw", "-n", "1"});
        this.treeDiff(commit, fos, new String[]{"-M", "-r"});
    }

    public void merge(String revSpec) throws GitException {
        try {
            this.launchCommand(new String[]{"merge", revSpec});
        }
        catch (GitException e) {
            throw new GitException("Could not merge " + revSpec, (Throwable)e);
        }
    }

    public void submoduleInit() throws GitException {
        this.launchCommand(new String[]{"submodule", "init"});
    }

    public void submoduleSync() throws GitException {
        this.launchCommand(new String[]{"submodule", "sync"});
    }

    public void submoduleUpdate() throws GitException {
        this.launchCommand(new String[]{"submodule", "update"});
    }

    public void tag(String tagName, String comment) throws GitException {
        tagName = tagName.replace(' ', '_');
        try {
            this.launchCommand(new String[]{"tag", "-a", "-f", "-m", comment, tagName});
        }
        catch (GitException e) {
            throw new GitException("Could not apply tag " + tagName, (Throwable)e);
        }
    }

    public String launchCommand(ArgumentListBuilder args) throws GitException {
        return this.launchCommandIn(args, this.workspace);
    }

    public String launchCommand(String ... args) throws GitException {
        return this.launchCommand(new ArgumentListBuilder(args));
    }

    private String launchCommandIn(ArgumentListBuilder args, FilePath workDir) throws GitException {
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        try {
            args.prepend(new String[]{this.getGitExe()});
            int status = this.launcher.launch().cmds(args.toCommandArray()).envs((Map)this.environment).stdout((OutputStream)fos).pwd(workDir).join();
            String result = fos.toString();
            if (status != 0) {
                throw new GitException("Command returned status code " + status + ": " + result);
            }
            return result;
        }
        catch (Exception e) {
            throw new GitException("Error performing " + StringUtils.join((Object[])args.toCommandArray(), (String)" "), (Throwable)e);
        }
    }

    public void push(RemoteConfig repository, String refspec) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"push", ((URIish)repository.getURIs().get(0)).toString()});
        if (refspec != null) {
            args.add(refspec);
        }
        this.launchCommand(args);
    }

    private List<Branch> parseBranches(String fos) throws GitException {
        ArrayList<Branch> tags = new ArrayList<Branch>();
        BufferedReader rdr = new BufferedReader(new StringReader(fos));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                if ((line = line.substring(2)).startsWith("(")) continue;
                tags.add(new Branch(line, this.revParse(line)));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing branches", (Throwable)e);
        }
        return tags;
    }

    public List<Branch> getBranches() throws GitException {
        return this.parseBranches(this.launchCommand(new String[]{"branch", "-a"}));
    }

    public List<Branch> getRemoteBranches() throws GitException, IOException {
        Repository db = this.getRepository();
        Map refs = db.getAllRefs();
        ArrayList<Branch> branches = new ArrayList<Branch>();
        for (Ref candidate : refs.values()) {
            if (!candidate.getName().startsWith("refs/remotes/")) continue;
            Branch buildBranch = new Branch(candidate);
            this.listener.getLogger().println("Seen branch in repository " + buildBranch.getName());
            branches.add(buildBranch);
        }
        return branches;
    }

    public List<Branch> getBranchesContaining(String revspec) throws GitException {
        return this.parseBranches(this.launchCommand(new String[]{"branch", "-a", "--contains", revspec}));
    }

    public void checkout(String ref) throws GitException {
        try {
            this.launchCommand(new String[]{"checkout", "-f", ref.toString()});
        }
        catch (GitException e) {
            throw new GitException("Could not checkout " + ref, (Throwable)e);
        }
    }

    public void deleteTag(String tagName) throws GitException {
        tagName = tagName.replace(' ', '_');
        try {
            this.launchCommand(new String[]{"tag", "-d", tagName});
        }
        catch (GitException e) {
            throw new GitException("Could not delete tag " + tagName, (Throwable)e);
        }
    }

    public List<IndexEntry> lsTree(String treeIsh) throws GitException {
        ArrayList<IndexEntry> entries = new ArrayList<IndexEntry>();
        String result = this.launchCommand(new String[]{"ls-tree", treeIsh});
        BufferedReader rdr = new BufferedReader(new StringReader(result));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                String[] entry = line.split("\\s+");
                entries.add(new IndexEntry(entry[0], entry[1], entry[2], entry[3]));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing ls tree", (Throwable)e);
        }
        return entries;
    }

    public List<ObjectId> revListAll() throws GitException {
        return this.revList(new String[]{"--all"});
    }

    public List<ObjectId> revListBranch(String branchId) throws GitException {
        return this.revList(new String[]{branchId});
    }

    public List<ObjectId> revList(String ... extraArgs) throws GitException {
        ArrayList<ObjectId> entries = new ArrayList<ObjectId>();
        ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"rev-list"});
        args.add(extraArgs);
        String result = this.launchCommand(args);
        BufferedReader rdr = new BufferedReader(new StringReader(result));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                entries.add(ObjectId.fromString((String)line));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing rev list", (Throwable)e);
        }
        return entries;
    }

    public void add(String filePattern) throws GitException {
        try {
            this.launchCommand(new String[]{"add", filePattern});
        }
        catch (GitException e) {
            throw new GitException("Cannot add " + filePattern, (Throwable)e);
        }
    }

    public void branch(String name) throws GitException {
        try {
            this.launchCommand(new String[]{"branch", name});
        }
        catch (GitException e) {
            throw new GitException("Cannot create branch " + name, (Throwable)e);
        }
    }

    public void commit(File f) throws GitException {
        try {
            this.launchCommand(new String[]{"commit", "-F", f.getAbsolutePath()});
        }
        catch (GitException e) {
            throw new GitException("Cannot commit " + f, (Throwable)e);
        }
    }

    public void fetch(RemoteConfig remoteRepository) throws GitException {
        this.fetch(((URIish)remoteRepository.getURIs().get(0)).toString(), ((RefSpec)remoteRepository.getFetchRefSpecs().get(0)).toString());
    }

    public ObjectId mergeBase(ObjectId id1, ObjectId id2) {
        try {
            String result;
            try {
                result = this.launchCommand(new String[]{"merge-base", id1.name(), id2.name()});
            }
            catch (GitException ge) {
                return null;
            }
            BufferedReader rdr = new BufferedReader(new StringReader(result));
            String line = rdr.readLine();
            if (line != null) {
                return ObjectId.fromString((String)line);
            }
        }
        catch (Exception e) {
            throw new GitException("Error parsing merge base", (Throwable)e);
        }
        return null;
    }

    public String getAllLogEntries(String branch) {
        return this.launchCommand(new String[]{"log", "--all", "--pretty=format:'%H#%ct'", branch});
    }

    private Repository getRepository() throws IOException {
        return new Repository(new File(this.workspace.getRemote(), ".git"));
    }

    public List<Tag> getTagsOnCommit(String revName) throws GitException, IOException {
        Repository db = this.getRepository();
        ObjectId commit = db.resolve(revName);
        ArrayList<Tag> ret = new ArrayList<Tag>();
        for (Map.Entry tag : db.getTags().entrySet()) {
            Tag ttag = db.mapTag((String)tag.getKey());
            if (!ttag.getObjId().equals(commit)) continue;
            ret.add(ttag);
        }
        return ret;
    }

    public Set<String> getTagNames(String tagPattern) throws GitException {
        try {
            String tag;
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add(new String[]{this.getGitExe(), "tag", "-l", tagPattern});
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            int status = this.launcher.launch().cmds(args).envs((Map)this.environment).stdout((OutputStream)fos).pwd(this.workspace).join();
            String result = fos.toString();
            if (status != 0) {
                throw new GitException("Error retrieving tag names");
            }
            HashSet<String> tags = new HashSet<String>();
            BufferedReader rdr = new BufferedReader(new StringReader(result));
            while ((tag = rdr.readLine()) != null) {
                tags.add(tag);
            }
            return tags;
        }
        catch (Exception e) {
            throw new GitException("Error retrieving tag names", (Throwable)e);
        }
    }

    static /* synthetic */ String access$000(GitAPI x0, ArgumentListBuilder x1, FilePath x2) throws GitException {
        return x0.launchCommandIn(x1, x2);
    }
}

