/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitAPI;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Revision;
import hudson.plugins.git.SubmoduleConfig;
import hudson.plugins.git.browser.GitWeb;
import hudson.plugins.git.opt.PreBuildMergeOptions;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.GerritBuildChooser;
import hudson.plugins.git.util.GitUtils;
import hudson.plugins.git.util.IBuildChooser;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;
import org.spearce.jgit.lib.RepositoryConfig;
import org.spearce.jgit.transport.RefSpec;
import org.spearce.jgit.transport.RemoteConfig;
import org.spearce.jgit.transport.URIish;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitSCM
extends SCM
implements Serializable {
    @Deprecated
    transient String source;
    @Deprecated
    transient String branch;
    private Long configVersion;
    private List<RemoteConfig> remoteRepositories;
    private List<BranchSpec> branches;
    private PreBuildMergeOptions mergeOptions;
    private boolean doGenerateSubmoduleConfigurations;
    private boolean clean;
    private String choosingStrategy = "Default";
    public static final String DEFAULT = "Default";
    public static final String GERRIT = "Gerrit";
    private GitWeb browser;
    private Collection<SubmoduleConfig> submoduleCfg;
    public static final String GIT_BRANCH = "GIT_BRANCH";
    public static final String GIT_COMMIT = "GIT_COMMIT";
    private static final long serialVersionUID = 1L;

    public Collection<SubmoduleConfig> getSubmoduleCfg() {
        return this.submoduleCfg;
    }

    public void setSubmoduleCfg(Collection<SubmoduleConfig> submoduleCfg) {
        this.submoduleCfg = submoduleCfg;
    }

    @DataBoundConstructor
    public GitSCM(List<RemoteConfig> repositories, List<BranchSpec> branches, PreBuildMergeOptions mergeOptions, boolean doGenerateSubmoduleConfigurations, Collection<SubmoduleConfig> submoduleCfg, boolean clean, String choosingStrategy, GitWeb browser) {
        this.branches = branches;
        this.remoteRepositories = repositories;
        this.browser = browser;
        this.mergeOptions = mergeOptions;
        this.doGenerateSubmoduleConfigurations = doGenerateSubmoduleConfigurations;
        this.submoduleCfg = submoduleCfg;
        this.clean = clean;
        this.choosingStrategy = choosingStrategy;
        this.configVersion = 1L;
    }

    public Object readResolve() {
        if (this.configVersion == null) {
            this.configVersion = 0L;
        }
        if (this.source != null) {
            this.remoteRepositories = new ArrayList();
            this.branches = new ArrayList();
            this.doGenerateSubmoduleConfigurations = false;
            this.mergeOptions = new PreBuildMergeOptions();
            this.remoteRepositories.add(this.newRemoteConfig("origin", this.source, new RefSpec("+refs/heads/*:refs/remotes/origin/*")));
            if (this.branch != null) {
                this.branches.add(new BranchSpec(this.branch));
            } else {
                this.branches.add(new BranchSpec("*/master"));
            }
        }
        if (this.configVersion < 1L && this.branches != null) {
            for (BranchSpec branchSpec : this.branches) {
                String name = branchSpec.getName();
                name = name.replace("*", "**");
                branchSpec.setName(name);
            }
        }
        if (this.mergeOptions.doMerge() && this.mergeOptions.getMergeRemote() == null) {
            this.mergeOptions.setMergeRemote((RemoteConfig)this.remoteRepositories.get(0));
        }
        return this;
    }

    public GitWeb getBrowser() {
        return this.browser;
    }

    public boolean getClean() {
        return this.clean;
    }

    public String getChoosingStrategy() {
        return this.choosingStrategy;
    }

    public List<RemoteConfig> getRepositories() {
        if (this.remoteRepositories == null) {
            return new ArrayList<RemoteConfig>();
        }
        return this.remoteRepositories;
    }

    private String getSingleBranch(AbstractBuild<?, ?> build) {
        if (this.getBranches().size() != 1 || this.getRepositories().size() != 1) {
            return null;
        }
        String branch = ((BranchSpec)this.getBranches().get(0)).getName();
        String repository = ((RemoteConfig)this.getRepositories().get(0)).getName();
        if (branch.startsWith("*/")) {
            branch = repository + branch.substring(1);
        }
        if (branch.contains("*")) {
            return null;
        }
        ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
        if (parameters != null) {
            branch = parameters.substitute(build, branch);
        }
        return branch;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        BuildData buildData;
        String gitExe = this.getDescriptor().getGitExe();
        listener.getLogger().println("Using strategy: " + this.choosingStrategy);
        AbstractBuild lastBuild = (AbstractBuild)project.getLastBuild();
        if (lastBuild != null) {
            listener.getLogger().println("[poll] Last Build : #" + lastBuild.getNumber());
        }
        if ((buildData = this.getBuildData((Run)lastBuild, false)) != null && buildData.lastBuild != null) {
            listener.getLogger().println("[poll] Last Built Revision: " + buildData.lastBuild.revision);
        }
        String singleBranch = this.getSingleBranch(lastBuild);
        boolean pollChangesResult = (Boolean)workspace.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        return pollChangesResult;
    }

    private IBuildChooser createBuildChooser(IGitAPI git, TaskListener listener, BuildData buildData) {
        if (this.choosingStrategy != null && GERRIT.equals(this.choosingStrategy)) {
            return new GerritBuildChooser(this, git, new GitUtils(listener, git), buildData);
        }
        return new BuildChooser(this, git, new GitUtils(listener, git), buildData);
    }

    private void fetchFrom(IGitAPI git, File workspace, TaskListener listener, RemoteConfig remoteRepository) {
        try {
            git.fetch(remoteRepository);
            List submodules = new GitUtils(listener, git).getSubmodules("HEAD");
            for (IndexEntry submodule : submodules) {
                try {
                    RemoteConfig submoduleRemoteRepository = this.getSubmoduleRepository(remoteRepository, submodule.getFile());
                    File subdir = new File(workspace, submodule.getFile());
                    GitAPI subGit = new GitAPI(git.getGitExe(), new FilePath(subdir), listener, git.getEnvironment());
                    subGit.fetch(submoduleRemoteRepository);
                }
                catch (Exception ex) {
                    listener.error("Problem fetching from " + remoteRepository.getName() + " - could be unavailable. Continuing anyway");
                }
            }
        }
        catch (GitException ex) {
            listener.error("Problem fetching from " + remoteRepository.getName() + " / " + remoteRepository.getName() + " - could be unavailable. Continuing anyway");
        }
    }

    public RemoteConfig getSubmoduleRepository(RemoteConfig orig, String name) {
        String refUrl = ((URIish)orig.getURIs().get(0)).toString();
        if (refUrl.endsWith("/.git")) {
            refUrl = refUrl.substring(0, refUrl.length() - 4);
        }
        if (!refUrl.endsWith("/")) {
            refUrl = refUrl + "/";
        }
        if (!(refUrl = refUrl + name).endsWith("/")) {
            refUrl = refUrl + "/";
        }
        refUrl = refUrl + ".git";
        return this.newRemoteConfig(name, refUrl, (RefSpec)orig.getFetchRefSpecs().get(0));
    }

    private RemoteConfig newRemoteConfig(String name, String refUrl, RefSpec refSpec) {
        File temp = null;
        try {
            temp = File.createTempFile("tmp", "config");
            RepositoryConfig repoConfig = new RepositoryConfig(null, temp);
            repoConfig.setString("remote", name, "url", refUrl);
            repoConfig.setString("remote", name, "fetch", refSpec.toString());
            repoConfig.save();
            RemoteConfig remoteConfig = (RemoteConfig)RemoteConfig.getAllRemoteConfigs((RepositoryConfig)repoConfig).get(0);
            return remoteConfig;
        }
        catch (Exception ex) {
            throw new GitException("Error creating temp file");
        }
        finally {
            if (temp != null) {
                temp.delete();
            }
        }
    }

    private boolean changeLogResult(String changeLog, File changelogFile) throws IOException {
        if (changeLog == null) {
            return false;
        }
        changelogFile.delete();
        FileOutputStream fos = new FileOutputStream(changelogFile);
        fos.write(changeLog.getBytes());
        fos.close();
        return true;
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        Revision parentLastBuiltRev;
        Revision revToBuild;
        BuildData parentBuildData;
        MatrixBuild parentBuild;
        listener.getLogger().println("Checkout:" + workspace.getName() + " / " + workspace.getRemote() + " - " + workspace.getChannel());
        listener.getLogger().println("Using strategy: " + this.choosingStrategy);
        String projectName = build.getProject().getName();
        int buildNumber = build.getNumber();
        String gitExe = this.getDescriptor().getGitExe();
        String buildnumber = "hudson-" + projectName + "-" + buildNumber;
        BuildData buildData = this.getBuildData(build.getPreviousBuild(), true);
        if (buildData != null && buildData.lastBuild != null) {
            listener.getLogger().println("Last Built Revision: " + buildData.lastBuild.revision);
        }
        EnvVars environment = build.getEnvironment((TaskListener)listener);
        String singleBranch = this.getSingleBranch(build);
        Revision tempParentLastBuiltRev = null;
        if (build instanceof MatrixRun && (parentBuild = ((MatrixRun)build).getParentBuild()) != null && (parentBuildData = (BuildData)parentBuild.getAction(BuildData.class)) != null) {
            tempParentLastBuiltRev = parentBuildData.getLastBuiltRevision();
        }
        if ((revToBuild = (Revision)workspace.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */)) == null) {
            listener.error("Nothing to do");
            return false;
        }
        listener.getLogger().println("Commencing build of " + revToBuild);
        environment.put((Object)GIT_COMMIT, (Object)revToBuild.getSha1String());
        if (this.mergeOptions.doMerge() && !revToBuild.containsBranchName(this.mergeOptions.getRemoteBranchName())) {
            Object[] returnData = (Object[])workspace.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
            BuildData returningBuildData = (BuildData)returnData[1];
            build.addAction((Action)returningBuildData);
            return this.changeLogResult((String)returnData[0], changelogFile);
        }
        Object[] returnData = (Object[])workspace.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        build.addAction((Action)returnData[1]);
        return this.changeLogResult((String)returnData[0], changelogFile);
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        String branch = this.getSingleBranch(build);
        if (branch != null) {
            env.put(GIT_BRANCH, branch);
        }
    }

    private String putChangelogDiffsIntoFile(IGitAPI git, String branchName, String revFrom, String revTo) throws IOException {
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        String changeset = "Changes in branch " + branchName + ", between " + revFrom + " and " + revTo + "\n";
        fos.write(changeset.getBytes());
        git.changelog(revFrom, revTo, (OutputStream)fos);
        fos.close();
        return fos.toString();
    }

    public ChangeLogParser createChangeLogParser() {
        return new GitChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public boolean getDoGenerate() {
        return this.doGenerateSubmoduleConfigurations;
    }

    public List<BranchSpec> getBranches() {
        return this.branches;
    }

    public PreBuildMergeOptions getMergeOptions() {
        return this.mergeOptions;
    }

    public BuildData getBuildData(Run build, boolean clone) {
        BuildData buildData = null;
        while (build != null && (buildData = (BuildData)build.getAction(BuildData.class)) == null) {
            build = build.getPreviousBuild();
        }
        if (buildData == null) {
            return null;
        }
        if (clone) {
            return buildData.clone();
        }
        return buildData;
    }

    static /* synthetic */ IBuildChooser access$000(GitSCM x0, IGitAPI x1, TaskListener x2, BuildData x3) {
        return x0.createBuildChooser(x1, x2, x3);
    }

    static /* synthetic */ void access$100(GitSCM x0, IGitAPI x1, File x2, TaskListener x3, RemoteConfig x4) {
        x0.fetchFrom(x1, x2, x3, x4);
    }

    static /* synthetic */ List access$200(GitSCM x0) {
        return x0.remoteRepositories;
    }

    static /* synthetic */ PreBuildMergeOptions access$300(GitSCM x0) {
        return x0.mergeOptions;
    }

    static /* synthetic */ String access$400(GitSCM x0, IGitAPI x1, String x2, String x3, String x4) throws IOException {
        return x0.putChangelogDiffsIntoFile(x1, x2, x3, x4);
    }

    static /* synthetic */ boolean access$500(GitSCM x0) {
        return x0.doGenerateSubmoduleConfigurations;
    }

    static /* synthetic */ Collection access$600(GitSCM x0) {
        return x0.submoduleCfg;
    }
}

