/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import hudson.model.Action;
import hudson.model.Api;
import hudson.plugins.git.Branch;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.Build;
import java.io.Serializable;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.spearce.jgit.lib.ObjectId;

@ExportedBean(defaultVisibility=999)
public class BuildData
implements Action,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public Map<String, Build> buildsByBranchName = new HashMap<String, Build>();
    public Build lastBuild;

    public String getDisplayName() {
        return "Git Build Data";
    }

    public String getIconFileName() {
        return "/plugin/git/icons/git-32x32.png";
    }

    public String getUrlName() {
        return "git";
    }

    public boolean hasBeenBuilt(ObjectId sha1) {
        try {
            for (Build b : this.buildsByBranchName.values()) {
                if (!b.revision.getSha1().equals(sha1)) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void saveBuild(Build build) {
        this.lastBuild = build;
        for (Branch branch : build.revision.getBranches()) {
            this.buildsByBranchName.put(branch.getName(), build);
        }
    }

    public Build getLastBuildOfBranch(String branch) {
        try {
            return this.buildsByBranchName.get(branch);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Exported
    public Revision getLastBuiltRevision() {
        return this.lastBuild == null ? null : this.lastBuild.revision;
    }

    public BuildData clone() {
        BuildData clone;
        try {
            clone = (BuildData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Error cloning BuildData", e);
        }
        IdentityHashMap<Build, Build> clonedBuilds = new IdentityHashMap<Build, Build>();
        if (this.buildsByBranchName != null) {
            clone.buildsByBranchName = new HashMap<String, Build>();
            for (Map.Entry<String, Build> buildByBranchName : this.buildsByBranchName.entrySet()) {
                String branchName = buildByBranchName.getKey();
                Build build = buildByBranchName.getValue();
                Build clonedBuild = (Build)clonedBuilds.get(build);
                if (clonedBuild == null) {
                    clonedBuild = build.clone();
                    clonedBuilds.put(build, clonedBuild);
                }
                clone.buildsByBranchName.put(branchName, clonedBuild);
            }
        }
        if (this.lastBuild != null) {
            clone.lastBuild = (Build)clonedBuilds.get(this.lastBuild);
            if (clone.lastBuild == null) {
                clone.lastBuild = this.lastBuild.clone();
                clonedBuilds.put(this.lastBuild, clone.lastBuild);
            }
        }
        return clone;
    }

    public Api getApi() {
        return new Api((Object)this);
    }
}

