/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitPublisher
extends Publisher
implements Serializable {
    private static final long serialVersionUID = 1L;

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        boolean canPerform;
        EnvVars tempEnvironment;
        SCM scm = build.getProject().getScm();
        if (!(scm instanceof GitSCM)) {
            return false;
        }
        GitSCM gitSCM = (GitSCM)scm;
        String projectName = build.getProject().getName();
        FilePath workspacePath = build.getWorkspace();
        int buildNumber = build.getNumber();
        Result buildResult = build.getResult();
        String gitExe = gitSCM.getDescriptor().getGitExe();
        try {
            tempEnvironment = build.getEnvironment((TaskListener)listener);
        }
        catch (IOException e) {
            listener.error("IOException publishing in git plugin");
            tempEnvironment = new EnvVars();
        }
        catch (InterruptedException e) {
            listener.error("IOException publishing in git plugin");
            tempEnvironment = new EnvVars();
        }
        EnvVars environment = tempEnvironment;
        try {
            canPerform = (Boolean)build.getWorkspace().act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Throwable e) {
            listener.error("Failed to push tags to origin repository: " + e.getMessage());
            build.setResult(Result.FAILURE);
            return false;
        }
        return canPerform;
    }
}

