/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.git.GitAPI;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.opt.PreBuildMergeOptions;
import hudson.remoting.VirtualChannel;
import hudson.scm.SCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.util.FormFieldValidator;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.spearce.jgit.transport.RemoteConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitPublisher
extends Publisher
implements Serializable {
    private static final long serialVersionUID = 1L;

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, final BuildListener listener) throws InterruptedException {
        boolean canPerform;
        EnvVars tempEnvironment;
        SCM scm = build.getProject().getScm();
        if (!(scm instanceof GitSCM)) {
            return false;
        }
        final GitSCM gitSCM = (GitSCM)scm;
        final String projectName = build.getProject().getName();
        final FilePath workspacePath = build.getWorkspace();
        final int buildNumber = build.getNumber();
        final Result buildResult = build.getResult();
        final String gitExe = gitSCM.getDescriptor().getGitExe();
        try {
            tempEnvironment = build.getEnvironment((TaskListener)listener);
        }
        catch (IOException e) {
            listener.error("IOException publishing in git plugin");
            tempEnvironment = new EnvVars();
        }
        catch (InterruptedException e) {
            listener.error("IOException publishing in git plugin");
            tempEnvironment = new EnvVars();
        }
        final EnvVars environment = tempEnvironment;
        try {
            canPerform = (Boolean)build.getWorkspace().act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(){
                private static final long serialVersionUID = 1L;

                public Boolean invoke(File workspace, VirtualChannel channel) throws IOException {
                    GitAPI git = new GitAPI(gitExe, workspacePath, (TaskListener)listener, environment);
                    String buildnumber = "hudson-" + projectName + "-" + buildNumber;
                    git.deleteTag(buildnumber);
                    buildnumber = buildnumber + "-" + buildResult.toString();
                    git.tag(buildnumber, "Hudson Build #" + buildNumber);
                    PreBuildMergeOptions mergeOptions = gitSCM.getMergeOptions();
                    if (mergeOptions.doMerge() && buildResult.isBetterOrEqualTo(Result.SUCCESS)) {
                        RemoteConfig remote = mergeOptions.getMergeRemote();
                        listener.getLogger().println("Pushing result " + buildnumber + " to " + mergeOptions.getMergeTarget() + " branch of " + remote.getName() + " repository");
                        git.push(remote, "HEAD:" + mergeOptions.getMergeTarget());
                    }
                    return true;
                }
            });
        }
        catch (Throwable e) {
            listener.error("Failed to push tags to origin repository: " + e.getMessage());
            build.setResult(Result.FAILURE);
            return false;
        }
        return canPerform;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(GitPublisher.class);
        }

        public String getDisplayName() {
            return "Push Merges back to origin";
        }

        public String getHelpFile() {
            return "/plugin/git/gitPublisher.html";
        }

        public void doCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator.WorkspaceFileMask(req, rsp).process();
        }

        public GitPublisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new GitPublisher();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

