/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitAPI;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitException;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Revision;
import hudson.plugins.git.SubmoduleCombinator;
import hudson.plugins.git.SubmoduleConfig;
import hudson.plugins.git.browser.GitWeb;
import hudson.plugins.git.opt.PreBuildMergeOptions;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.GitUtils;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.util.FormFieldValidator;
import hudson.util.FormValidation;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.RepositoryConfig;
import org.spearce.jgit.transport.RefSpec;
import org.spearce.jgit.transport.RemoteConfig;
import org.spearce.jgit.transport.URIish;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitSCM
extends SCM
implements Serializable {
    @Deprecated
    transient String source;
    @Deprecated
    transient String branch;
    private Long configVersion;
    private List<RemoteConfig> remoteRepositories;
    private List<BranchSpec> branches;
    private PreBuildMergeOptions mergeOptions;
    private boolean doGenerateSubmoduleConfigurations;
    private boolean clean;
    private GitWeb browser;
    private Collection<SubmoduleConfig> submoduleCfg;
    private static final long serialVersionUID = 1L;

    public Collection<SubmoduleConfig> getSubmoduleCfg() {
        return this.submoduleCfg;
    }

    public void setSubmoduleCfg(Collection<SubmoduleConfig> submoduleCfg) {
        this.submoduleCfg = submoduleCfg;
    }

    @DataBoundConstructor
    public GitSCM(List<RemoteConfig> repositories, List<BranchSpec> branches, PreBuildMergeOptions mergeOptions, boolean doGenerateSubmoduleConfigurations, Collection<SubmoduleConfig> submoduleCfg, boolean clean, GitWeb browser) {
        this.branches = branches;
        this.remoteRepositories = repositories;
        this.browser = browser;
        this.mergeOptions = mergeOptions;
        this.doGenerateSubmoduleConfigurations = doGenerateSubmoduleConfigurations;
        this.submoduleCfg = submoduleCfg;
        this.clean = clean;
        this.configVersion = 1L;
    }

    public Object readResolve() {
        if (this.configVersion == null) {
            this.configVersion = 0L;
        }
        if (this.source != null) {
            this.remoteRepositories = new ArrayList<RemoteConfig>();
            this.branches = new ArrayList<BranchSpec>();
            this.doGenerateSubmoduleConfigurations = false;
            this.mergeOptions = new PreBuildMergeOptions();
            try {
                this.remoteRepositories.add(this.newRemoteConfig("origin", this.source, new RefSpec("+refs/heads/*:refs/remotes/origin/*")));
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
            if (this.branch != null) {
                this.branches.add(new BranchSpec(this.branch));
            } else {
                this.branches.add(new BranchSpec("*/master"));
            }
        }
        if (this.configVersion < 1L && this.branches != null) {
            for (BranchSpec branchSpec : this.branches) {
                String name = branchSpec.getName();
                name = name.replace("*", "**");
                branchSpec.setName(name);
            }
        }
        if (this.mergeOptions.doMerge() && this.mergeOptions.getMergeRemote() == null) {
            this.mergeOptions.setMergeRemote(this.remoteRepositories.get(0));
        }
        return this;
    }

    public GitWeb getBrowser() {
        return this.browser;
    }

    public boolean getClean() {
        return this.clean;
    }

    public List<RemoteConfig> getRepositories() {
        if (this.remoteRepositories == null) {
            return new ArrayList<RemoteConfig>();
        }
        return this.remoteRepositories;
    }

    private String getSingleBranch(AbstractBuild<?, ?> build) {
        if (this.getBranches().size() != 1 || this.getRepositories().size() != 1) {
            return null;
        }
        String branch = this.getBranches().get(0).getName();
        String repository = this.getRepositories().get(0).getName();
        if (branch.startsWith("*/")) {
            branch = repository + branch.substring(1);
        }
        if (branch.contains("*")) {
            return null;
        }
        ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
        if (parameters != null) {
            branch = parameters.substitute(build, branch);
        }
        return branch;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, final TaskListener listener) throws IOException, InterruptedException {
        BuildData buildData;
        final String gitExe = this.getDescriptor().getGitExe();
        AbstractBuild lastBuild = (AbstractBuild)project.getLastBuild();
        if (lastBuild != null) {
            listener.getLogger().println("[poll] Last Build : #" + lastBuild.getNumber());
        }
        if ((buildData = this.getBuildData((Run)lastBuild, false)) != null && buildData.lastBuild != null) {
            listener.getLogger().println("[poll] Last Built Revision: " + buildData.lastBuild.revision);
        }
        final String singleBranch = this.getSingleBranch(lastBuild);
        EnvVars tmp = new EnvVars();
        try {
            tmp = Computer.currentComputer().getEnvironment();
        }
        catch (InterruptedException e) {
            listener.error("Interrupted exception getting environment .. trying empty environment");
        }
        final EnvVars environment = tmp;
        boolean pollChangesResult = (Boolean)workspace.act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(){
            private static final long serialVersionUID = 1L;

            public Boolean invoke(File localWorkspace, VirtualChannel channel) throws IOException {
                GitAPI git = new GitAPI(gitExe, new FilePath(localWorkspace), listener, environment);
                BuildChooser buildChooser = new BuildChooser(GitSCM.this, git, new GitUtils(listener, git), buildData);
                if (git.hasGitRepo()) {
                    listener.getLogger().println("Fetching changes from the remote Git repositories");
                    for (RemoteConfig remoteRepository : GitSCM.this.getRepositories()) {
                        GitSCM.this.fetchFrom(git, localWorkspace, listener, remoteRepository);
                    }
                    listener.getLogger().println("Polling for changes in");
                    Collection<Revision> candidates = buildChooser.getCandidateRevisions(true, singleBranch);
                    return candidates.size() > 0;
                }
                listener.getLogger().println("No Git repository yet, an initial checkout is required");
                return true;
            }
        });
        return pollChangesResult;
    }

    private void fetchFrom(IGitAPI git, File workspace, TaskListener listener, RemoteConfig remoteRepository) {
        try {
            git.fetch(remoteRepository);
            List<IndexEntry> submodules = new GitUtils(listener, git).getSubmodules("HEAD");
            for (IndexEntry submodule : submodules) {
                try {
                    RemoteConfig submoduleRemoteRepository = this.getSubmoduleRepository(remoteRepository, submodule.getFile());
                    File subdir = new File(workspace, submodule.getFile());
                    GitAPI subGit = new GitAPI(git.getGitExe(), new FilePath(subdir), listener, git.getEnvironment());
                    subGit.fetch(submoduleRemoteRepository);
                }
                catch (Exception ex) {
                    listener.error("Problem fetching from " + remoteRepository.getName() + " - could be unavailable. Continuing anyway");
                }
            }
        }
        catch (GitException ex) {
            listener.error("Problem fetching from " + remoteRepository.getName() + " / " + remoteRepository.getName() + " - could be unavailable. Continuing anyway");
        }
    }

    public RemoteConfig getSubmoduleRepository(RemoteConfig orig, String name) throws URISyntaxException {
        String refUrl = ((URIish)orig.getURIs().get(0)).toString();
        if (refUrl.endsWith("/.git")) {
            refUrl = refUrl.substring(0, refUrl.length() - 4);
        }
        if (!refUrl.endsWith("/")) {
            refUrl = refUrl + "/";
        }
        if (!(refUrl = refUrl + name).endsWith("/")) {
            refUrl = refUrl + "/";
        }
        refUrl = refUrl + ".git";
        return this.newRemoteConfig(name, refUrl, (RefSpec)orig.getFetchRefSpecs().get(0));
    }

    private RemoteConfig newRemoteConfig(String name, String refUrl, RefSpec refSpec) throws URISyntaxException {
        File temp = null;
        try {
            temp = File.createTempFile("tmp", "config");
            RepositoryConfig repoConfig = new RepositoryConfig(null, temp);
            repoConfig.setString("remote", name, "url", refUrl);
            repoConfig.setString("remote", name, "fetch", refSpec.toString());
            repoConfig.save();
            RemoteConfig remoteConfig = (RemoteConfig)RemoteConfig.getAllRemoteConfigs((RepositoryConfig)repoConfig).get(0);
            return remoteConfig;
        }
        catch (Exception ex) {
            throw new GitException("Error creating temp file");
        }
        finally {
            if (temp != null) {
                temp.delete();
            }
        }
    }

    private boolean changeLogResult(String changeLog, File changelogFile) throws IOException {
        if (changeLog == null) {
            return false;
        }
        changelogFile.delete();
        FileOutputStream fos = new FileOutputStream(changelogFile);
        fos.write(changeLog.getBytes());
        fos.close();
        return true;
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, final BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        Revision parentLastBuiltRev;
        Revision revToBuild;
        BuildData parentBuildData;
        MatrixBuild parentBuild;
        listener.getLogger().println("Checkout:" + workspace.getName() + " / " + workspace.getRemote() + " - " + workspace.getChannel());
        String projectName = build.getProject().getName();
        final int buildNumber = build.getNumber();
        final String gitExe = this.getDescriptor().getGitExe();
        final String buildnumber = "hudson-" + projectName + "-" + buildNumber;
        final BuildData buildData = this.getBuildData(build.getPreviousBuild(), true);
        if (buildData != null && buildData.lastBuild != null) {
            listener.getLogger().println("Last Built Revision: " + buildData.lastBuild.revision);
        }
        EnvVars tmp = new EnvVars();
        try {
            tmp = build.getEnvironment((TaskListener)listener);
        }
        catch (InterruptedException e) {
            listener.error("Interrupted exception getting environment .. using empty environment");
        }
        final EnvVars environment = tmp;
        String singleBranch = this.getSingleBranch(build);
        Revision tempParentLastBuiltRev = null;
        if (build instanceof MatrixRun && (parentBuild = ((MatrixRun)build).getParentBuild()) != null && (parentBuildData = (BuildData)parentBuild.getAction(BuildData.class)) != null) {
            tempParentLastBuiltRev = parentBuildData.getLastBuiltRevision();
        }
        if ((revToBuild = (Revision)workspace.act((FilePath.FileCallable)new FilePath.FileCallable<Revision>(parentLastBuiltRev = tempParentLastBuiltRev, buildData, singleBranch){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ Revision val$parentLastBuiltRev;
            final /* synthetic */ BuildData val$buildData;
            final /* synthetic */ String val$singleBranch;
            {
                this.val$parentLastBuiltRev = revision;
                this.val$buildData = buildData;
                this.val$singleBranch = string2;
            }

            public Revision invoke(File localWorkspace, VirtualChannel channel) throws IOException {
                FilePath ws = new FilePath(localWorkspace);
                listener.getLogger().println("Checkout:" + ws.getName() + " / " + ws.getRemote() + " - " + ws.getChannel());
                GitAPI git = new GitAPI(gitExe, ws, (TaskListener)listener, environment);
                if (git.hasGitRepo()) {
                    listener.getLogger().println("Fetching changes from the remote Git repository");
                    for (RemoteConfig remoteRepository : GitSCM.this.getRepositories()) {
                        GitSCM.this.fetchFrom(git, localWorkspace, (TaskListener)listener, remoteRepository);
                    }
                } else {
                    listener.getLogger().println("Cloning the remote Git repository");
                    boolean successfullyCloned = false;
                    for (RemoteConfig rc : GitSCM.this.remoteRepositories) {
                        try {
                            git.clone(rc);
                            successfullyCloned = true;
                            break;
                        }
                        catch (GitException ex) {
                            listener.error("Error cloning remote repo '%s' : %s", new Object[]{rc.getName(), ex.getMessage()});
                            if (ex.getCause() != null) {
                                listener.error("Cause: %s", new Object[]{ex.getCause().getMessage()});
                            }
                            listener.getLogger().println("Trying next repository");
                        }
                    }
                    if (!successfullyCloned) {
                        listener.error("Could not clone from a repository");
                        throw new GitException("Could not clone");
                    }
                    for (RemoteConfig remoteRepository : GitSCM.this.getRepositories()) {
                        GitSCM.this.fetchFrom(git, localWorkspace, (TaskListener)listener, remoteRepository);
                    }
                    if (git.hasGitModules()) {
                        git.submoduleInit();
                        git.submoduleUpdate();
                    }
                }
                if (this.val$parentLastBuiltRev != null) {
                    return this.val$parentLastBuiltRev;
                }
                BuildChooser buildChooser = new BuildChooser(GitSCM.this, git, new GitUtils((TaskListener)listener, git), this.val$buildData);
                Collection<Revision> candidates = buildChooser.getCandidateRevisions(false, this.val$singleBranch);
                if (candidates.size() == 0) {
                    return null;
                }
                return candidates.iterator().next();
            }
        })) == null) {
            listener.error("Nothing to do");
            return false;
        }
        listener.getLogger().println("Commencing build of " + revToBuild);
        if (this.mergeOptions.doMerge() && !revToBuild.containsBranchName(this.mergeOptions.getRemoteBranchName())) {
            Object[] returnData = (Object[])workspace.act((FilePath.FileCallable)new FilePath.FileCallable<Object[]>(){
                private static final long serialVersionUID = 1L;

                public Object[] invoke(File localWorkspace, VirtualChannel channel) throws IOException {
                    GitAPI git = new GitAPI(gitExe, new FilePath(localWorkspace), (TaskListener)listener, environment);
                    BuildChooser buildChooser = new BuildChooser(GitSCM.this, git, new GitUtils((TaskListener)listener, git), buildData);
                    listener.getLogger().println("Merging " + revToBuild + " onto " + GitSCM.this.mergeOptions.getMergeTarget());
                    ObjectId target = git.revParse(GitSCM.this.mergeOptions.getRemoteBranchName());
                    git.checkout(target.name());
                    try {
                        git.merge(revToBuild.getSha1().name());
                    }
                    catch (Exception ex) {
                        listener.getLogger().println("Branch not suitable for integration as it does not merge cleanly");
                        git.checkout(revToBuild.getSha1().name());
                        git.tag(buildnumber, "Hudson Build #" + buildNumber);
                        buildChooser.revisionBuilt(revToBuild, buildNumber, Result.FAILURE);
                        return new Object[]{null, buildChooser.getData()};
                    }
                    if (git.hasGitModules()) {
                        git.submoduleUpdate();
                    }
                    git.tag(buildnumber, "Hudson Build #" + buildNumber);
                    StringBuilder changeLog = new StringBuilder();
                    if (revToBuild.getBranches().size() > 0) {
                        listener.getLogger().println("Warning : There are multiple branch changesets here");
                    }
                    try {
                        for (Branch b : revToBuild.getBranches()) {
                            Build lastRevWas = buildData == null ? null : buildData.getLastBuildOfBranch(b.getName());
                            if (lastRevWas == null) continue;
                            changeLog.append(GitSCM.this.putChangelogDiffsIntoFile(git, b.name, lastRevWas.getSHA1().name(), revToBuild.getSha1().name()));
                        }
                    }
                    catch (GitException ge) {
                        changeLog.append("Unable to retrieve changeset");
                    }
                    Build buildData2 = buildChooser.revisionBuilt(revToBuild, buildNumber, null);
                    GitUtils gu = new GitUtils((TaskListener)listener, git);
                    buildData2.mergeRevision = gu.getRevisionForSHA1(target);
                    return new Object[]{changeLog.toString(), buildChooser.getData()};
                }
            });
            BuildData returningBuildData = (BuildData)returnData[1];
            build.addAction((Action)returningBuildData);
            return this.changeLogResult((String)returnData[0], changelogFile);
        }
        Object[] returnData = (Object[])workspace.act((FilePath.FileCallable)new FilePath.FileCallable<Object[]>(){
            private static final long serialVersionUID = 1L;

            public Object[] invoke(File localWorkspace, VirtualChannel channel) throws IOException {
                GitAPI git = new GitAPI(gitExe, new FilePath(localWorkspace), (TaskListener)listener, environment);
                BuildChooser buildChooser = new BuildChooser(GitSCM.this, git, new GitUtils((TaskListener)listener, git), buildData);
                listener.getLogger().println("Checking out " + revToBuild);
                git.checkout(revToBuild.getSha1().name());
                if (GitSCM.this.doGenerateSubmoduleConfigurations) {
                    SubmoduleCombinator combinator = new SubmoduleCombinator(git, (TaskListener)listener, localWorkspace, GitSCM.this.submoduleCfg);
                    combinator.createSubmoduleCombinations();
                }
                if (git.hasGitModules()) {
                    git.submoduleInit();
                    for (RemoteConfig remoteRepository : GitSCM.this.getRepositories()) {
                        GitSCM.this.fetchFrom(git, localWorkspace, (TaskListener)listener, remoteRepository);
                    }
                    git.submoduleUpdate();
                }
                git.tag(buildnumber, "Hudson Build #" + buildNumber);
                StringBuilder changeLog = new StringBuilder();
                int histories = 0;
                try {
                    for (Branch b : revToBuild.getBranches()) {
                        Build lastRevWas;
                        Build build = lastRevWas = buildData == null ? null : buildData.getLastBuildOfBranch(b.getName());
                        if (lastRevWas != null) {
                            listener.getLogger().println("Recording changes in branch " + b.getName());
                            changeLog.append(GitSCM.this.putChangelogDiffsIntoFile(git, b.name, lastRevWas.getSHA1().name(), revToBuild.getSha1().name()));
                            ++histories;
                            continue;
                        }
                        listener.getLogger().println("No change to record in branch " + b.getName());
                    }
                }
                catch (GitException ge) {
                    changeLog.append("Unable to retrieve changeset");
                }
                if (histories > 1) {
                    listener.getLogger().println("Warning : There are multiple branch changesets here");
                }
                buildChooser.revisionBuilt(revToBuild, buildNumber, null);
                if (GitSCM.this.getClean()) {
                    listener.getLogger().println("Cleaning workspace");
                    git.clean();
                }
                return new Object[]{changeLog.toString(), buildChooser.getData()};
            }
        });
        build.addAction((Action)returnData[1]);
        return this.changeLogResult((String)returnData[0], changelogFile);
    }

    private String putChangelogDiffsIntoFile(IGitAPI git, String branchName, String revFrom, String revTo) throws IOException {
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        String changeset = "Changes in branch " + branchName + ", between " + revFrom + " and " + revTo + "\n";
        fos.write(changeset.getBytes());
        git.changelog(revFrom, revTo, fos);
        fos.close();
        return fos.toString();
    }

    public ChangeLogParser createChangeLogParser() {
        return new GitChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public boolean getDoGenerate() {
        return this.doGenerateSubmoduleConfigurations;
    }

    public List<BranchSpec> getBranches() {
        return this.branches;
    }

    public PreBuildMergeOptions getMergeOptions() {
        return this.mergeOptions;
    }

    public BuildData getBuildData(Run build, boolean clone) {
        BuildData buildData = null;
        while (build != null && (buildData = (BuildData)build.getAction(BuildData.class)) == null) {
            build = build.getPreviousBuild();
        }
        if (buildData == null) {
            return null;
        }
        if (clone) {
            return buildData.clone();
        }
        return buildData;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends SCMDescriptor<GitSCM> {
        private String gitExe;

        public DescriptorImpl() {
            super(GitSCM.class, GitWeb.class);
            this.load();
        }

        public String getDisplayName() {
            return "Git";
        }

        public String getGitExe() {
            if (this.gitExe == null) {
                return "git";
            }
            return this.gitExe;
        }

        public SCM newInstance(StaplerRequest req) throws Descriptor.FormException {
            List remoteRepositories;
            File temp;
            try {
                temp = File.createTempFile("tmp", "config");
            }
            catch (IOException e1) {
                throw new GitException("Error creating repositories", e1);
            }
            RepositoryConfig repoConfig = new RepositoryConfig(null, temp);
            String[] urls = req.getParameterValues("git.repo.url");
            String[] names = req.getParameterValues("git.repo.name");
            names = GitUtils.fixupNames(names, urls);
            String[] refs = req.getParameterValues("git.repo.refspec");
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    String name = names[i];
                    name = name.replace(' ', '_');
                    if (refs[i] == null || refs[i].length() == 0) {
                        refs[i] = "+refs/heads/*:refs/remotes/" + name + "/*";
                    }
                    repoConfig.setString("remote", name, "url", urls[i]);
                    repoConfig.setString("remote", name, "fetch", refs[i]);
                }
            }
            try {
                repoConfig.save();
                remoteRepositories = RemoteConfig.getAllRemoteConfigs((RepositoryConfig)repoConfig);
            }
            catch (Exception e) {
                throw new GitException("Error creating repositories", e);
            }
            temp.delete();
            ArrayList<BranchSpec> branches = new ArrayList<BranchSpec>();
            String[] branchData = req.getParameterValues("git.branch");
            for (int i = 0; i < branchData.length; ++i) {
                branches.add(new BranchSpec(branchData[i]));
            }
            if (branches.size() == 0) {
                branches.add(new BranchSpec("*/master"));
            }
            PreBuildMergeOptions mergeOptions = new PreBuildMergeOptions();
            if (req.getParameter("git.doMerge") != null && req.getParameter("git.doMerge").trim().length() > 0) {
                RemoteConfig mergeRemote = null;
                String mergeRemoteName = req.getParameter("git.mergeRemote").trim();
                if (mergeRemoteName.length() == 0) {
                    mergeRemote = (RemoteConfig)remoteRepositories.get(0);
                } else {
                    for (RemoteConfig remote : remoteRepositories) {
                        if (!remote.getName().equals(mergeRemoteName)) continue;
                        mergeRemote = remote;
                        break;
                    }
                }
                if (mergeRemote == null) {
                    throw new Descriptor.FormException("No remote repository configured with name '" + mergeRemoteName + "'", "git.mergeRemote");
                }
                mergeOptions.setMergeRemote(mergeRemote);
                mergeOptions.setMergeTarget(req.getParameter("git.mergeTarget"));
            }
            ArrayList<SubmoduleConfig> submoduleCfg = new ArrayList<SubmoduleConfig>();
            GitWeb gitWeb = null;
            String gitWebUrl = req.getParameter("gitweb.url");
            if (gitWebUrl != null && gitWebUrl.length() > 0) {
                try {
                    gitWeb = new GitWeb(gitWebUrl);
                }
                catch (MalformedURLException e) {
                    throw new GitException("Error creating GitWeb", e);
                }
            }
            return new GitSCM(remoteRepositories, branches, mergeOptions, req.getParameter("git.generate") != null, submoduleCfg, req.getParameter("git.clean") != null, gitWeb);
        }

        public boolean configure(StaplerRequest req) throws Descriptor.FormException {
            this.gitExe = req.getParameter("git.gitExe");
            this.save();
            return true;
        }

        public void doGitExeCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator.Executable(req, rsp){

                protected void checkExecutable(File exe) throws IOException, ServletException {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        Proc proc = Hudson.getInstance().createLauncher(TaskListener.NULL).launch(new String[]{DescriptorImpl.this.getGitExe(), "--version"}, new String[0], (OutputStream)baos, null);
                        proc.join();
                        this.ok();
                    }
                    catch (InterruptedException e) {
                        this.error("Unable to check git version");
                    }
                    catch (RuntimeException e) {
                        this.error("Unable to check git version");
                    }
                }
            }.process();
        }

        public FormValidation doGitRemoteNameCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            String mergeRemoteName = req.getParameter("value");
            if (mergeRemoteName.length() == 0) {
                return FormValidation.ok();
            }
            String[] urls = req.getParameterValues("git.repo.url");
            String[] names = req.getParameterValues("git.repo.name");
            for (String name : names = GitUtils.fixupNames(names, urls)) {
                if (!name.equals(mergeRemoteName)) continue;
                return FormValidation.ok();
            }
            return FormValidation.error((String)("No remote repository configured with name '" + mergeRemoteName + "'"));
        }
    }
}

