/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.git.GitPublisher;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitPublisher
extends Recorder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long configVersion;
    private boolean pushMerge;
    private List<TagToPush> tagsToPush;
    private List<BranchToPush> branchesToPush;

    @DataBoundConstructor
    public GitPublisher(List<TagToPush> tagsToPush, List<BranchToPush> branchesToPush, boolean pushMerge) {
        this.tagsToPush = tagsToPush;
        this.branchesToPush = branchesToPush;
        this.pushMerge = pushMerge;
        this.configVersion = 1L;
    }

    public boolean isPushMerge() {
        return this.pushMerge;
    }

    public boolean isPushTags() {
        if (this.tagsToPush == null) {
            return false;
        }
        return !this.tagsToPush.isEmpty();
    }

    public boolean isPushBranches() {
        if (this.branchesToPush == null) {
            return false;
        }
        return !this.branchesToPush.isEmpty();
    }

    public List<TagToPush> getTagsToPush() {
        if (this.tagsToPush == null) {
            this.tagsToPush = new ArrayList();
        }
        return this.tagsToPush;
    }

    public List<BranchToPush> getBranchesToPush() {
        if (this.branchesToPush == null) {
            this.branchesToPush = new ArrayList();
        }
        return this.branchesToPush;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        String targetRepo;
        EnvVars tempEnvironment;
        SCM scm = build.getProject().getScm();
        if (!(scm instanceof GitSCM)) {
            return false;
        }
        GitSCM gitSCM = (GitSCM)scm;
        String projectName = build.getProject().getName();
        FilePath workspacePath = build.getWorkspace();
        int buildNumber = build.getNumber();
        Result buildResult = build.getResult();
        String gitExe = gitSCM.getGitExe(build.getBuiltOn(), (TaskListener)listener);
        try {
            tempEnvironment = build.getEnvironment((TaskListener)listener);
        }
        catch (IOException e) {
            listener.error("IOException publishing in git plugin");
            tempEnvironment = new EnvVars();
        }
        EnvVars environment = tempEnvironment;
        FilePath workingDirectory = gitSCM.workingDirectory(workspacePath);
        boolean pushResult = true;
        if (this.pushMerge) {
            boolean mergeResult;
            try {
                mergeResult = (Boolean)workingDirectory.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Throwable e) {
                listener.error("Failed to push merge to origin repository: " + e.getMessage());
                build.setResult(Result.FAILURE);
                mergeResult = false;
            }
            if (!mergeResult) {
                pushResult = false;
            }
        }
        if (this.isPushTags()) {
            boolean allTagsResult = true;
            for (TagToPush t : this.tagsToPush) {
                boolean tagResult = true;
                if (t.getTagName() == null) {
                    listener.getLogger().println("No tag to push defined");
                    tagResult = false;
                }
                if (t.getTargetRepoName() == null) {
                    listener.getLogger().println("No target repo to push to defined");
                    tagResult = false;
                }
                if (tagResult) {
                    String tagName = environment.expand(t.getTagName());
                    targetRepo = environment.expand(t.getTargetRepoName());
                    try {
                        tagResult = (Boolean)workingDirectory.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
                    }
                    catch (Throwable e) {
                        listener.error("Failed to push tag " + tagName + " to " + targetRepo + ": " + e.getMessage());
                        build.setResult(Result.FAILURE);
                        tagResult = false;
                    }
                }
                if (tagResult) continue;
                allTagsResult = false;
            }
            if (!allTagsResult) {
                pushResult = false;
            }
        }
        if (this.isPushBranches()) {
            boolean allBranchesResult = true;
            for (BranchToPush b : this.branchesToPush) {
                boolean branchResult = true;
                if (b.getBranchName() == null) {
                    listener.getLogger().println("No branch to push defined");
                    return false;
                }
                if (b.getTargetRepoName() == null) {
                    listener.getLogger().println("No branch repo to push to defined");
                    return false;
                }
                String branchName = environment.expand(b.getBranchName());
                targetRepo = environment.expand(b.getTargetRepoName());
                if (branchResult) {
                    try {
                        branchResult = (Boolean)workingDirectory.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
                    }
                    catch (Throwable e) {
                        listener.error("Failed to push branch " + branchName + " to " + targetRepo + ": " + e.getMessage());
                        build.setResult(Result.FAILURE);
                        branchResult = false;
                    }
                }
                if (branchResult) continue;
                allBranchesResult = false;
            }
            if (!allBranchesResult) {
                pushResult = false;
            }
        }
        return pushResult;
    }

    private Object readResolve() {
        if (this.configVersion == null) {
            this.configVersion = 0L;
        }
        if (this.tagsToPush == null) {
            this.pushMerge = true;
        }
        return this;
    }
}

