/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.git.GitAPI;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.opt.PreBuildMergeOptions;
import hudson.remoting.VirtualChannel;
import hudson.scm.SCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.spearce.jgit.transport.RemoteConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitPublisher
extends Recorder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long configVersion;
    private boolean pushMerge;
    private List<TagToPush> tagsToPush;
    private List<BranchToPush> branchesToPush;

    @DataBoundConstructor
    public GitPublisher(List<TagToPush> tagsToPush, List<BranchToPush> branchesToPush, boolean pushMerge) {
        this.tagsToPush = tagsToPush;
        this.branchesToPush = branchesToPush;
        this.pushMerge = pushMerge;
        this.configVersion = 1L;
    }

    public boolean isPushMerge() {
        return this.pushMerge;
    }

    public boolean isPushTags() {
        if (this.tagsToPush == null) {
            return false;
        }
        return !this.tagsToPush.isEmpty();
    }

    public boolean isPushBranches() {
        if (this.branchesToPush == null) {
            return false;
        }
        return !this.branchesToPush.isEmpty();
    }

    public List<TagToPush> getTagsToPush() {
        if (this.tagsToPush == null) {
            this.tagsToPush = new ArrayList<TagToPush>();
        }
        return this.tagsToPush;
    }

    public List<BranchToPush> getBranchesToPush() {
        if (this.branchesToPush == null) {
            this.branchesToPush = new ArrayList<BranchToPush>();
        }
        return this.branchesToPush;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, final BuildListener listener) throws InterruptedException {
        String targetRepo;
        EnvVars tempEnvironment;
        SCM scm = build.getProject().getScm();
        if (!(scm instanceof GitSCM)) {
            return false;
        }
        final GitSCM gitSCM = (GitSCM)scm;
        final String projectName = build.getProject().getName();
        FilePath workspacePath = build.getWorkspace();
        final int buildNumber = build.getNumber();
        final Result buildResult = build.getResult();
        final String gitExe = gitSCM.getGitExe(build.getBuiltOn(), (TaskListener)listener);
        try {
            tempEnvironment = build.getEnvironment((TaskListener)listener);
        }
        catch (IOException e) {
            listener.error("IOException publishing in git plugin");
            tempEnvironment = new EnvVars();
        }
        final EnvVars environment = tempEnvironment;
        FilePath workingDirectory = gitSCM.workingDirectory(workspacePath);
        boolean pushResult = true;
        if (this.pushMerge) {
            boolean mergeResult;
            try {
                mergeResult = (Boolean)workingDirectory.act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(){
                    private static final long serialVersionUID = 1L;

                    public Boolean invoke(File workspace, VirtualChannel channel) throws IOException {
                        GitAPI git = new GitAPI(gitExe, new FilePath(workspace), (TaskListener)listener, environment);
                        String buildnumber = "hudson-" + projectName + "-" + buildNumber;
                        git.deleteTag(buildnumber);
                        buildnumber = buildnumber + "-" + buildResult.toString();
                        git.tag(buildnumber, "Hudson Build #" + buildNumber);
                        PreBuildMergeOptions mergeOptions = gitSCM.getMergeOptions();
                        if (mergeOptions.doMerge() && buildResult.isBetterOrEqualTo(Result.SUCCESS)) {
                            RemoteConfig remote = mergeOptions.getMergeRemote();
                            listener.getLogger().println("Pushing result " + buildnumber + " to " + mergeOptions.getMergeTarget() + " branch of " + remote.getName() + " repository");
                            git.push(remote, "HEAD:" + mergeOptions.getMergeTarget());
                        }
                        return true;
                    }
                });
            }
            catch (Throwable e) {
                listener.error("Failed to push merge to origin repository: " + e.getMessage());
                build.setResult(Result.FAILURE);
                mergeResult = false;
            }
            if (!mergeResult) {
                pushResult = false;
            }
        }
        if (this.isPushTags()) {
            boolean allTagsResult = true;
            for (final TagToPush t : this.tagsToPush) {
                boolean tagResult = true;
                if (t.getTagName() == null) {
                    listener.getLogger().println("No tag to push defined");
                    tagResult = false;
                }
                if (t.getTargetRepoName() == null) {
                    listener.getLogger().println("No target repo to push to defined");
                    tagResult = false;
                }
                if (tagResult) {
                    final String tagName = environment.expand(t.getTagName());
                    targetRepo = environment.expand(t.getTargetRepoName());
                    try {
                        tagResult = (Boolean)workingDirectory.act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(){
                            private static final long serialVersionUID = 1L;

                            public Boolean invoke(File workspace, VirtualChannel channel) throws IOException {
                                GitAPI git = new GitAPI(gitExe, new FilePath(workspace), (TaskListener)listener, environment);
                                RemoteConfig remote = gitSCM.getRepositoryByName(targetRepo);
                                if (remote == null) {
                                    listener.getLogger().println("No repository found for target repo name " + targetRepo);
                                    return false;
                                }
                                if (t.isCreateTag()) {
                                    if (git.tagExists(tagName)) {
                                        listener.getLogger().println("Tag " + tagName + " already exists and Create Tag is specified, so failing.");
                                        return false;
                                    }
                                    git.tag(tagName, "Hudson Git plugin tagging with " + tagName);
                                } else if (!git.tagExists(tagName)) {
                                    listener.getLogger().println("Tag " + tagName + " does not exist and Create Tag is not specified, so failing.");
                                    return false;
                                }
                                listener.getLogger().println("Pushing tag " + tagName + " to repo " + targetRepo);
                                git.push(remote, tagName);
                                return true;
                            }
                        });
                    }
                    catch (Throwable e) {
                        listener.error("Failed to push tag " + tagName + " to " + targetRepo + ": " + e.getMessage());
                        build.setResult(Result.FAILURE);
                        tagResult = false;
                    }
                }
                if (tagResult) continue;
                allTagsResult = false;
            }
            if (!allTagsResult) {
                pushResult = false;
            }
        }
        if (this.isPushBranches()) {
            boolean allBranchesResult = true;
            for (BranchToPush b : this.branchesToPush) {
                boolean branchResult = true;
                if (b.getBranchName() == null) {
                    listener.getLogger().println("No branch to push defined");
                    return false;
                }
                if (b.getTargetRepoName() == null) {
                    listener.getLogger().println("No branch repo to push to defined");
                    return false;
                }
                final String branchName = environment.expand(b.getBranchName());
                targetRepo = environment.expand(b.getTargetRepoName());
                if (branchResult) {
                    try {
                        branchResult = (Boolean)workingDirectory.act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(){
                            private static final long serialVersionUID = 1L;

                            public Boolean invoke(File workspace, VirtualChannel channel) throws IOException {
                                GitAPI git = new GitAPI(gitExe, new FilePath(workspace), (TaskListener)listener, environment);
                                RemoteConfig remote = gitSCM.getRepositoryByName(targetRepo);
                                if (remote == null) {
                                    listener.getLogger().println("No repository found for target repo name " + targetRepo);
                                    return false;
                                }
                                listener.getLogger().println("Pushing HEAD to branch " + branchName + " at repo " + targetRepo);
                                git.push(remote, "HEAD:" + branchName);
                                return true;
                            }
                        });
                    }
                    catch (Throwable e) {
                        listener.error("Failed to push branch " + branchName + " to " + targetRepo + ": " + e.getMessage());
                        build.setResult(Result.FAILURE);
                        branchResult = false;
                    }
                }
                if (branchResult) continue;
                allBranchesResult = false;
            }
            if (!allBranchesResult) {
                pushResult = false;
            }
        }
        return pushResult;
    }

    private Object readResolve() {
        if (this.configVersion == null) {
            this.configVersion = 0L;
        }
        if (this.tagsToPush == null) {
            this.pushMerge = true;
        }
        return this;
    }

    public static final class TagToPush
    extends PushConfig {
        private String tagName;
        private boolean createTag;

        public String getTagName() {
            return this.tagName;
        }

        public boolean isCreateTag() {
            return this.createTag;
        }

        @DataBoundConstructor
        public TagToPush(String targetRepoName, String tagName, boolean createTag) {
            super(targetRepoName);
            this.tagName = tagName;
            this.createTag = createTag;
        }
    }

    public static final class BranchToPush
    extends PushConfig {
        private String branchName;

        public String getBranchName() {
            return this.branchName;
        }

        @DataBoundConstructor
        public BranchToPush(String targetRepoName, String branchName) {
            super(targetRepoName);
            this.branchName = branchName;
        }
    }

    public static abstract class PushConfig
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String targetRepoName;

        public PushConfig(String targetRepoName) {
            this.targetRepoName = targetRepoName;
        }

        public String getTargetRepoName() {
            return this.targetRepoName;
        }

        public void setTargetRepoName() {
            this.targetRepoName = this.targetRepoName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(GitPublisher.class);
        }

        public String getDisplayName() {
            return "Git Publisher";
        }

        public String getHelpFile() {
            return "/plugin/git/gitPublisher.html";
        }

        public FormValidation doCheck(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            return FilePath.validateFileMask((FilePath)project.getSomeWorkspace(), (String)value);
        }

        public GitPublisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (GitPublisher)req.bindJSON(GitPublisher.class, formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

