/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitRepositoryBrowser;
import hudson.scm.EditType;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * Exception performing whole class analysis ignored.
 */
public class GithubWeb
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;
    private final URL url;

    @DataBoundConstructor
    public GithubWeb(String url) throws MalformedURLException {
        this.url = GithubWeb.normalizeToEndWithSlash((URL)new URL(url));
    }

    public URL getUrl() {
        return this.url;
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        return new URL(this.url, this.url.getPath() + "commit/" + changeSet.getId().toString());
    }

    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT || path.getSrc() == null || path.getDst() == null || path.getChangeSet().getParentCommit() == null) {
            return null;
        }
        return this.getDiffLinkRegardlessOfEditType(path);
    }

    private URL getDiffLinkRegardlessOfEditType(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        ArrayList affectedPaths = new ArrayList(changeSet.getAffectedPaths());
        Collections.sort(affectedPaths);
        String pathAsString = path.getPath();
        int i = Collections.binarySearch(affectedPaths, pathAsString);
        assert (i >= 0);
        return new URL(this.getChangeSetLink(changeSet), "#diff-" + String.valueOf(i));
    }

    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType().equals(EditType.DELETE)) {
            return this.getDiffLinkRegardlessOfEditType(path);
        }
        String spec = "blob/" + path.getChangeSet().getId() + "/" + path.getPath();
        return new URL(this.url, this.url.getPath() + spec);
    }
}

