/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Environment;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Revision;
import hudson.slaves.NodeProperty;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.spearce.jgit.lib.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitUtils {
    IGitAPI git;
    TaskListener listener;

    public GitUtils(TaskListener listener, IGitAPI git) {
        this.git = git;
        this.listener = listener;
    }

    public List<IndexEntry> getSubmodules(String treeIsh) {
        List submodules = this.git.lsTree(treeIsh);
        Iterator it = submodules.iterator();
        while (it.hasNext()) {
            if (((IndexEntry)it.next()).getMode().equals("160000")) continue;
            it.remove();
        }
        return submodules;
    }

    public Collection<Revision> getAllBranchRevisions() throws GitException, IOException {
        HashMap<ObjectId, Revision> revisions = new HashMap<ObjectId, Revision>();
        List branches = this.git.getRemoteBranches();
        for (Branch b : branches) {
            Revision r = (Revision)revisions.get(b.getSHA1());
            if (r == null) {
                r = new Revision(b.getSHA1());
                revisions.put(b.getSHA1(), r);
            }
            r.getBranches().add(b);
        }
        return revisions.values();
    }

    public Revision getRevisionContainingBranch(String branchName) throws GitException, IOException {
        for (Revision revision : this.getAllBranchRevisions()) {
            for (Branch b : revision.getBranches()) {
                if (!b.getName().equals(branchName)) continue;
                return revision;
            }
        }
        return null;
    }

    public Revision getRevisionForSHA1(ObjectId sha1) throws GitException, IOException {
        for (Revision revision : this.getAllBranchRevisions()) {
            if (!revision.getSha1().equals(sha1)) continue;
            return revision;
        }
        return null;
    }

    public Collection<Revision> filterTipBranches(Collection<Revision> revisions) {
        Iterator<Revision> it = revisions.iterator();
        while (it.hasNext()) {
            Revision r = it.next();
            boolean remove = false;
            for (Revision r2 : revisions) {
                ObjectId commonAncestor;
                if (r == r2 || (commonAncestor = this.git.mergeBase(r.getSha1(), r2.getSha1())) == null || !commonAncestor.equals(r.getSha1())) continue;
                remove = true;
                break;
            }
            if (!remove) continue;
            it.remove();
        }
        return revisions;
    }

    public static EnvVars getPollEnvironment(AbstractProject p, FilePath ws, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        EnvVars env;
        AbstractBuild b = (AbstractBuild)p.getLastBuild();
        if (b != null) {
            Environment environment;
            Node lastBuiltOn = b.getBuiltOn();
            env = lastBuiltOn != null ? lastBuiltOn.toComputer().getEnvironment().overrideAll((Map)b.getCharacteristicEnvVars()) : new EnvVars(System.getenv());
            String rootUrl = Hudson.getInstance().getRootUrl();
            if (rootUrl != null) {
                env.put((Object)"HUDSON_URL", (Object)rootUrl);
                env.put((Object)"BUILD_URL", (Object)(rootUrl + b.getUrl()));
                env.put((Object)"JOB_URL", (Object)(rootUrl + p.getUrl()));
            }
            if (!env.containsKey((Object)"HUDSON_HOME")) {
                env.put((Object)"HUDSON_HOME", (Object)Hudson.getInstance().getRootDir().getPath());
            }
            if (ws != null) {
                env.put((Object)"WORKSPACE", (Object)ws.getRemote());
            }
            p.getScm().buildEnvVars(b, (Map)env);
            StreamBuildListener buildListener = new StreamBuildListener((OutputStream)listener.getLogger());
            for (NodeProperty nodeProperty : Hudson.getInstance().getGlobalNodeProperties()) {
                environment = nodeProperty.setUp(b, launcher, (BuildListener)buildListener);
                if (environment == null) continue;
                environment.buildEnvVars((Map)env);
            }
            if (lastBuiltOn != null) {
                for (NodeProperty nodeProperty : lastBuiltOn.getNodeProperties()) {
                    environment = nodeProperty.setUp(b, launcher, (BuildListener)buildListener);
                    if (environment == null) continue;
                    environment.buildEnvVars((Map)env);
                }
            }
            EnvVars.resolve((Map)env);
        } else {
            env = new EnvVars(System.getenv());
        }
        return env;
    }

    public static String[] fixupNames(String[] names, String[] urls) {
        String[] returnNames = new String[urls.length];
        HashSet<String> usedNames = new HashSet<String>();
        for (int i = 0; i < urls.length; ++i) {
            String name = names[i];
            if (name == null || name.trim().length() == 0) {
                name = "origin";
            }
            String baseName = name;
            int j = 1;
            while (usedNames.contains(name)) {
                name = baseName + j++;
            }
            usedNames.add(name);
            returnNames[i] = name;
        }
        return returnNames;
    }
}

