/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import hudson.Extension;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitException;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.BuildChooserDescriptor;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.GitUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.kohsuke.stapler.DataBoundConstructor;
import org.spearce.jgit.lib.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBuildChooser
extends BuildChooser {
    @DataBoundConstructor
    public DefaultBuildChooser() {
    }

    @Override
    public Collection<Revision> getCandidateRevisions(boolean isPollCall, String singleBranch, IGitAPI git, TaskListener listener, BuildData data) throws GitException, IOException {
        Set<String> tags;
        if (singleBranch == null || singleBranch.contains("*")) {
            return this.getAdvancedCandidateRevisions(isPollCall, new GitUtils(listener, git), data);
        }
        if (!isPollCall && singleBranch.matches("[0-9a-f]{6,40}")) {
            try {
                ObjectId sha1 = git.revParse(singleBranch);
                Revision revision = new Revision(sha1);
                revision.getBranches().add(new Branch("detached", sha1));
                return Collections.singletonList(revision);
            }
            catch (GitException e) {
                // empty catch block
            }
        }
        if (!singleBranch.contains("/") && (tags = git.getTagNames(singleBranch)).size() == 0) {
            String repository = this.gitSCM.getRepositories().get(0).getName();
            singleBranch = repository + "/" + singleBranch;
        }
        try {
            ObjectId sha1 = git.revParse(singleBranch);
            if (isPollCall && data.hasBeenBuilt(sha1)) {
                return Collections.emptyList();
            }
            Revision revision = new Revision(sha1);
            revision.getBranches().add(new Branch(singleBranch, sha1));
            return Collections.singletonList(revision);
        }
        catch (GitException e) {
            return Collections.emptyList();
        }
    }

    private Collection<Revision> getAdvancedCandidateRevisions(boolean isPollCall, GitUtils utils, BuildData data) throws GitException, IOException {
        Revision r;
        Collection<Revision> revs = utils.getAllBranchRevisions();
        Iterator<Revision> i = revs.iterator();
        while (i.hasNext()) {
            r = i.next();
            Iterator<Branch> j = r.getBranches().iterator();
            while (j.hasNext()) {
                Branch b = j.next();
                boolean keep = false;
                for (BranchSpec bspec : this.gitSCM.getBranches()) {
                    if (!bspec.matches(b.getName())) continue;
                    keep = true;
                    break;
                }
                if (keep) continue;
                j.remove();
            }
            if (r.getBranches().size() != 0) continue;
            i.remove();
        }
        revs = utils.filterTipBranches(revs);
        i = revs.iterator();
        while (i.hasNext()) {
            r = i.next();
            if (!data.hasBeenBuilt(r.getSha1())) continue;
            i.remove();
        }
        if (!isPollCall && revs.size() == 0 && data.getLastBuiltRevision() != null) {
            return Collections.singletonList(data.getLastBuiltRevision());
        }
        return revs;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildChooserDescriptor {
        public String getDisplayName() {
            return "Default";
        }

        public String getLegacyId() {
            return "Default";
        }
    }
}

