/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.plugins.git.Branch;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.spearce.jgit.lib.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean(defaultVisibility=999)
public class Revision
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -7203898556389073882L;
    ObjectId sha1;
    Collection<Branch> branches;

    public Revision(ObjectId sha1) {
        this.sha1 = sha1;
        this.branches = new ArrayList();
    }

    public Revision(ObjectId sha1, Collection<Branch> branches) {
        this.sha1 = sha1;
        this.branches = branches;
    }

    public ObjectId getSha1() {
        return this.sha1;
    }

    @Exported(name="SHA1")
    public String getSha1String() {
        return this.sha1 == null ? "" : this.sha1.name();
    }

    public void setSha1(ObjectId sha1) {
        this.sha1 = sha1;
    }

    @Exported(name="branch")
    public Collection<Branch> getBranches() {
        return this.branches;
    }

    public void setBranches(Collection<Branch> branches) {
        this.branches = branches;
    }

    public boolean containsBranchName(String name) {
        for (Branch b : this.branches) {
            if (!b.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String s = "Revision " + this.sha1.name() + " (";
        for (Branch br : this.branches) {
            s = s + br.getName() + ", ";
        }
        if (s.endsWith(", ")) {
            s = s.substring(0, s.length() - 2);
        }
        s = s + ")";
        return s;
    }

    public Revision clone() {
        Revision clone;
        try {
            clone = (Revision)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Error cloning Revision", e);
        }
        clone.branches = new ArrayList(this.branches);
        return clone;
    }
}

