/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import hudson.Extension;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.BuildChooserDescriptor;
import hudson.plugins.git.util.BuildData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import org.joda.time.DateTime;
import org.kohsuke.stapler.DataBoundConstructor;
import org.spearce.jgit.lib.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GerritBuildChooser
extends BuildChooser {
    private final String separator = "#";

    @DataBoundConstructor
    public GerritBuildChooser() {
    }

    @Override
    public Collection<Revision> getCandidateRevisions(boolean isPollCall, String singleBranch, IGitAPI git, TaskListener listener, BuildData data) throws GitException, IOException {
        Revision last = data.getLastBuiltRevision();
        String result = git.getAllLogEntries(singleBranch);
        Collection<TimedCommit> commits = this.sortRevList(result);
        Iterator<TimedCommit> i = commits.iterator();
        ArrayList<Revision> revs = new ArrayList<Revision>();
        Object lastBuilt = null;
        while (i.hasNext()) {
            TimedCommit tc = i.next();
            if (last != null && tc.commit.name().equals(last.getSha1String())) break;
            this.addToRevs(revs, tc);
        }
        if (last == null) {
            return revs;
        }
        if (revs.size() == 0 && !isPollCall) {
            return Collections.singletonList(last);
        }
        ArrayList<Revision> finalRevs = new ArrayList<Revision>();
        for (int j = revs.size() - 1; j >= 0; --j) {
            finalRevs.add(revs.get(j));
        }
        return finalRevs;
    }

    private void addToRevs(ArrayList<Revision> revs, TimedCommit tc) {
        Revision rev = new Revision(tc.commit);
        rev.getBranches().add(new Branch("timebased", rev.getSha1()));
        revs.add(rev);
    }

    private Collection<TimedCommit> sortRevList(String logOutput) {
        String[] lines;
        TreeSet<TimedCommit> timedCommits = new TreeSet<TimedCommit>();
        for (String s : lines = logOutput.split("\n")) {
            timedCommits.add(this.parseCommit(s));
        }
        return timedCommits;
    }

    private TimedCommit parseCommit(String line) {
        String[] lines = line.split("#");
        String id = lines[0].substring(1);
        String date = lines[1].substring(0, lines[1].length() - 1);
        return new TimedCommit(ObjectId.fromString((String)id), new DateTime(Long.parseLong(date) * 1000L));
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildChooserDescriptor {
        public String getDisplayName() {
            return "Gerrit";
        }

        public String getLegacyId() {
            return "Gerrit";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TimedCommit
    implements Comparable<TimedCommit> {
        private ObjectId commit;
        public DateTime when;

        public TimedCommit(ObjectId c, DateTime when) {
            this.commit = c;
            this.when = when;
        }

        public ObjectId getCommit() {
            return this.commit;
        }

        @Override
        public int compareTo(TimedCommit o) {
            int result = -this.when.compareTo((Object)o.when);
            if (result == 0) {
                return -1;
            }
            return result;
        }
    }
}

