/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitAPI;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Revision;
import hudson.plugins.git.RevisionParameterAction;
import hudson.plugins.git.SubmoduleConfig;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.opt.PreBuildMergeOptions;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.BuildChooserDescriptor;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.DefaultBuildChooser;
import hudson.plugins.git.util.GitUtils;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;
import org.spearce.jgit.lib.RepositoryConfig;
import org.spearce.jgit.transport.RefSpec;
import org.spearce.jgit.transport.RemoteConfig;
import org.spearce.jgit.transport.URIish;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class GitSCM
extends SCM
implements Serializable {
    public static final String GIT_BRANCH = "GIT_BRANCH";
    public static final String GIT_COMMIT = "GIT_COMMIT";
    private static final long serialVersionUID = 1L;
    @Deprecated
    transient String source;
    @Deprecated
    transient String branch;
    private Long configVersion;
    private List<RemoteConfig> remoteRepositories;
    private List<BranchSpec> branches;
    private String localBranch;
    private PreBuildMergeOptions mergeOptions;
    private boolean recursiveSubmodules;
    private boolean doGenerateSubmoduleConfigurations;
    private boolean authorOrCommitter;
    private boolean clean;
    private boolean wipeOutWorkspace;
    private boolean pruneBranches;
    private transient String choosingStrategy;
    private BuildChooser buildChooser;
    private String gitTool = null;
    private GitRepositoryBrowser browser;
    private Collection<SubmoduleConfig> submoduleCfg;
    private String relativeTargetDir;
    private String excludedRegions;
    private String excludedUsers;
    private String gitConfigName;
    private String gitConfigEmail;
    private boolean skipTag;
    private static final Logger LOGGER = Logger.getLogger(GitSCM.class.getName());
    public static boolean VERBOSE = Boolean.getBoolean(GitSCM.class.getName() + ".verbose");

    public Collection<SubmoduleConfig> getSubmoduleCfg() {
        return this.submoduleCfg;
    }

    public void setSubmoduleCfg(Collection<SubmoduleConfig> submoduleCfg) {
        this.submoduleCfg = submoduleCfg;
    }

    public GitSCM(String repositoryUrl) throws IOException {
        this(DescriptorImpl.createRepositoryConfigurations((String[])new String[]{repositoryUrl}, (String[])new String[]{null}, (String[])new String[]{null}), Collections.singletonList(new BranchSpec("")), new PreBuildMergeOptions(), false, Collections.emptyList(), false, false, (BuildChooser)new DefaultBuildChooser(), null, null, false, null, null, null, null, false, false, null, null, false);
    }

    @DataBoundConstructor
    public GitSCM(List<RemoteConfig> repositories, List<BranchSpec> branches, PreBuildMergeOptions mergeOptions, boolean doGenerateSubmoduleConfigurations, Collection<SubmoduleConfig> submoduleCfg, boolean clean, boolean wipeOutWorkspace, BuildChooser buildChooser, GitRepositoryBrowser browser, String gitTool, boolean authorOrCommitter, String relativeTargetDir, String excludedRegions, String excludedUsers, String localBranch, boolean recursiveSubmodules, boolean pruneBranches, String gitConfigName, String gitConfigEmail, boolean skipTag) {
        this.branches = branches;
        this.localBranch = Util.fixEmptyAndTrim((String)localBranch);
        this.remoteRepositories = repositories;
        this.browser = browser;
        this.mergeOptions = mergeOptions;
        this.doGenerateSubmoduleConfigurations = doGenerateSubmoduleConfigurations;
        this.submoduleCfg = submoduleCfg;
        this.clean = clean;
        this.wipeOutWorkspace = wipeOutWorkspace;
        this.configVersion = 1L;
        this.gitTool = gitTool;
        this.authorOrCommitter = authorOrCommitter;
        this.buildChooser = buildChooser;
        this.relativeTargetDir = relativeTargetDir;
        this.excludedRegions = excludedRegions;
        this.excludedUsers = excludedUsers;
        this.recursiveSubmodules = recursiveSubmodules;
        this.pruneBranches = pruneBranches;
        this.gitConfigName = gitConfigName;
        this.gitConfigEmail = gitConfigEmail;
        this.skipTag = skipTag;
        buildChooser.gitSCM = this;
    }

    public Object readResolve() {
        if (this.configVersion == null) {
            this.configVersion = 0L;
        }
        if (this.source != null) {
            this.remoteRepositories = new ArrayList();
            this.branches = new ArrayList();
            this.doGenerateSubmoduleConfigurations = false;
            this.mergeOptions = new PreBuildMergeOptions();
            this.recursiveSubmodules = false;
            this.remoteRepositories.add(this.newRemoteConfig("origin", this.source, new RefSpec("+refs/heads/*:refs/remotes/origin/*")));
            if (this.branch != null) {
                this.branches.add(new BranchSpec(this.branch));
            } else {
                this.branches.add(new BranchSpec("*/master"));
            }
        }
        if (this.configVersion < 1L && this.branches != null) {
            for (BranchSpec branchSpec : this.branches) {
                String name = branchSpec.getName();
                name = name.replace("*", "**");
                branchSpec.setName(name);
            }
        }
        if (this.mergeOptions.doMerge() && this.mergeOptions.getMergeRemote() == null) {
            this.mergeOptions.setMergeRemote((RemoteConfig)this.remoteRepositories.get(0));
        }
        if (this.choosingStrategy != null && this.buildChooser == null) {
            for (BuildChooserDescriptor d : BuildChooser.all()) {
                if (!this.choosingStrategy.equals(d.getLegacyId())) continue;
                try {
                    this.buildChooser = (BuildChooser)d.clazz.newInstance();
                }
                catch (InstantiationException e) {
                    LOGGER.log(Level.WARNING, "Failed to instantiate the build chooser", e);
                }
                catch (IllegalAccessException e) {
                    LOGGER.log(Level.WARNING, "Failed to instantiate the build chooser", e);
                }
            }
        }
        if (this.buildChooser == null) {
            this.buildChooser = new DefaultBuildChooser();
        }
        this.buildChooser.gitSCM = this;
        return this;
    }

    public String getExcludedRegions() {
        return this.excludedRegions;
    }

    public String[] getExcludedRegionsNormalized() {
        return this.excludedRegions == null || this.excludedRegions.trim().equals("") ? null : this.excludedRegions.split("[\\r\\n]+");
    }

    public String getExcludedUsers() {
        return this.excludedUsers;
    }

    public Set<String> getExcludedUsersNormalized() {
        String s = Util.fixEmptyAndTrim((String)this.excludedUsers);
        if (s == null) {
            return Collections.emptySet();
        }
        HashSet<String> users = new HashSet<String>();
        for (String user : s.split("[\\r\\n]+")) {
            users.add(user.trim());
        }
        return users;
    }

    public GitRepositoryBrowser getBrowser() {
        return this.browser;
    }

    public String getGitConfigName() {
        return this.gitConfigName;
    }

    public String getGitConfigEmail() {
        return this.gitConfigEmail;
    }

    public String getGitConfigNameToUse() {
        String globalConfigName = ((DescriptorImpl)this.getDescriptor()).getGlobalConfigName();
        String confName = globalConfigName != null && this.gitConfigName == null && !Util.fixEmptyAndTrim((String)globalConfigName).equals("") ? globalConfigName : this.gitConfigName;
        return Util.fixEmptyAndTrim((String)confName);
    }

    public String getGitConfigEmailToUse() {
        String globalConfigEmail = ((DescriptorImpl)this.getDescriptor()).getGlobalConfigEmail();
        String confEmail = globalConfigEmail != null && this.gitConfigEmail == null && !Util.fixEmptyAndTrim((String)globalConfigEmail).equals("") ? globalConfigEmail : this.gitConfigEmail;
        return Util.fixEmptyAndTrim((String)confEmail);
    }

    public boolean getSkipTag() {
        return this.skipTag;
    }

    public boolean getPruneBranches() {
        return this.pruneBranches;
    }

    public boolean getWipeOutWorkspace() {
        return this.wipeOutWorkspace;
    }

    public boolean getClean() {
        return this.clean;
    }

    public BuildChooser getBuildChooser() {
        return this.buildChooser;
    }

    public List<RemoteConfig> getParamExpandedRepos(AbstractBuild<?, ?> build) {
        ArrayList<RemoteConfig> expandedRepos = new ArrayList<RemoteConfig>();
        for (RemoteConfig oldRepo : Util.fixNull((List)this.remoteRepositories)) {
            expandedRepos.add(this.newRemoteConfig(oldRepo.getName(), ((URIish)oldRepo.getURIs().get(0)).toPrivateString(), new RefSpec(this.getRefSpec(oldRepo, build))));
        }
        return expandedRepos;
    }

    public RemoteConfig getRepositoryByName(String repoName) {
        for (RemoteConfig r : this.getRepositories()) {
            if (!r.getName().equals(repoName)) continue;
            return r;
        }
        return null;
    }

    public List<RemoteConfig> getRepositories() {
        if (this.remoteRepositories == null) {
            return new ArrayList<RemoteConfig>();
        }
        return this.remoteRepositories;
    }

    public String getGitTool() {
        return this.gitTool;
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> abstractBuild, Launcher launcher, TaskListener taskListener) throws IOException, InterruptedException {
        return SCMRevisionState.NONE;
    }

    public RemoteConfig getSubmoduleRepository(IGitAPI parentGit, RemoteConfig orig, String name) throws GitException {
        String refUrl = parentGit.getSubmoduleUrl(name);
        return this.newRemoteConfig(name, refUrl, (RefSpec)orig.getFetchRefSpecs().get(0));
    }

    public String getGitExe(Node builtOn, TaskListener listener) {
        GitTool[] gitToolInstallations;
        for (GitTool t : gitToolInstallations = (GitTool[])((GitTool.DescriptorImpl)Hudson.getInstance().getDescriptorByType(GitTool.DescriptorImpl.class)).getInstallations()) {
            if (this.gitTool == null) {
                this.gitTool = t.getName();
            }
            if (!t.getName().equals(this.gitTool) || builtOn == null) continue;
            try {
                String s = t.forNode(builtOn, listener).getGitExe();
                return s;
            }
            catch (IOException e) {
                listener.getLogger().println("Failed to get git executable");
            }
            catch (InterruptedException e) {
                listener.getLogger().println("Failed to get git executable");
            }
        }
        return null;
    }

    public boolean getAuthorOrCommitter() {
        return this.authorOrCommitter;
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        RevisionParameterAction rpa;
        Revision parentLastBuiltRev;
        List paramRepos;
        Revision revToBuild;
        BuildData parentBuildData;
        MatrixBuild parentBuild;
        String confEmail;
        listener.getLogger().println("Checkout:" + workspace.getName() + " / " + workspace.getRemote() + " - " + workspace.getChannel());
        listener.getLogger().println("Using strategy: " + this.buildChooser.getDisplayName());
        FilePath workingDirectory = this.workingDirectory(workspace);
        if (!workingDirectory.exists()) {
            workingDirectory.mkdirs();
        }
        int buildNumber = build.getNumber();
        String gitExe = this.getGitExe(build.getBuiltOn(), (TaskListener)listener);
        String internalTagName = "hudson" + "-" + build.getProject().getName() + "-" + build.getNumber();
        String internalTagComment = "Hudson Build #" + build.getNumber();
        BuildData buildData = this.getBuildData(build.getPreviousBuild(), true);
        if (buildData.lastBuild != null) {
            listener.getLogger().println("Last Built Revision: " + buildData.lastBuild.revision);
        }
        EnvVars environment = build.getEnvironment((TaskListener)listener);
        String confName = this.getGitConfigNameToUse();
        if (confName != null && !confName.equals("")) {
            environment.put("GIT_COMMITTER_NAME", confName);
            environment.put("GIT_AUTHOR_NAME", confName);
        }
        if ((confEmail = this.getGitConfigEmailToUse()) != null && !confEmail.equals("")) {
            environment.put("GIT_COMMITTER_EMAIL", confEmail);
            environment.put("GIT_AUTHOR_EMAIL", confEmail);
        }
        String singleBranch = this.getSingleBranch(build);
        String paramLocalBranch = this.getParamLocalBranch(build);
        Revision tempParentLastBuiltRev = null;
        if (build instanceof MatrixRun && (parentBuild = ((MatrixRun)build).getParentBuild()) != null && (parentBuildData = (BuildData)parentBuild.getAction(BuildData.class)) != null) {
            tempParentLastBuiltRev = parentBuildData.getLastBuiltRevision();
        }
        if ((revToBuild = this.gerRevisionToBuild(listener, workingDirectory, gitExe, buildData, environment, singleBranch, paramRepos = this.getParamExpandedRepos(build), parentLastBuiltRev = tempParentLastBuiltRev, rpa = (RevisionParameterAction)build.getAction(RevisionParameterAction.class))) == null) {
            listener.error("Nothing to do");
            return false;
        }
        listener.getLogger().println("Commencing build of " + revToBuild);
        environment.put("GIT_COMMIT", revToBuild.getSha1String());
        if (this.mergeOptions.doMerge() && !revToBuild.containsBranchName(this.mergeOptions.getRemoteBranchName())) {
            BuildConfig buildConfig = this.getMergedBuildConfig(listener, workingDirectory, buildNumber, gitExe, buildData, environment, paramLocalBranch, revToBuild, internalTagName, internalTagComment);
            build.addAction((Action)buildConfig.getBuildData());
            return this.changeLogResult(buildConfig.getChangeLog(), changelogFile);
        }
        BuildConfig buildConfig = this.getBuildConfig(listener, workingDirectory, buildNumber, gitExe, buildData, environment, paramLocalBranch, paramRepos, revToBuild, internalTagName, internalTagComment);
        build.addAction((Action)buildConfig.getBuildData());
        return this.changeLogResult(buildConfig.getChangeLog(), changelogFile);
    }

    private BuildConfig getBuildConfig(BuildListener listener, FilePath workingDirectory, int buildNumber, String gitExe, BuildData buildData, EnvVars environment, String paramLocalBranch, List<RemoteConfig> paramRepos, Revision revToBuild, String internalTagName, String internalTagComment) throws IOException, InterruptedException {
        return (BuildConfig)workingDirectory.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private BuildConfig getMergedBuildConfig(BuildListener listener, FilePath workingDirectory, int buildNumber, String gitExe, BuildData buildData, EnvVars environment, String paramLocalBranch, Revision revToBuild, String internalTagName, String internalTagComment) throws IOException, InterruptedException {
        return (BuildConfig)workingDirectory.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Revision gerRevisionToBuild(BuildListener listener, FilePath workingDirectory, String gitExe, BuildData buildData, EnvVars environment, String singleBranch, List<RemoteConfig> paramRepos, Revision parentLastBuiltRev, RevisionParameterAction rpa) throws IOException, InterruptedException {
        return (Revision)workingDirectory.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        String commit;
        BuildData bd;
        super.buildEnvVars(build, env);
        String branch = this.getSingleBranch(build);
        if (branch != null) {
            env.put("GIT_BRANCH", branch);
        }
        if ((bd = this.fixNull(this.getBuildData(build, false))) != null && bd.getLastBuiltRevision() != null && (commit = bd.getLastBuiltRevision().getSha1String()) != null) {
            env.put("GIT_COMMIT", commit);
        }
    }

    public ChangeLogParser createChangeLogParser() {
        return new GitChangeLogParser(this.getAuthorOrCommitter());
    }

    public boolean getRecursiveSubmodules() {
        return this.recursiveSubmodules;
    }

    public boolean getDoGenerate() {
        return this.doGenerateSubmoduleConfigurations;
    }

    public List<BranchSpec> getBranches() {
        return this.branches;
    }

    public PreBuildMergeOptions getMergeOptions() {
        return this.mergeOptions;
    }

    public BuildData getBuildData(Run build, boolean clone) {
        BuildData buildData = null;
        while (build != null && (buildData = (BuildData)build.getAction(BuildData.class)) == null) {
            build = build.getPreviousBuild();
        }
        if (buildData == null) {
            return clone ? new BuildData() : null;
        }
        if (clone) {
            return buildData.clone();
        }
        return buildData;
    }

    public String getLocalBranch() {
        return Util.fixEmpty((String)this.localBranch);
    }

    public String getParamLocalBranch(AbstractBuild<?, ?> build) {
        String branch = this.getLocalBranch();
        ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
        if (parameters != null) {
            branch = parameters.substitute(build, branch);
        }
        return branch;
    }

    public String getRelativeTargetDir() {
        return this.relativeTargetDir;
    }

    protected FilePath workingDirectory(FilePath workspace) {
        if (this.relativeTargetDir == null || this.relativeTargetDir.length() == 0 || this.relativeTargetDir.equals(".")) {
            return workspace;
        }
        return workspace.child(this.relativeTargetDir);
    }

    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        String singleBranch;
        List paramRepos;
        String gitExe;
        Label label;
        listener.getLogger().println("Using strategy: " + this.buildChooser.getDisplayName());
        AbstractBuild lastBuild = (AbstractBuild)project.getLastBuild();
        if (lastBuild == null) {
            listener.getLogger().println("[poll] No previous build, so forcing an initial build.");
            return PollingResult.BUILD_NOW;
        }
        listener.getLogger().println("[poll] Last Build : #" + lastBuild.getNumber());
        BuildData buildData = this.fixNull(this.getBuildData((Run)lastBuild, false));
        if (buildData != null && buildData.lastBuild != null) {
            listener.getLogger().println("[poll] Last Built Revision: " + buildData.lastBuild.revision);
        }
        if ((label = project.getAssignedLabel()) != null && label.isSelfLabel()) {
            if (label.getNodes().iterator().next() != project.getLastBuiltOn()) {
                listener.getLogger().println("Last build was not on tied node, forcing rebuild.");
                return PollingResult.BUILD_NOW;
            }
            gitExe = this.getGitExe((Node)label.getNodes().iterator().next(), listener);
        } else {
            gitExe = this.getGitExe(project.getLastBuiltOn(), listener);
        }
        FilePath workingDirectory = this.workingDirectory(workspace);
        if (!workingDirectory.exists()) {
            return PollingResult.BUILD_NOW;
        }
        EnvVars environment = GitUtils.getPollEnvironment(project, (FilePath)workspace, (Launcher)launcher, (TaskListener)listener);
        boolean pollChangesResult = (Boolean)workingDirectory.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        return pollChangesResult ? PollingResult.SIGNIFICANT : PollingResult.NO_CHANGES;
    }

    private RemoteConfig newRemoteConfig(String name, String refUrl, RefSpec refSpec) {
        File temp = null;
        try {
            temp = File.createTempFile("tmp", "config");
            RepositoryConfig repoConfig = new RepositoryConfig(null, temp);
            repoConfig.setString("remote", name, "url", refUrl);
            repoConfig.setString("remote", name, "fetch", refSpec.toString());
            repoConfig.save();
            RemoteConfig remoteConfig = (RemoteConfig)RemoteConfig.getAllRemoteConfigs((RepositoryConfig)repoConfig).get(0);
            return remoteConfig;
        }
        catch (Exception ex) {
            throw new GitException("Error creating temp file");
        }
        finally {
            if (temp != null) {
                temp.delete();
            }
        }
    }

    private boolean changeLogResult(String changeLog, File changelogFile) throws IOException {
        if (changeLog == null) {
            return false;
        }
        changelogFile.delete();
        FileOutputStream fos = new FileOutputStream(changelogFile);
        fos.write(changeLog.getBytes());
        fos.close();
        return true;
    }

    private Pattern[] getExcludedRegionsPatterns() {
        String[] excluded = this.getExcludedRegionsNormalized();
        if (excluded != null) {
            Pattern[] patterns = new Pattern[excluded.length];
            int i = 0;
            for (String excludedRegion : excluded) {
                patterns[i++] = Pattern.compile(excludedRegion);
            }
            return patterns;
        }
        return new Pattern[0];
    }

    private String getRefSpec(RemoteConfig repo, AbstractBuild<?, ?> build) {
        String refSpec = ((RefSpec)repo.getFetchRefSpecs().get(0)).toString();
        ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
        if (parameters != null) {
            refSpec = parameters.substitute(build, refSpec);
        }
        return refSpec;
    }

    private String getSingleBranch(AbstractBuild<?, ?> build) {
        if (this.getBranches().size() != 1 || this.getRepositories().size() != 1) {
            return null;
        }
        String branch = ((BranchSpec)this.getBranches().get(0)).getName();
        String repository = ((RemoteConfig)this.getRepositories().get(0)).getName();
        if (branch.startsWith("*/")) {
            branch = repository + branch.substring(1);
        }
        if (branch.contains("*")) {
            return null;
        }
        ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
        if (parameters != null) {
            branch = parameters.substitute(build, branch);
        }
        return branch;
    }

    private BuildData fixNull(BuildData bd) {
        return bd != null ? bd : new BuildData();
    }

    private boolean fetchFrom(IGitAPI git, TaskListener listener, RemoteConfig remoteRepository) {
        try {
            git.fetch(remoteRepository);
            return true;
        }
        catch (GitException ex) {
            listener.error("Problem fetching from " + remoteRepository.getName() + " / " + remoteRepository.getName() + " - could be unavailable. Continuing anyway");
            listener.error(" (Underlying report) : " + ex.getMessage());
            return false;
        }
    }

    private boolean fetchSubmodulesFrom(IGitAPI git, File workspace, TaskListener listener, RemoteConfig remoteRepository) {
        boolean fetched = true;
        try {
            git.setupSubmoduleUrls(remoteRepository.getName(), listener);
            boolean hasHead = true;
            try {
                git.revParse("HEAD");
            }
            catch (GitException e) {
                hasHead = false;
            }
            if (hasHead) {
                List submodules = git.getSubmodules("HEAD");
                for (IndexEntry submodule : submodules) {
                    try {
                        RemoteConfig submoduleRemoteRepository = this.getSubmoduleRepository(git, remoteRepository, submodule.getFile());
                        File subdir = new File(workspace, submodule.getFile());
                        listener.getLogger().println("Trying to fetch " + submodule.getFile() + " into " + subdir);
                        GitAPI subGit = new GitAPI(git.getGitExe(), new FilePath(subdir), listener, git.getEnvironment());
                        subGit.fetch(submoduleRemoteRepository);
                    }
                    catch (Exception ex) {
                        listener.getLogger().println("Problem fetching from submodule " + submodule.getFile() + " - could be unavailable. Continuing anyway");
                    }
                }
            }
        }
        catch (GitException ex) {
            ex.printStackTrace(listener.error("Problem fetching submodules from a path relative to " + remoteRepository.getName() + " / " + remoteRepository.getName() + " - could be unavailable. Continuing anyway"));
            fetched = false;
        }
        return fetched;
    }

    private void createInternalTag(IGitAPI git, String tagName, String tagComment) {
        if (!this.getSkipTag()) {
            git.tag(tagName, tagComment);
        }
    }

    private String computeChangeLog(IGitAPI git, Revision revToBuild, BuildListener listener, BuildData buildData) throws IOException {
        int histories = 0;
        StringBuilder changeLog = new StringBuilder();
        try {
            for (Branch b : revToBuild.getBranches()) {
                Build lastRevWas = this.buildChooser.prevBuildForChangelog(b.getName(), buildData, git);
                if (lastRevWas != null) {
                    if (git.isCommitInRepo(lastRevWas.getSHA1().name())) {
                        changeLog.append(this.putChangelogDiffsIntoFile(git, b.name, lastRevWas.getSHA1().name(), revToBuild.getSha1().name()));
                        ++histories;
                        continue;
                    }
                    listener.getLogger().println("Could not record history. Previous build's commit, " + lastRevWas.getSHA1().name() + ", does not exist in the current repository.");
                    continue;
                }
                listener.getLogger().println("No change to record in branch " + b.getName());
            }
        }
        catch (GitException ge) {
            changeLog.append("Unable to retrieve changeset");
        }
        if (histories > 1) {
            listener.getLogger().println("Warning : There are multiple branch changesets here");
        }
        return changeLog.toString();
    }

    private String putChangelogDiffsIntoFile(IGitAPI git, String branchName, String revFrom, String revTo) throws IOException {
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        String changeset = "Changes in branch " + branchName + ", between " + revFrom + " and " + revTo + "\n";
        fos.write(changeset.getBytes());
        git.changelog(revFrom, revTo, (OutputStream)fos);
        fos.close();
        return fos.toString("UTF-8");
    }

    private boolean isRevExcluded(IGitAPI git, Revision r, TaskListener listener) {
        try {
            String author;
            List revShow = git.showRevision(r);
            if (revShow.size() == 0) {
                return false;
            }
            GitChangeSet change = new GitChangeSet(revShow, this.authorOrCommitter);
            Pattern[] excludedPatterns = this.getExcludedRegionsPatterns();
            Set excludedUsers = this.getExcludedUsersNormalized();
            if (excludedUsers.contains(author = change.getAuthorName())) {
                listener.getLogger().println("Ignored commit " + r.getSha1String() + ": Found excluded author: " + author);
                return true;
            }
            ArrayList paths = new ArrayList(change.getAffectedPaths());
            if (paths.isEmpty()) {
                return false;
            }
            ArrayList<String> excludedPaths = new ArrayList<String>();
            if (excludedPatterns.length > 0) {
                block2: for (String path : paths) {
                    for (Pattern pattern : excludedPatterns) {
                        if (!pattern.matcher(path).matches()) continue;
                        excludedPaths.add(path);
                        continue block2;
                    }
                }
            }
            if (paths.size() == excludedPaths.size()) {
                listener.getLogger().println("Ignored commit " + r.getSha1String() + ": Found only excluded paths: " + Util.join(excludedPaths, (String)", "));
                return true;
            }
        }
        catch (GitException e) {
            return false;
        }
        return false;
    }

    static /* synthetic */ boolean access$000(GitSCM x0) {
        return x0.recursiveSubmodules;
    }

    static /* synthetic */ boolean access$100(GitSCM x0, IGitAPI x1, File x2, TaskListener x3, RemoteConfig x4) {
        return x0.fetchSubmodulesFrom(x1, x2, x3, x4);
    }

    static /* synthetic */ boolean access$200(GitSCM x0) {
        return x0.doGenerateSubmoduleConfigurations;
    }

    static /* synthetic */ Collection access$300(GitSCM x0) {
        return x0.submoduleCfg;
    }

    static /* synthetic */ void access$400(GitSCM x0, IGitAPI x1, String x2, String x3) {
        x0.createInternalTag(x1, x2, x3);
    }

    static /* synthetic */ String access$500(GitSCM x0, IGitAPI x1, Revision x2, BuildListener x3, BuildData x4) throws IOException {
        return x0.computeChangeLog(x1, x2, x3, x4);
    }

    static /* synthetic */ PreBuildMergeOptions access$600(GitSCM x0) {
        return x0.mergeOptions;
    }

    static /* synthetic */ boolean access$700(GitSCM x0) {
        return x0.wipeOutWorkspace;
    }

    static /* synthetic */ boolean access$800(GitSCM x0) {
        return x0.pruneBranches;
    }

    static /* synthetic */ boolean access$900(GitSCM x0, IGitAPI x1, TaskListener x2, RemoteConfig x3) {
        return x0.fetchFrom(x1, x2, x3);
    }

    static /* synthetic */ BuildChooser access$1000(GitSCM x0) {
        return x0.buildChooser;
    }

    static /* synthetic */ boolean access$1100(GitSCM x0, IGitAPI x1, Revision x2, TaskListener x3) {
        return x0.isRevExcluded(x1, x2, x3);
    }
}

