/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Revision;
import hudson.remoting.VirtualChannel;
import hudson.util.ArgumentListBuilder;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.Ref;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.lib.Tag;
import org.spearce.jgit.transport.RefSpec;
import org.spearce.jgit.transport.RemoteConfig;
import org.spearce.jgit.transport.URIish;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitAPI
implements IGitAPI {
    private static final Logger LOGGER = Logger.getLogger(GitAPI.class.getName());
    Launcher launcher;
    FilePath workspace;
    TaskListener listener;
    String gitExe;
    EnvVars environment;

    public GitAPI(String gitExe, FilePath workspace, TaskListener listener, EnvVars environment) {
        this.workspace = workspace;
        this.listener = listener;
        this.gitExe = gitExe;
        this.environment = environment;
        for (Map.Entry ent : environment.entrySet()) {
        }
        this.launcher = new Launcher.LocalLauncher(GitSCM.VERBOSE ? listener : TaskListener.NULL);
    }

    @Override
    public String getGitExe() {
        return this.gitExe;
    }

    @Override
    public EnvVars getEnvironment() {
        return this.environment;
    }

    @Override
    public void init() throws GitException {
        if (this.hasGitRepo()) {
            throw new GitException(".git directory already exists! Has it already been initialised?");
        }
        try {
            Repository repo = new Repository(new File(this.workspace.child(".git").getRemote()));
            repo.create();
        }
        catch (IOException ioe) {
            throw new GitException("Error initiating git repo.", ioe);
        }
    }

    @Override
    public boolean hasGitRepo() throws GitException {
        return this.hasGitRepo(".git");
    }

    public boolean hasGitRepo(String GIT_DIR) throws GitException {
        try {
            FilePath dotGit = this.workspace.child(GIT_DIR);
            return dotGit.exists();
        }
        catch (SecurityException ex) {
            throw new GitException("Security error when trying to check for .git. Are you sure you have correct permissions?", ex);
        }
        catch (Exception e) {
            throw new GitException("Couldn't check for .git", e);
        }
    }

    @Override
    public boolean hasGitModules() throws GitException {
        try {
            FilePath dotGit = this.workspace.child(".gitmodules");
            return dotGit.exists();
        }
        catch (SecurityException ex) {
            throw new GitException("Security error when trying to check for .gitmodules. Are you sure you have correct permissions?", ex);
        }
        catch (Exception e) {
            throw new GitException("Couldn't check for .gitmodules", e);
        }
    }

    @Override
    public List<IndexEntry> getSubmodules(String treeIsh) throws GitException {
        List<IndexEntry> submodules = this.lsTree(treeIsh);
        Iterator<IndexEntry> it = submodules.iterator();
        while (it.hasNext()) {
            if (it.next().getMode().equals("160000")) continue;
            it.remove();
        }
        return submodules;
    }

    @Override
    public boolean hasGitModules(String treeIsh) throws GitException {
        return this.hasGitModules() && this.getSubmodules(treeIsh).size() > 0;
    }

    @Override
    public void fetch(String repository, String refspec) throws GitException {
        this.listener.getLogger().println("Fetching upstream changes" + (repository != null ? " from " + repository : ""));
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"fetch", "-t"});
        if (repository != null) {
            args.add(repository);
            if (refspec != null) {
                args.add(refspec);
            }
        }
        this.launchCommand(args);
    }

    @Override
    public void fetch() throws GitException {
        this.fetch(null, null);
    }

    @Override
    public void clone(final RemoteConfig remoteConfig) throws GitException {
        this.listener.getLogger().println("Cloning repository " + remoteConfig.getName());
        try {
            this.workspace.deleteRecursive();
        }
        catch (Exception e) {
            e.printStackTrace(this.listener.error("Failed to clean the workspace"));
            throw new GitException("Failed to delete workspace", e);
        }
        final String source = ((URIish)remoteConfig.getURIs().get(0)).toPrivateString();
        try {
            this.workspace.act((FilePath.FileCallable)new FilePath.FileCallable<String>(){
                private static final long serialVersionUID = 1L;

                public String invoke(File workspace, VirtualChannel channel) throws IOException {
                    ArgumentListBuilder args = new ArgumentListBuilder();
                    args.add("clone");
                    args.add(new String[]{"-o", remoteConfig.getName()});
                    args.add(source);
                    args.add(workspace.getAbsolutePath());
                    return GitAPI.this.launchCommandIn(args, null);
                }
            });
        }
        catch (Exception e) {
            throw new GitException("Could not clone " + source, e);
        }
    }

    @Override
    public void clean() throws GitException {
        this.launchCommand("clean", "-fdx");
    }

    @Override
    public ObjectId revParse(String revName) throws GitException {
        String result = this.launchCommand("rev-parse", revName);
        return ObjectId.fromString((String)this.firstLine(result).trim());
    }

    @Override
    public String describe(String commitIsh) throws GitException {
        String result = this.launchCommand("describe", "--tags", commitIsh);
        return this.firstLine(result).trim();
    }

    @Override
    public void prune(RemoteConfig repository) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"remote", "prune", repository.getName()});
        this.launchCommand(args);
    }

    private String firstLine(String result) {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(result));
        try {
            line = reader.readLine();
            if (line == null) {
                return null;
            }
            if (reader.readLine() != null) {
                throw new GitException("Result has multiple lines");
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing result", e);
        }
        return line;
    }

    @Override
    public void changelog(String revFrom, String revTo, OutputStream outputStream) throws GitException {
        this.whatchanged(revFrom, revTo, outputStream, "--no-abbrev", "-M", "--pretty=raw");
    }

    private void whatchanged(String revFrom, String revTo, OutputStream outputStream, String ... extraargs) throws GitException {
        String revSpec = revFrom + ".." + revTo;
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "whatchanged"});
        args.add(extraargs);
        args.add(revSpec);
        try {
            if (this.launcher.launch().cmds(args).envs((Map)this.environment).stdout(outputStream).pwd(this.workspace).join() != 0) {
                throw new GitException("Error launching git whatchanged");
            }
        }
        catch (Exception e) {
            throw new GitException("Error performing git whatchanged", e);
        }
    }

    @Override
    public List<String> showRevision(Revision r) throws GitException {
        String revName = r.getSha1String();
        String result = "";
        if (revName != null) {
            result = this.launchCommand("show", "--no-abbrev", "--format=raw", "-M", "--raw", revName);
        }
        ArrayList<String> revShow = new ArrayList<String>();
        if (result != null) {
            revShow = new ArrayList<String>(Arrays.asList(result.split("\\n")));
        }
        return revShow;
    }

    @Override
    public void merge(String revSpec) throws GitException {
        try {
            this.launchCommand("merge", revSpec);
        }
        catch (GitException e) {
            throw new GitException("Could not merge " + revSpec, e);
        }
    }

    @Override
    public void submoduleInit() throws GitException {
        this.launchCommand("submodule", "init");
    }

    @Override
    public void submoduleSync() throws GitException {
        this.launchCommand("submodule", "sync");
    }

    @Override
    public void submoduleUpdate(boolean recursive) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"submodule", "update"});
        if (recursive) {
            args.add(new String[]{"--init", "--recursive"});
        }
        this.launchCommand(args);
    }

    @Override
    public void submoduleClean(boolean recursive) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"submodule", "foreach"});
        if (recursive) {
            args.add("--recursive");
        }
        args.add("git clean -fdx");
        this.launchCommand(args);
    }

    @Override
    public String getSubmoduleUrl(String name) throws GitException {
        String result = this.launchCommand("config", "--get", "submodule." + name + ".url");
        return this.firstLine(result).trim();
    }

    @Override
    public void setSubmoduleUrl(String name, String url) throws GitException {
        this.launchCommand("config", "submodule." + name + ".url", url);
    }

    @Override
    public String getRemoteUrl(String name) throws GitException {
        String result = this.launchCommand("config", "--get", "remote." + name + ".url");
        return this.firstLine(result).trim();
    }

    @Override
    public void setRemoteUrl(String name, String url) throws GitException {
        this.launchCommand("config", "remote." + name + ".url", url);
    }

    @Override
    public String getRemoteUrl(String name, String GIT_DIR) throws GitException {
        String result = this.launchCommand("--git-dir=" + GIT_DIR, "config", "--get", "remote." + name + ".url");
        return this.firstLine(result).trim();
    }

    @Override
    public void setRemoteUrl(String name, String url, String GIT_DIR) throws GitException {
        this.launchCommand("--git-dir=" + GIT_DIR, "config", "remote." + name + ".url", url);
    }

    @Override
    public String getDefaultRemote(String _default_) throws GitException {
        BufferedReader rdr = new BufferedReader(new StringReader(this.launchCommand("remote")));
        ArrayList<String> remotes = new ArrayList<String>();
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                remotes.add(line);
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing remotes", e);
        }
        if (remotes.contains(_default_)) {
            return _default_;
        }
        if (remotes.size() >= 1) {
            return (String)remotes.get(0);
        }
        throw new GitException("No remotes found!");
    }

    public String getDefaultRemote() throws GitException {
        return this.getDefaultRemote("origin");
    }

    @Override
    public boolean isBareRepository() throws GitException {
        return this.isBareRepository("");
    }

    @Override
    public boolean isBareRepository(String GIT_DIR) throws GitException {
        String ret = null;
        if ("".equals(GIT_DIR)) {
            ret = this.launchCommand("rev-parse", "--is-bare-repository");
        } else {
            String gitDir = "--git-dir=" + GIT_DIR;
            ret = this.launchCommand(gitDir, "rev-parse", "--is-bare-repository");
        }
        return !"false".equals(this.firstLine(ret).trim());
    }

    private String pathJoin(String a, String b) {
        return new File(a, b).toString();
    }

    @Override
    public void fixSubmoduleUrls(String remote, TaskListener listener) throws GitException {
        URI origin;
        boolean is_bare = true;
        try {
            String url = this.getRemoteUrl(remote);
            String gitEnd = this.pathJoin("", ".git");
            if (url.endsWith(gitEnd)) {
                url = url.substring(0, url.length() - gitEnd.length());
                is_bare = false;
            }
            origin = new URI(url);
        }
        catch (URISyntaxException e) {
            return;
        }
        catch (Exception e) {
            throw new GitException("Could determine remote.origin.url", e);
        }
        if (origin.getScheme() == null || "file".equalsIgnoreCase(origin.getScheme()) && (origin.getHost() == null || "".equals(origin.getHost()))) {
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(origin.getPath());
            paths.add(this.pathJoin(origin.getPath(), ".git"));
            for (String path : paths) {
                try {
                    is_bare = this.isBareRepository(path);
                    break;
                }
                catch (GitException e) {
                    LOGGER.log(Level.FINEST, "Exception occurred while detecting repository type by path: " + path);
                }
            }
        }
        if (!is_bare) {
            try {
                List<IndexEntry> submodules = this.getSubmodules("HEAD");
                for (IndexEntry submodule : submodules) {
                    String sUrl = this.pathJoin(origin.getPath(), submodule.getFile());
                    this.setSubmoduleUrl(submodule.getFile(), sUrl);
                    String subGitDir = this.pathJoin(submodule.getFile(), ".git");
                    if (!this.hasGitRepo(subGitDir) || "".equals(this.getRemoteUrl("origin", subGitDir))) continue;
                    this.setRemoteUrl("origin", sUrl, subGitDir);
                }
            }
            catch (GitException e) {
                LOGGER.log(Level.FINEST, "Exception occurred while working with git repo.");
            }
        } else {
            LOGGER.log(Level.FINER, "The origin is non-bare.");
        }
    }

    @Override
    public void setupSubmoduleUrls(Revision rev, TaskListener listener) throws GitException {
        String remote;
        Iterator<Branch> bi = rev.getBranches().iterator();
        if (bi.hasNext()) {
            String b = bi.next().getName();
            if (b != null) {
                int slash = b.indexOf(47);
                if (slash == -1) {
                    throw new GitException("no remote from branch name (" + b + ")");
                }
                remote = this.getDefaultRemote(b.substring(0, slash));
            } else {
                remote = this.getDefaultRemote();
            }
        } else {
            remote = this.getDefaultRemote();
        }
        this.setupSubmoduleUrls(remote, listener);
    }

    @Override
    public void setupSubmoduleUrls(String remote, TaskListener listener) throws GitException {
        this.submoduleInit();
        this.submoduleSync();
        this.fixSubmoduleUrls(remote, listener);
    }

    @Override
    public void tag(String tagName, String comment) throws GitException {
        tagName = tagName.replace(' ', '_');
        try {
            this.launchCommand("tag", "-a", "-f", "-m", comment, tagName);
        }
        catch (GitException e) {
            throw new GitException("Could not apply tag " + tagName, e);
        }
    }

    public String launchCommand(ArgumentListBuilder args) throws GitException {
        return this.launchCommandIn(args, this.workspace);
    }

    public String launchCommand(String ... args) throws GitException {
        return this.launchCommand(new ArgumentListBuilder(args));
    }

    private String launchCommandIn(ArgumentListBuilder args, FilePath workDir) throws GitException {
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        try {
            args.prepend(new String[]{this.getGitExe()});
            int status = this.launcher.launch().cmds(args.toCommandArray()).envs((Map)this.environment).stdout((OutputStream)fos).pwd(workDir).join();
            String result = fos.toString();
            if (status != 0) {
                throw new GitException("Command \"" + StringUtils.join((Object[])args.toCommandArray(), (String)" ") + "\" returned status code " + status + ": " + result);
            }
            return result;
        }
        catch (Exception e) {
            throw new GitException("Error performing command: " + StringUtils.join((Object[])args.toCommandArray(), (String)" ") + "\n" + e.getMessage(), e);
        }
    }

    @Override
    public void push(RemoteConfig repository, String refspec) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"push", ((URIish)repository.getURIs().get(0)).toPrivateString()});
        if (refspec != null) {
            args.add(refspec);
        }
        this.launchCommand(args);
    }

    private List<Branch> parseBranches(String fos) throws GitException {
        ArrayList<Branch> tags = new ArrayList<Branch>();
        BufferedReader rdr = new BufferedReader(new StringReader(fos));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                if ((line = line.substring(2)).startsWith("(") || line.indexOf(" -> ") != -1) continue;
                tags.add(new Branch(line, this.revParse(line)));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing branches", e);
        }
        return tags;
    }

    @Override
    public List<Branch> getBranches() throws GitException {
        return this.parseBranches(this.launchCommand("branch", "-a"));
    }

    @Override
    public List<Branch> getRemoteBranches() throws GitException, IOException {
        Repository db = this.getRepository();
        Map refs = db.getAllRefs();
        ArrayList<Branch> branches = new ArrayList<Branch>();
        for (Ref candidate : refs.values()) {
            if (!candidate.getName().startsWith("refs/remotes/")) continue;
            Branch buildBranch = new Branch(candidate);
            this.listener.getLogger().println("Seen branch in repository " + buildBranch.getName());
            branches.add(buildBranch);
        }
        return branches;
    }

    @Override
    public List<Branch> getBranchesContaining(String revspec) throws GitException {
        return this.parseBranches(this.launchCommand("branch", "-a", "--contains", revspec));
    }

    @Override
    public void checkout(String commitish) throws GitException {
        this.checkoutBranch(null, commitish);
    }

    @Override
    public void checkoutBranch(String branch, String commitish) throws GitException {
        try {
            this.launchCommand("checkout", "-f", commitish);
            if (branch != null) {
                for (Branch b : this.getBranches()) {
                    if (!b.name.equals(branch)) continue;
                    this.deleteBranch(branch);
                }
                this.launchCommand("checkout", "-b", branch, commitish);
            }
        }
        catch (GitException e) {
            throw new GitException("Could not checkout " + branch + " with start point " + commitish, e);
        }
    }

    @Override
    public boolean tagExists(String tagName) throws GitException {
        tagName = tagName.replace(' ', '_');
        return this.launchCommand("tag", "-l", tagName).trim().equals(tagName);
    }

    @Override
    public void deleteBranch(String name) throws GitException {
        try {
            this.launchCommand("branch", "-D", name);
        }
        catch (GitException e) {
            throw new GitException("Could not delete branch " + name, e);
        }
    }

    @Override
    public void deleteTag(String tagName) throws GitException {
        tagName = tagName.replace(' ', '_');
        try {
            this.launchCommand("tag", "-d", tagName);
        }
        catch (GitException e) {
            throw new GitException("Could not delete tag " + tagName, e);
        }
    }

    @Override
    public List<IndexEntry> lsTree(String treeIsh) throws GitException {
        ArrayList<IndexEntry> entries = new ArrayList<IndexEntry>();
        String result = this.launchCommand("ls-tree", treeIsh);
        BufferedReader rdr = new BufferedReader(new StringReader(result));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                String[] entry = line.split("\\s+");
                entries.add(new IndexEntry(entry[0], entry[1], entry[2], entry[3]));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing ls tree", e);
        }
        return entries;
    }

    @Override
    public List<ObjectId> revListAll() throws GitException {
        return this.revList("--all");
    }

    @Override
    public List<ObjectId> revListBranch(String branchId) throws GitException {
        return this.revList(branchId);
    }

    public List<ObjectId> revList(String ... extraArgs) throws GitException {
        ArrayList<ObjectId> entries = new ArrayList<ObjectId>();
        ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"rev-list"});
        args.add(extraArgs);
        String result = this.launchCommand(args);
        BufferedReader rdr = new BufferedReader(new StringReader(result));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                entries.add(ObjectId.fromString((String)line));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing rev list", e);
        }
        return entries;
    }

    @Override
    public boolean isCommitInRepo(String sha1) {
        try {
            List<ObjectId> revs = this.revList(sha1);
            return revs.size() != 0;
        }
        catch (GitException e) {
            return false;
        }
    }

    @Override
    public void add(String filePattern) throws GitException {
        try {
            this.launchCommand("add", filePattern);
        }
        catch (GitException e) {
            throw new GitException("Cannot add " + filePattern, e);
        }
    }

    @Override
    public void branch(String name) throws GitException {
        try {
            this.launchCommand("branch", name);
        }
        catch (GitException e) {
            throw new GitException("Cannot create branch " + name, e);
        }
    }

    @Override
    public void commit(File f) throws GitException {
        try {
            this.launchCommand("commit", "-F", f.getAbsolutePath());
        }
        catch (GitException e) {
            throw new GitException("Cannot commit " + f, e);
        }
    }

    @Override
    public void fetch(RemoteConfig remoteRepository) throws GitException {
        this.fetch(((URIish)remoteRepository.getURIs().get(0)).toPrivateString(), ((RefSpec)remoteRepository.getFetchRefSpecs().get(0)).toString());
    }

    @Override
    public ObjectId mergeBase(ObjectId id1, ObjectId id2) {
        try {
            String result;
            try {
                result = this.launchCommand("merge-base", id1.name(), id2.name());
            }
            catch (GitException ge) {
                return null;
            }
            BufferedReader rdr = new BufferedReader(new StringReader(result));
            String line = rdr.readLine();
            if (line != null) {
                return ObjectId.fromString((String)line);
            }
        }
        catch (Exception e) {
            throw new GitException("Error parsing merge base", e);
        }
        return null;
    }

    @Override
    public String getAllLogEntries(String branch) {
        return this.launchCommand("log", "--all", "--pretty=format:'%H#%ct'", branch);
    }

    private Repository getRepository() throws IOException {
        return new Repository(new File(this.workspace.getRemote(), ".git"));
    }

    @Override
    public List<Tag> getTagsOnCommit(String revName) throws GitException, IOException {
        Repository db = this.getRepository();
        ObjectId commit = db.resolve(revName);
        ArrayList<Tag> ret = new ArrayList<Tag>();
        for (Map.Entry tag : db.getTags().entrySet()) {
            Tag ttag = db.mapTag((String)tag.getKey());
            if (!ttag.getObjId().equals(commit)) continue;
            ret.add(ttag);
        }
        return ret;
    }

    @Override
    public Set<String> getTagNames(String tagPattern) throws GitException {
        try {
            String tag;
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add(new String[]{"tag", "-l", tagPattern});
            String result = this.launchCommandIn(args, this.workspace);
            HashSet<String> tags = new HashSet<String>();
            BufferedReader rdr = new BufferedReader(new StringReader(result));
            while ((tag = rdr.readLine()) != null) {
                tags.add(tag);
            }
            return tags;
        }
        catch (Exception e) {
            throw new GitException("Error retrieving tag names", e);
        }
    }
}

