/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitAPI;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitRepositoryBrowser;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Revision;
import hudson.plugins.git.SubmoduleConfig;
import hudson.plugins.git.opt.PreBuildMergeOptions;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.BuildChooserDescriptor;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.DefaultBuildChooser;
import hudson.plugins.git.util.GitUtils;
import hudson.scm.ChangeLogParser;
import hudson.scm.RepositoryBrowser;
import hudson.scm.RepositoryBrowsers;
import hudson.scm.SCM;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;
import org.spearce.jgit.lib.RepositoryConfig;
import org.spearce.jgit.transport.RefSpec;
import org.spearce.jgit.transport.RemoteConfig;
import org.spearce.jgit.transport.URIish;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitSCM
extends SCM
implements Serializable {
    @Deprecated
    transient String source;
    @Deprecated
    transient String branch;
    private Long configVersion;
    private List<RemoteConfig> remoteRepositories;
    private List<BranchSpec> branches;
    private String localBranch;
    private PreBuildMergeOptions mergeOptions;
    private boolean recursiveSubmodules;
    private boolean doGenerateSubmoduleConfigurations;
    private boolean authorOrCommitter;
    private boolean clean;
    private boolean wipeOutWorkspace;
    private transient String choosingStrategy;
    private BuildChooser buildChooser;
    public String gitTool = null;
    private GitRepositoryBrowser browser;
    private Collection<SubmoduleConfig> submoduleCfg;
    public static final String GIT_BRANCH = "GIT_BRANCH";
    public static final String GIT_COMMIT = "GIT_COMMIT";
    private String relativeTargetDir;
    private String excludedRegions;
    private String excludedUsers;
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(GitSCM.class.getName());

    public Collection<SubmoduleConfig> getSubmoduleCfg() {
        return this.submoduleCfg;
    }

    public void setSubmoduleCfg(Collection<SubmoduleConfig> submoduleCfg) {
        this.submoduleCfg = submoduleCfg;
    }

    @DataBoundConstructor
    public GitSCM(List<RemoteConfig> repositories, List<BranchSpec> branches, PreBuildMergeOptions mergeOptions, boolean doGenerateSubmoduleConfigurations, Collection<SubmoduleConfig> submoduleCfg, boolean clean, boolean wipeOutWorkspace, BuildChooser buildChooser, GitRepositoryBrowser browser, String gitTool, boolean authorOrCommitter, String relativeTargetDir, String excludedRegions, String excludedUsers, String localBranch, boolean recursiveSubmodules) {
        this.branches = branches;
        this.localBranch = localBranch;
        this.remoteRepositories = repositories;
        this.browser = browser;
        this.mergeOptions = mergeOptions;
        this.doGenerateSubmoduleConfigurations = doGenerateSubmoduleConfigurations;
        this.submoduleCfg = submoduleCfg;
        this.clean = clean;
        this.wipeOutWorkspace = wipeOutWorkspace;
        this.configVersion = 1L;
        this.gitTool = gitTool;
        this.authorOrCommitter = authorOrCommitter;
        this.buildChooser = buildChooser;
        this.relativeTargetDir = relativeTargetDir;
        this.excludedRegions = excludedRegions;
        this.excludedUsers = excludedUsers;
        this.recursiveSubmodules = recursiveSubmodules;
        buildChooser.gitSCM = this;
    }

    public Object readResolve() {
        if (this.configVersion == null) {
            this.configVersion = 0L;
        }
        if (this.source != null) {
            this.remoteRepositories = new ArrayList();
            this.branches = new ArrayList();
            this.doGenerateSubmoduleConfigurations = false;
            this.mergeOptions = new PreBuildMergeOptions();
            this.recursiveSubmodules = false;
            this.remoteRepositories.add(this.newRemoteConfig("origin", this.source, new RefSpec("+refs/heads/*:refs/remotes/origin/*")));
            if (this.branch != null) {
                this.branches.add(new BranchSpec(this.branch));
            } else {
                this.branches.add(new BranchSpec("*/master"));
            }
        }
        if (this.configVersion < 1L && this.branches != null) {
            for (BranchSpec branchSpec : this.branches) {
                String name = branchSpec.getName();
                name = name.replace("*", "**");
                branchSpec.setName(name);
            }
        }
        if (this.mergeOptions.doMerge() && this.mergeOptions.getMergeRemote() == null) {
            this.mergeOptions.setMergeRemote((RemoteConfig)this.remoteRepositories.get(0));
        }
        if (this.choosingStrategy != null && this.buildChooser == null) {
            for (BuildChooserDescriptor d : BuildChooser.all()) {
                if (!this.choosingStrategy.equals(d.getLegacyId())) continue;
                try {
                    this.buildChooser = (BuildChooser)d.clazz.newInstance();
                }
                catch (InstantiationException e) {
                    LOGGER.log(Level.WARNING, "Failed to instantiate the build chooser", e);
                }
                catch (IllegalAccessException e) {
                    LOGGER.log(Level.WARNING, "Failed to instantiate the build chooser", e);
                }
            }
        }
        if (this.buildChooser == null) {
            this.buildChooser = new DefaultBuildChooser();
        }
        this.buildChooser.gitSCM = this;
        return this;
    }

    public String getExcludedRegions() {
        return this.excludedRegions;
    }

    public String[] getExcludedRegionsNormalized() {
        return this.excludedRegions == null || this.excludedRegions.trim().equals("") ? null : this.excludedRegions.split("[\\r\\n]+");
    }

    private Pattern[] getExcludedRegionsPatterns() {
        String[] excluded = this.getExcludedRegionsNormalized();
        if (excluded != null) {
            Pattern[] patterns = new Pattern[excluded.length];
            int i = 0;
            for (String excludedRegion : excluded) {
                patterns[i++] = Pattern.compile(excludedRegion);
            }
            return patterns;
        }
        return new Pattern[0];
    }

    public String getExcludedUsers() {
        return this.excludedUsers;
    }

    public Set<String> getExcludedUsersNormalized() {
        String s = Util.fixEmptyAndTrim((String)this.excludedUsers);
        if (s == null) {
            return Collections.emptySet();
        }
        HashSet<String> users = new HashSet<String>();
        for (String user : s.split("[\\r\\n]+")) {
            users.add(user.trim());
        }
        return users;
    }

    public GitRepositoryBrowser getBrowser() {
        return this.browser;
    }

    public boolean getWipeOutWorkspace() {
        return this.wipeOutWorkspace;
    }

    public boolean getClean() {
        return this.clean;
    }

    public BuildChooser getBuildChooser() {
        return this.buildChooser;
    }

    public List<RemoteConfig> getParamExpandedRepos(AbstractBuild<?, ?> build) {
        if (this.remoteRepositories == null) {
            return new ArrayList<RemoteConfig>();
        }
        ArrayList<RemoteConfig> expandedRepos = new ArrayList<RemoteConfig>();
        for (RemoteConfig oldRepo : this.remoteRepositories) {
            expandedRepos.add(this.newRemoteConfig(oldRepo.getName(), ((URIish)oldRepo.getURIs().get(0)).toString(), new RefSpec(this.getRefSpec(oldRepo, build))));
        }
        return expandedRepos;
    }

    public RemoteConfig getRepositoryByName(String repoName) {
        for (RemoteConfig r : this.getRepositories()) {
            if (!r.getName().equals(repoName)) continue;
            return r;
        }
        return null;
    }

    public List<RemoteConfig> getRepositories() {
        if (this.remoteRepositories == null) {
            return new ArrayList<RemoteConfig>();
        }
        return this.remoteRepositories;
    }

    public String getGitTool() {
        return this.gitTool;
    }

    private String getRefSpec(RemoteConfig repo, AbstractBuild<?, ?> build) {
        String refSpec = ((RefSpec)repo.getFetchRefSpecs().get(0)).toString();
        ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
        if (parameters != null) {
            refSpec = parameters.substitute(build, refSpec);
        }
        return refSpec;
    }

    private String getSingleBranch(AbstractBuild<?, ?> build) {
        if (this.getBranches().size() != 1 || this.getRepositories().size() != 1) {
            return null;
        }
        String branch = ((BranchSpec)this.getBranches().get(0)).getName();
        String repository = ((RemoteConfig)this.getRepositories().get(0)).getName();
        if (branch.startsWith("*/")) {
            branch = repository + branch.substring(1);
        }
        if (branch.contains("*")) {
            return null;
        }
        ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
        if (parameters != null) {
            branch = parameters.substitute(build, branch);
        }
        return branch;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        String gitExe;
        listener.getLogger().println("Using strategy: " + this.buildChooser.getDisplayName());
        AbstractBuild lastBuild = (AbstractBuild)project.getLastBuild();
        if (lastBuild == null) {
            listener.getLogger().println("[poll] No previous build, so forcing an initial build.");
            return true;
        }
        listener.getLogger().println("[poll] Last Build : #" + lastBuild.getNumber());
        BuildData buildData = this.fixNull(this.getBuildData((Run)lastBuild, false));
        if (buildData != null && buildData.lastBuild != null) {
            listener.getLogger().println("[poll] Last Built Revision: " + buildData.lastBuild.revision);
        }
        String singleBranch = this.getSingleBranch(lastBuild);
        Label label = project.getAssignedLabel();
        List paramRepos = this.getParamExpandedRepos(lastBuild);
        if (label != null && label.isSelfLabel()) {
            if (label.getNodes().iterator().next() != project.getLastBuiltOn()) {
                listener.getLogger().println("Last build was not on tied node, forcing rebuild.");
                return true;
            }
            gitExe = this.getGitExe((Node)label.getNodes().iterator().next(), listener);
        } else {
            gitExe = this.getGitExe(project.getLastBuiltOn(), listener);
        }
        FilePath workingDirectory = this.workingDirectory(workspace);
        if (!workingDirectory.exists()) {
            return true;
        }
        EnvVars environment = lastBuild.getEnvironment(listener);
        boolean pollChangesResult = (Boolean)workingDirectory.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        return pollChangesResult;
    }

    private BuildData fixNull(BuildData bd) {
        return bd != null ? bd : new BuildData();
    }

    private void cleanSubmodules(IGitAPI parentGit, File workspace, TaskListener listener, RemoteConfig remoteRepository) {
        List submodules = new GitUtils(listener, parentGit).getSubmodules("HEAD");
        for (IndexEntry submodule : submodules) {
            try {
                RemoteConfig submoduleRemoteRepository = this.getSubmoduleRepository(workspace, remoteRepository, submodule.getFile());
                File subdir = new File(workspace, submodule.getFile());
                listener.getLogger().println("Trying to clean submodule in " + subdir);
                GitAPI subGit = new GitAPI(parentGit.getGitExe(), new FilePath(subdir), listener, parentGit.getEnvironment());
                subGit.clean();
            }
            catch (Exception ex) {
                listener.getLogger().println("Problem cleaning submodule in " + submodule.getFile() + " - could be unavailable. Continuing anyway");
            }
        }
    }

    private boolean fetchFrom(IGitAPI git, File workspace, TaskListener listener, RemoteConfig remoteRepository) {
        boolean fetched = true;
        try {
            git.fetch(remoteRepository);
            List submodules = new GitUtils(listener, git).getSubmodules("HEAD");
            for (IndexEntry submodule : submodules) {
                try {
                    RemoteConfig submoduleRemoteRepository = this.getSubmoduleRepository(workspace, remoteRepository, submodule.getFile());
                    File subdir = new File(workspace, submodule.getFile());
                    listener.getLogger().println("Trying to fetch " + submodule.getFile() + " into " + subdir);
                    GitAPI subGit = new GitAPI(git.getGitExe(), new FilePath(subdir), listener, git.getEnvironment());
                    subGit.fetch(submoduleRemoteRepository);
                }
                catch (Exception ex) {
                    listener.getLogger().println("Problem fetching from submodule " + submodule.getFile() + " - could be unavailable. Continuing anyway");
                }
            }
        }
        catch (GitException ex) {
            listener.error("Problem fetching from " + remoteRepository.getName() + " / " + remoteRepository.getName() + " - could be unavailable. Continuing anyway");
            fetched = false;
        }
        return fetched;
    }

    public RemoteConfig getSubmoduleRepository(File aWorkspace, RemoteConfig orig, String name) throws IOException {
        BufferedReader bfr = new BufferedReader(new FileReader(aWorkspace + File.separator + ".gitmodules"));
        String line = "";
        boolean isSubmodule = false;
        while ((line = bfr.readLine()) != null) {
            if ((line = line.trim()).startsWith("[submodule \"" + name)) {
                isSubmodule = true;
                continue;
            }
            if (!isSubmodule || !line.startsWith("url")) continue;
            int index = line.indexOf("=");
            String refUrl = line.substring(index + 1).trim();
            return this.newRemoteConfig(name, refUrl, (RefSpec)orig.getFetchRefSpecs().get(0));
        }
        String refUrl = ((URIish)orig.getURIs().get(0)).toString();
        if (refUrl.endsWith("/.git")) {
            refUrl = refUrl.substring(0, refUrl.length() - 4);
        }
        if (!refUrl.endsWith("/")) {
            refUrl = refUrl + "/";
        }
        if (!(refUrl = refUrl + name).endsWith("/")) {
            refUrl = refUrl + "/";
        }
        refUrl = refUrl + ".git";
        return this.newRemoteConfig(name, refUrl, (RefSpec)orig.getFetchRefSpecs().get(0));
    }

    private RemoteConfig newRemoteConfig(String name, String refUrl, RefSpec refSpec) {
        File temp = null;
        try {
            temp = File.createTempFile("tmp", "config");
            RepositoryConfig repoConfig = new RepositoryConfig(null, temp);
            repoConfig.setString("remote", name, "url", refUrl);
            repoConfig.setString("remote", name, "fetch", refSpec.toString());
            repoConfig.save();
            RemoteConfig remoteConfig = (RemoteConfig)RemoteConfig.getAllRemoteConfigs((RepositoryConfig)repoConfig).get(0);
            return remoteConfig;
        }
        catch (Exception ex) {
            throw new GitException("Error creating temp file");
        }
        finally {
            if (temp != null) {
                temp.delete();
            }
        }
    }

    private boolean changeLogResult(String changeLog, File changelogFile) throws IOException {
        if (changeLog == null) {
            return false;
        }
        changelogFile.delete();
        FileOutputStream fos = new FileOutputStream(changelogFile);
        fos.write(changeLog.getBytes());
        fos.close();
        return true;
    }

    public String getGitExe(Node builtOn, TaskListener listener) {
        GitTool[] gitToolInstallations;
        for (GitTool t : gitToolInstallations = (GitTool[])((GitTool.DescriptorImpl)Hudson.getInstance().getDescriptorByType(GitTool.DescriptorImpl.class)).getInstallations()) {
            if (this.gitTool == null) {
                this.gitTool = t.getName();
            }
            if (!t.getName().equals(this.gitTool) || builtOn == null) continue;
            try {
                String s = t.forNode(builtOn, listener).getGitExe();
                return s;
            }
            catch (IOException e) {
                listener.getLogger().println("Failed to get git executable");
            }
            catch (InterruptedException e) {
                listener.getLogger().println("Failed to get git executable");
            }
        }
        return null;
    }

    public boolean getAuthorOrCommitter() {
        return this.authorOrCommitter;
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        Revision parentLastBuiltRev;
        List paramRepos;
        Revision revToBuild;
        BuildData parentBuildData;
        MatrixBuild parentBuild;
        listener.getLogger().println("Checkout:" + workspace.getName() + " / " + workspace.getRemote() + " - " + workspace.getChannel());
        listener.getLogger().println("Using strategy: " + this.buildChooser.getDisplayName());
        FilePath workingDirectory = this.workingDirectory(workspace);
        if (!workingDirectory.exists()) {
            workingDirectory.mkdirs();
        }
        String projectName = build.getProject().getName();
        int buildNumber = build.getNumber();
        String gitExe = this.getGitExe(build.getBuiltOn(), (TaskListener)listener);
        String buildnumber = "hudson-" + projectName + "-" + buildNumber;
        BuildData buildData = this.getBuildData(build.getPreviousBuild(), true);
        if (buildData != null && buildData.lastBuild != null) {
            listener.getLogger().println("Last Built Revision: " + buildData.lastBuild.revision);
        }
        EnvVars environment = build.getEnvironment((TaskListener)listener);
        String singleBranch = this.getSingleBranch(build);
        Revision tempParentLastBuiltRev = null;
        if (build instanceof MatrixRun && (parentBuild = ((MatrixRun)build).getParentBuild()) != null && (parentBuildData = (BuildData)parentBuild.getAction(BuildData.class)) != null) {
            tempParentLastBuiltRev = parentBuildData.getLastBuiltRevision();
        }
        if ((revToBuild = (Revision)workingDirectory.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */)) == null) {
            listener.error("Nothing to do");
            return false;
        }
        listener.getLogger().println("Commencing build of " + revToBuild);
        environment.put((Object)GIT_COMMIT, (Object)revToBuild.getSha1String());
        if (this.mergeOptions.doMerge() && !revToBuild.containsBranchName(this.mergeOptions.getRemoteBranchName())) {
            Object[] returnData = (Object[])workingDirectory.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
            BuildData returningBuildData = (BuildData)returnData[1];
            build.addAction((Action)returningBuildData);
            return this.changeLogResult((String)returnData[0], changelogFile);
        }
        Object[] returnData = (Object[])workingDirectory.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        build.addAction((Action)returnData[1]);
        return this.changeLogResult((String)returnData[0], changelogFile);
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        String branch = this.getSingleBranch(build);
        if (branch != null) {
            env.put(GIT_BRANCH, branch);
        }
    }

    private String putChangelogDiffsIntoFile(IGitAPI git, String branchName, String revFrom, String revTo) throws IOException {
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        String changeset = "Changes in branch " + branchName + ", between " + revFrom + " and " + revTo + "\n";
        fos.write(changeset.getBytes());
        git.changelog(revFrom, revTo, (OutputStream)fos);
        fos.close();
        return fos.toString();
    }

    public ChangeLogParser createChangeLogParser() {
        return new GitChangeLogParser(this.getAuthorOrCommitter());
    }

    public boolean getRecursiveSubmodules() {
        return this.recursiveSubmodules;
    }

    public boolean getDoGenerate() {
        return this.doGenerateSubmoduleConfigurations;
    }

    public List<BranchSpec> getBranches() {
        return this.branches;
    }

    public PreBuildMergeOptions getMergeOptions() {
        return this.mergeOptions;
    }

    public BuildData getBuildData(Run build, boolean clone) {
        BuildData buildData = null;
        while (build != null && (buildData = (BuildData)build.getAction(BuildData.class)) == null) {
            build = build.getPreviousBuild();
        }
        if (buildData == null) {
            return clone ? new BuildData() : null;
        }
        if (clone) {
            return buildData.clone();
        }
        return buildData;
    }

    protected FilePath workingDirectory(FilePath workspace) {
        if (this.relativeTargetDir == null || this.relativeTargetDir.length() == 0 || this.relativeTargetDir.equals(".")) {
            return workspace;
        }
        return workspace.child(this.relativeTargetDir);
    }

    public String getLocalBranch() {
        return this.localBranch;
    }

    public String getRelativeTargetDir() {
        return this.relativeTargetDir;
    }

    private boolean isRevExcluded(IGitAPI git, Revision r, TaskListener listener) {
        try {
            String author;
            List revShow = git.showRevision(r);
            if (revShow.size() == 0) {
                return false;
            }
            GitChangeSet change = new GitChangeSet(revShow, this.authorOrCommitter);
            Pattern[] excludedPatterns = this.getExcludedRegionsPatterns();
            Set excludedUsers = this.getExcludedUsersNormalized();
            if (excludedUsers.contains(author = change.getAuthorName())) {
                listener.getLogger().println("Ignored commit " + r.getSha1String() + ": Found excluded author: " + author);
                return true;
            }
            ArrayList paths = new ArrayList(change.getAffectedPaths());
            if (paths.isEmpty()) {
                return false;
            }
            ArrayList<String> excludedPaths = new ArrayList<String>();
            if (excludedPatterns.length > 0) {
                block2: for (String path : paths) {
                    for (Pattern pattern : excludedPatterns) {
                        if (!pattern.matcher(path).matches()) continue;
                        excludedPaths.add(path);
                        continue block2;
                    }
                }
            }
            if (paths.size() == excludedPaths.size()) {
                listener.getLogger().println("Ignored commit " + r.getSha1String() + ": Found only excluded paths: " + Util.join(excludedPaths, (String)", "));
                return true;
            }
        }
        catch (GitException e) {
            return false;
        }
        return false;
    }

    public List<Descriptor<RepositoryBrowser<?>>> getBrowserDescriptors() {
        return RepositoryBrowsers.filter(GitRepositoryBrowser.class);
    }

    static /* synthetic */ boolean access$000(GitSCM x0, IGitAPI x1, File x2, TaskListener x3, RemoteConfig x4) {
        return x0.fetchFrom(x1, x2, x3, x4);
    }

    static /* synthetic */ BuildChooser access$100(GitSCM x0) {
        return x0.buildChooser;
    }

    static /* synthetic */ boolean access$200(GitSCM x0, IGitAPI x1, Revision x2, TaskListener x3) {
        return x0.isRevExcluded(x1, x2, x3);
    }

    static /* synthetic */ boolean access$300(GitSCM x0) {
        return x0.wipeOutWorkspace;
    }

    static /* synthetic */ boolean access$400(GitSCM x0) {
        return x0.recursiveSubmodules;
    }

    static /* synthetic */ PreBuildMergeOptions access$500(GitSCM x0) {
        return x0.mergeOptions;
    }

    static /* synthetic */ String access$600(GitSCM x0) {
        return x0.localBranch;
    }

    static /* synthetic */ String access$700(GitSCM x0, IGitAPI x1, String x2, String x3, String x4) throws IOException {
        return x0.putChangelogDiffsIntoFile(x1, x2, x3, x4);
    }

    static /* synthetic */ boolean access$800(GitSCM x0) {
        return x0.doGenerateSubmoduleConfigurations;
    }

    static /* synthetic */ Collection access$900(GitSCM x0) {
        return x0.submoduleCfg;
    }
}

