/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.browsers.QueryBuilder;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.kohsuke.stapler.DataBoundConstructor;

public class GitWeb
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;
    private final URL url;

    @DataBoundConstructor
    public GitWeb(String url) throws MalformedURLException {
        this.url = new URL(url);
    }

    public URL getUrl() {
        return this.url;
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        return new URL(this.url, this.url.getPath() + this.param().add("a=commit").add("h=" + changeSet.getId()).toString());
    }

    private QueryBuilder param() {
        return new QueryBuilder(this.url.getQuery());
    }

    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT || path.getSrc() == null || path.getDst() == null || path.getChangeSet().getParentCommit() == null) {
            return null;
        }
        GitChangeSet changeSet = path.getChangeSet();
        String spec = this.param().add("a=blobdiff").add("f=" + path.getPath()).add("fp=" + path.getPath()).add("h=" + path.getSrc()).add("hp=" + path.getDst()).add("hb=" + changeSet.getId()).add("hpb=" + changeSet.getParentCommit()).toString();
        return new URL(this.url, this.url.getPath() + spec);
    }

    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        String h = path.getDst() != null ? path.getDst() : path.getSrc();
        String spec = this.param().add("a=blob").add("f=" + path.getPath()).add("h=" + h).add("hb=" + path.getChangeSet().getId()).toString();
        return new URL(this.url, this.url.getPath() + spec);
    }
}

