/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.MarkupText;
import hudson.Util;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitSCM;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import hudson.tasks.Mailer;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitChangeSet
extends ChangeLogSet.Entry {
    private static final Logger LOGGER = Logger.getLogger(GitSCM.class.getName());
    private static final Pattern FILE_LOG_ENTRY = Pattern.compile("^:[0-9]{6} [0-9]{6} ([0-9a-f]{40}) ([0-9a-f]{40}) ([ACDMRTUX])(?>[0-9]+)?\t(.*)$");
    private static final Pattern AUTHOR_ENTRY = Pattern.compile("^author (.*) <(.*)> (.*) (.*)$");
    private static final Pattern COMMITTER_ENTRY = Pattern.compile("^committer (.*) <(.*)> (.*) (.*)$");
    private static final Pattern RENAME_SPLIT = Pattern.compile("^(.*?)\t(.*)$");
    private static final String NULL_HASH = "0000000000000000000000000000000000000000";
    private String committer;
    private String committerEmail;
    private String committerTime;
    private String committerTz;
    private String author;
    private String authorEmail;
    private String authorTime;
    private String authorTz;
    private String comment;
    private String title;
    private String id;
    private String parentCommit;
    private Collection<Path> paths = new HashSet();
    private boolean authorOrCommitter;

    public GitChangeSet(List<String> lines, boolean authorOrCommitter) {
        this.authorOrCommitter = authorOrCommitter;
        if (lines.size() > 0) {
            this.parseCommit(lines);
        }
    }

    private void parseCommit(List<String> lines) {
        String message = "";
        for (String line : lines) {
            String mode;
            Matcher fileMatcher;
            if (line.length() <= 0) continue;
            if (line.startsWith("commit ")) {
                this.id = line.split(" ")[1];
                continue;
            }
            if (line.startsWith("parent ")) {
                this.parentCommit = line.split(" ")[1];
                continue;
            }
            if (line.startsWith("committer ")) {
                Matcher committerMatcher = COMMITTER_ENTRY.matcher(line);
                if (!committerMatcher.matches() || committerMatcher.groupCount() < 4) continue;
                this.committer = committerMatcher.group(1);
                this.committerEmail = committerMatcher.group(2);
                this.committerTime = committerMatcher.group(3);
                this.committerTz = committerMatcher.group(4);
                continue;
            }
            if (line.startsWith("author ")) {
                Matcher authorMatcher = AUTHOR_ENTRY.matcher(line);
                if (!authorMatcher.matches() || authorMatcher.groupCount() < 4) continue;
                this.author = authorMatcher.group(1);
                this.authorEmail = authorMatcher.group(2);
                this.authorTime = authorMatcher.group(3);
                this.authorTz = authorMatcher.group(4);
                continue;
            }
            if (line.startsWith("    ")) {
                message = message + line.substring(4) + "\n";
                continue;
            }
            if (':' != line.charAt(0) || !(fileMatcher = FILE_LOG_ENTRY.matcher(line)).matches() || fileMatcher.groupCount() < 4 || (mode = fileMatcher.group(3)).length() != 1) continue;
            String src = null;
            String dst = null;
            String path = fileMatcher.group(4);
            char editMode = mode.charAt(0);
            if (editMode == 'M' || editMode == 'A' || editMode == 'D' || editMode == 'R' || editMode == 'C') {
                src = this.parseHash(fileMatcher.group(1));
                dst = this.parseHash(fileMatcher.group(2));
            }
            if (editMode == 'R') {
                Matcher renameSplitMatcher = RENAME_SPLIT.matcher(path);
                if (!renameSplitMatcher.matches() || renameSplitMatcher.groupCount() < 2) continue;
                String oldPath = renameSplitMatcher.group(1);
                String newPath = renameSplitMatcher.group(2);
                this.paths.add(new Path(src, dst, 'D', oldPath, this, null));
                this.paths.add(new Path(src, dst, 'A', newPath, this, null));
                continue;
            }
            if (editMode == 'C') {
                Matcher copySplitMatcher = RENAME_SPLIT.matcher(path);
                if (!copySplitMatcher.matches() || copySplitMatcher.groupCount() < 2) continue;
                String newPath = copySplitMatcher.group(2);
                this.paths.add(new Path(src, dst, 'A', newPath, this, null));
                continue;
            }
            this.paths.add(new Path(src, dst, editMode, path, this, null));
        }
        this.comment = message;
        int endOfFirstLine = this.comment.indexOf(10);
        this.title = endOfFirstLine == -1 ? this.comment : this.comment.substring(0, endOfFirstLine);
    }

    private String parseHash(String hash) {
        return NULL_HASH.equals(hash) ? null : hash;
    }

    @Exported
    public String getDate() {
        Date csDate;
        String csTz;
        String csTime;
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (this.authorOrCommitter) {
            csTime = this.authorTime;
            csTz = this.authorTz;
        } else {
            csTime = this.committerTime;
            csTz = this.committerTz;
        }
        try {
            csDate = new Date(Long.parseLong(csTime) * 1000L);
        }
        catch (NumberFormatException e) {
            csDate = new Date();
        }
        String dateStr = fmt.format(csDate) + " " + csTz;
        return dateStr;
    }

    public void setParent(ChangeLogSet parent) {
        LOGGER.log(Level.FINEST, "Set parent " + parent);
        super.setParent(parent);
    }

    public String getParentCommit() {
        return this.parentCommit;
    }

    public Collection<String> getAffectedPaths() {
        HashSet<String> affectedPaths = new HashSet<String>(this.paths.size());
        for (Path file : this.paths) {
            affectedPaths.add(file.getPath());
        }
        return affectedPaths;
    }

    @Exported
    public Collection<Path> getPaths() {
        return this.paths;
    }

    public Collection<Path> getAffectedFiles() {
        return this.paths;
    }

    @Exported
    public User getAuthor() {
        String csAuthorEmail;
        String csAuthor;
        if (this.authorOrCommitter) {
            csAuthor = this.author;
            csAuthorEmail = this.authorEmail;
        } else {
            csAuthor = this.committer;
            csAuthorEmail = this.committerEmail;
        }
        if (csAuthor == null) {
            throw new RuntimeException("No author in this changeset!");
        }
        User user = User.get((String)csAuthor, (boolean)true);
        if (Util.fixEmpty((String)csAuthorEmail) != null) {
            try {
                user.addProperty((UserProperty)new Mailer.UserProperty(csAuthorEmail));
            }
            catch (IOException e) {
                LOGGER.log(Level.FINEST, "Failed to add email to user properties.", e);
            }
        }
        return user;
    }

    public String getAuthorName() {
        String csAuthor = this.authorOrCommitter ? this.author : this.committer;
        if (csAuthor == null) {
            throw new RuntimeException("No author in this changeset!");
        }
        return csAuthor;
    }

    @Exported
    public String getMsg() {
        return this.title;
    }

    @Exported
    public String getId() {
        return this.id;
    }

    public String getRevision() {
        return this.id;
    }

    @Exported
    public String getComment() {
        return this.comment;
    }

    public String getCommentAnnotated() {
        MarkupText markup = new MarkupText(this.getComment());
        for (ChangeLogAnnotator a : ChangeLogAnnotator.all()) {
            a.annotate(this.getParent().build, (ChangeLogSet.Entry)this, markup);
        }
        return markup.toString(false);
    }
}

