/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.model.EnvironmentSpecific;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitTool;
import hudson.scm.SCMDescriptor;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public final class GitTool
extends ToolInstallation
implements NodeSpecific<GitTool>,
EnvironmentSpecific<GitTool> {
    static final transient String defaultValueName = "Default";

    @DataBoundConstructor
    public GitTool(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    public String getGitExe() {
        return this.getHome();
    }

    public static void onLoaded() {
        DescriptorImpl descriptor = (DescriptorImpl)Hudson.getInstance().getDescriptor(GitTool.class);
        GitTool[] installations = GitTool.getInstallations((DescriptorImpl)descriptor);
        if (installations.length > 0) {
            return;
        }
        DescriptorExtensionList scms = GitSCM.all();
        String defaultGitExe = File.separatorChar != '/' ? "git.exe" : "git";
        for (SCMDescriptor s : scms) {
            GitSCM.DescriptorImpl desc;
            if (!(s instanceof GitSCM.DescriptorImpl) || (desc = (GitSCM.DescriptorImpl)s).getOldGitExe() == null) continue;
            defaultGitExe = desc.getOldGitExe();
        }
        GitTool tool = new GitTool("Default", defaultGitExe, Collections.emptyList());
        descriptor.setInstallations((ToolInstallation[])new GitTool[]{tool});
        descriptor.save();
    }

    private static GitTool[] getInstallations(DescriptorImpl descriptor) {
        GitTool[] installations = null;
        try {
            installations = (GitTool[])descriptor.getInstallations();
        }
        catch (NullPointerException e) {
            installations = new GitTool[]{};
        }
        return installations;
    }

    public GitTool forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new GitTool(this.getName(), this.translateFor(node, log), Collections.emptyList());
    }

    public GitTool forEnvironment(EnvVars environment) {
        return new GitTool(this.getName(), environment.expand(this.getHome()), Collections.emptyList());
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptor(GitTool.class);
    }
}

