/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Revision;
import hudson.util.ArgumentListBuilder;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.Ref;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.lib.Tag;
import org.spearce.jgit.transport.RefSpec;
import org.spearce.jgit.transport.RemoteConfig;
import org.spearce.jgit.transport.URIish;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitAPI
implements IGitAPI {
    private static final Logger LOGGER = Logger.getLogger(GitAPI.class.getName());
    Launcher launcher;
    FilePath workspace;
    TaskListener listener;
    String gitExe;
    EnvVars environment;

    public GitAPI(String gitExe, FilePath workspace, TaskListener listener, EnvVars environment) {
        this.workspace = workspace;
        this.listener = listener;
        this.gitExe = gitExe;
        this.environment = environment;
        for (Map.Entry ent : environment.entrySet()) {
        }
        this.launcher = new Launcher.LocalLauncher(GitSCM.VERBOSE ? listener : TaskListener.NULL);
    }

    public String getGitExe() {
        return this.gitExe;
    }

    public EnvVars getEnvironment() {
        return this.environment;
    }

    public void init() throws GitException {
        if (this.hasGitRepo()) {
            throw new GitException(".git directory already exists! Has it already been initialised?");
        }
        try {
            Repository repo = new Repository(new File(this.workspace.child(".git").getRemote()));
            repo.create();
        }
        catch (IOException ioe) {
            throw new GitException("Error initiating git repo.", (Throwable)ioe);
        }
    }

    public boolean hasGitRepo() throws GitException {
        return this.hasGitRepo(".git");
    }

    public boolean hasGitRepo(String GIT_DIR) throws GitException {
        try {
            FilePath dotGit = this.workspace.child(GIT_DIR);
            return dotGit.exists();
        }
        catch (SecurityException ex) {
            throw new GitException("Security error when trying to check for .git. Are you sure you have correct permissions?", (Throwable)ex);
        }
        catch (Exception e) {
            throw new GitException("Couldn't check for .git", (Throwable)e);
        }
    }

    public boolean hasGitModules() throws GitException {
        try {
            FilePath dotGit = this.workspace.child(".gitmodules");
            return dotGit.exists();
        }
        catch (SecurityException ex) {
            throw new GitException("Security error when trying to check for .gitmodules. Are you sure you have correct permissions?", (Throwable)ex);
        }
        catch (Exception e) {
            throw new GitException("Couldn't check for .gitmodules", (Throwable)e);
        }
    }

    public List<IndexEntry> getSubmodules(String treeIsh) throws GitException {
        List submodules = this.lsTree(treeIsh);
        Iterator it = submodules.iterator();
        while (it.hasNext()) {
            if (((IndexEntry)it.next()).getMode().equals("160000")) continue;
            it.remove();
        }
        return submodules;
    }

    public boolean hasGitModules(String treeIsh) throws GitException {
        return this.hasGitModules() && this.getSubmodules(treeIsh).size() > 0;
    }

    public void fetch(String repository, String refspec) throws GitException {
        this.listener.getLogger().println("Fetching upstream changes" + (repository != null ? " from " + repository : ""));
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"fetch", "-t"});
        if (repository != null) {
            args.add(repository);
            if (refspec != null) {
                args.add(refspec);
            }
        }
        this.launchCommand(args);
    }

    public void fetch() throws GitException {
        this.fetch(null, null);
    }

    public void clone(RemoteConfig remoteConfig) throws GitException {
        this.listener.getLogger().println("Cloning repository " + remoteConfig.getName());
        try {
            this.workspace.deleteRecursive();
        }
        catch (Exception e) {
            e.printStackTrace(this.listener.error("Failed to clean the workspace"));
            throw new GitException("Failed to delete workspace", (Throwable)e);
        }
        String source = ((URIish)remoteConfig.getURIs().get(0)).toPrivateString();
        try {
            this.workspace.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            throw new GitException("Could not clone " + source, (Throwable)e);
        }
    }

    public void clean() throws GitException {
        this.launchCommand(new String[]{"clean", "-fdx"});
    }

    public ObjectId revParse(String revName) throws GitException {
        String result = this.launchCommand(new String[]{"rev-parse", revName});
        return ObjectId.fromString((String)this.firstLine(result).trim());
    }

    public String describe(String commitIsh) throws GitException {
        String result = this.launchCommand(new String[]{"describe", "--tags", commitIsh});
        return this.firstLine(result).trim();
    }

    public void prune(RemoteConfig repository) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"remote", "prune", repository.getName()});
        this.launchCommand(args);
    }

    private String firstLine(String result) {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(result));
        try {
            line = reader.readLine();
            if (line == null) {
                return null;
            }
            if (reader.readLine() != null) {
                throw new GitException("Result has multiple lines");
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing result", (Throwable)e);
        }
        return line;
    }

    public void changelog(String revFrom, String revTo, OutputStream outputStream) throws GitException {
        this.whatchanged(revFrom, revTo, outputStream, new String[]{"--no-abbrev", "-M", "--pretty=raw"});
    }

    private void whatchanged(String revFrom, String revTo, OutputStream outputStream, String ... extraargs) throws GitException {
        String revSpec = revFrom + ".." + revTo;
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "whatchanged"});
        args.add(extraargs);
        args.add(revSpec);
        try {
            if (this.launcher.launch().cmds(args).envs((Map)this.environment).stdout(outputStream).pwd(this.workspace).join() != 0) {
                throw new GitException("Error launching git whatchanged");
            }
        }
        catch (Exception e) {
            throw new GitException("Error performing git whatchanged", (Throwable)e);
        }
    }

    public List<String> showRevision(Revision r) throws GitException {
        String revName = r.getSha1String();
        String result = "";
        if (revName != null) {
            result = this.launchCommand(new String[]{"show", "--no-abbrev", "--format=raw", "-M", "--raw", revName});
        }
        ArrayList<String> revShow = new ArrayList<String>();
        if (result != null) {
            revShow = new ArrayList<String>(Arrays.asList(result.split("\\n")));
        }
        return revShow;
    }

    public void merge(String revSpec) throws GitException {
        try {
            this.launchCommand(new String[]{"merge", revSpec});
        }
        catch (GitException e) {
            throw new GitException("Could not merge " + revSpec, (Throwable)e);
        }
    }

    public void submoduleInit() throws GitException {
        this.launchCommand(new String[]{"submodule", "init"});
    }

    public void submoduleSync() throws GitException {
        this.launchCommand(new String[]{"submodule", "sync"});
    }

    public void submoduleUpdate(boolean recursive) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"submodule", "update"});
        if (recursive) {
            args.add(new String[]{"--init", "--recursive"});
        }
        this.launchCommand(args);
    }

    public void submoduleClean(boolean recursive) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"submodule", "foreach"});
        if (recursive) {
            args.add("--recursive");
        }
        args.add("git clean -fdx");
        this.launchCommand(args);
    }

    public String getSubmoduleUrl(String name) throws GitException {
        String result = this.launchCommand(new String[]{"config", "--get", "submodule." + name + ".url"});
        return this.firstLine(result).trim();
    }

    public void setSubmoduleUrl(String name, String url) throws GitException {
        this.launchCommand(new String[]{"config", "submodule." + name + ".url", url});
    }

    public String getRemoteUrl(String name) throws GitException {
        String result = this.launchCommand(new String[]{"config", "--get", "remote." + name + ".url"});
        return this.firstLine(result).trim();
    }

    public void setRemoteUrl(String name, String url) throws GitException {
        this.launchCommand(new String[]{"config", "remote." + name + ".url", url});
    }

    public String getRemoteUrl(String name, String GIT_DIR) throws GitException {
        String result = this.launchCommand(new String[]{"--git-dir=" + GIT_DIR, "config", "--get", "remote." + name + ".url"});
        return this.firstLine(result).trim();
    }

    public void setRemoteUrl(String name, String url, String GIT_DIR) throws GitException {
        this.launchCommand(new String[]{"--git-dir=" + GIT_DIR, "config", "remote." + name + ".url", url});
    }

    public String getDefaultRemote(String _default_) throws GitException {
        BufferedReader rdr = new BufferedReader(new StringReader(this.launchCommand(new String[]{"remote"})));
        ArrayList<String> remotes = new ArrayList<String>();
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                remotes.add(line);
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing remotes", (Throwable)e);
        }
        if (remotes.contains(_default_)) {
            return _default_;
        }
        if (remotes.size() >= 1) {
            return (String)remotes.get(0);
        }
        throw new GitException("No remotes found!");
    }

    public String getDefaultRemote() throws GitException {
        return this.getDefaultRemote("origin");
    }

    public boolean isBareRepository() throws GitException {
        return this.isBareRepository("");
    }

    public boolean isBareRepository(String GIT_DIR) throws GitException {
        String ret = null;
        if ("".equals(GIT_DIR)) {
            ret = this.launchCommand(new String[]{"rev-parse", "--is-bare-repository"});
        } else {
            String gitDir = "--git-dir=" + GIT_DIR;
            ret = this.launchCommand(new String[]{gitDir, "rev-parse", "--is-bare-repository"});
        }
        return !"false".equals(this.firstLine(ret).trim());
    }

    private String pathJoin(String a, String b) {
        return new File(a, b).toString();
    }

    public void fixSubmoduleUrls(String remote, TaskListener listener) throws GitException {
        URI origin;
        boolean is_bare = true;
        try {
            String url = this.getRemoteUrl(remote);
            String gitEnd = this.pathJoin("", ".git");
            if (url.endsWith(gitEnd)) {
                url = url.substring(0, url.length() - gitEnd.length());
                is_bare = false;
            }
            origin = new URI(url);
        }
        catch (URISyntaxException e) {
            return;
        }
        catch (Exception e) {
            throw new GitException("Could determine remote.origin.url", (Throwable)e);
        }
        if (origin.getScheme() == null || "file".equalsIgnoreCase(origin.getScheme()) && (origin.getHost() == null || "".equals(origin.getHost()))) {
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(origin.getPath());
            paths.add(this.pathJoin(origin.getPath(), ".git"));
            for (String path : paths) {
                try {
                    is_bare = this.isBareRepository(path);
                    break;
                }
                catch (GitException e) {
                    LOGGER.log(Level.FINEST, "Exception occurred while detecting repository type by path: " + path);
                }
            }
        }
        if (!is_bare) {
            try {
                List submodules = this.getSubmodules("HEAD");
                for (IndexEntry submodule : submodules) {
                    String sUrl = this.pathJoin(origin.getPath(), submodule.getFile());
                    this.setSubmoduleUrl(submodule.getFile(), sUrl);
                    String subGitDir = this.pathJoin(submodule.getFile(), ".git");
                    if (!this.hasGitRepo(subGitDir) || "".equals(this.getRemoteUrl("origin", subGitDir))) continue;
                    this.setRemoteUrl("origin", sUrl, subGitDir);
                }
            }
            catch (GitException e) {
                LOGGER.log(Level.FINEST, "Exception occurred while working with git repo.");
            }
        } else {
            LOGGER.log(Level.FINER, "The origin is non-bare.");
        }
    }

    public void setupSubmoduleUrls(Revision rev, TaskListener listener) throws GitException {
        String remote;
        Iterator bi = rev.getBranches().iterator();
        if (bi.hasNext()) {
            String b = ((Branch)bi.next()).getName();
            if (b != null) {
                int slash = b.indexOf(47);
                if (slash == -1) {
                    throw new GitException("no remote from branch name (" + b + ")");
                }
                remote = this.getDefaultRemote(b.substring(0, slash));
            } else {
                remote = this.getDefaultRemote();
            }
        } else {
            remote = this.getDefaultRemote();
        }
        this.setupSubmoduleUrls(remote, listener);
    }

    public void setupSubmoduleUrls(String remote, TaskListener listener) throws GitException {
        this.submoduleInit();
        this.submoduleSync();
        this.fixSubmoduleUrls(remote, listener);
    }

    public void tag(String tagName, String comment) throws GitException {
        tagName = tagName.replace(' ', '_');
        try {
            this.launchCommand(new String[]{"tag", "-a", "-f", "-m", comment, tagName});
        }
        catch (GitException e) {
            throw new GitException("Could not apply tag " + tagName, (Throwable)e);
        }
    }

    public String launchCommand(ArgumentListBuilder args) throws GitException {
        return this.launchCommandIn(args, this.workspace);
    }

    public String launchCommand(String ... args) throws GitException {
        return this.launchCommand(new ArgumentListBuilder(args));
    }

    private String launchCommandIn(ArgumentListBuilder args, FilePath workDir) throws GitException {
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        try {
            args.prepend(new String[]{this.getGitExe()});
            int status = this.launcher.launch().cmds(args.toCommandArray()).envs((Map)this.environment).stdout((OutputStream)fos).pwd(workDir).join();
            String result = fos.toString();
            if (status != 0) {
                throw new GitException("Command \"" + StringUtils.join((Object[])args.toCommandArray(), (String)" ") + "\" returned status code " + status + ": " + result);
            }
            return result;
        }
        catch (Exception e) {
            throw new GitException("Error performing command: " + StringUtils.join((Object[])args.toCommandArray(), (String)" ") + "\n" + e.getMessage(), (Throwable)e);
        }
    }

    public void push(RemoteConfig repository, String refspec) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"push", ((URIish)repository.getURIs().get(0)).toPrivateString()});
        if (refspec != null) {
            args.add(refspec);
        }
        this.launchCommand(args);
    }

    private List<Branch> parseBranches(String fos) throws GitException {
        ArrayList<Branch> tags = new ArrayList<Branch>();
        BufferedReader rdr = new BufferedReader(new StringReader(fos));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                if ((line = line.substring(2)).startsWith("(") || line.indexOf(" -> ") != -1) continue;
                tags.add(new Branch(line, this.revParse(line)));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing branches", (Throwable)e);
        }
        return tags;
    }

    public List<Branch> getBranches() throws GitException {
        return this.parseBranches(this.launchCommand(new String[]{"branch", "-a"}));
    }

    public List<Branch> getRemoteBranches() throws GitException, IOException {
        Repository db = this.getRepository();
        Map refs = db.getAllRefs();
        ArrayList<Branch> branches = new ArrayList<Branch>();
        for (Ref candidate : refs.values()) {
            if (!candidate.getName().startsWith("refs/remotes/")) continue;
            Branch buildBranch = new Branch(candidate);
            this.listener.getLogger().println("Seen branch in repository " + buildBranch.getName());
            branches.add(buildBranch);
        }
        return branches;
    }

    public List<Branch> getBranchesContaining(String revspec) throws GitException {
        return this.parseBranches(this.launchCommand(new String[]{"branch", "-a", "--contains", revspec}));
    }

    public void checkout(String commitish) throws GitException {
        this.checkoutBranch(null, commitish);
    }

    public void checkoutBranch(String branch, String commitish) throws GitException {
        try {
            this.launchCommand(new String[]{"checkout", "-f", commitish});
            if (branch != null) {
                for (Branch b : this.getBranches()) {
                    if (!b.name.equals(branch)) continue;
                    this.deleteBranch(branch);
                }
                this.launchCommand(new String[]{"checkout", "-b", branch, commitish});
            }
        }
        catch (GitException e) {
            throw new GitException("Could not checkout " + branch + " with start point " + commitish, (Throwable)e);
        }
    }

    public boolean tagExists(String tagName) throws GitException {
        tagName = tagName.replace(' ', '_');
        return this.launchCommand(new String[]{"tag", "-l", tagName}).trim().equals(tagName);
    }

    public void deleteBranch(String name) throws GitException {
        try {
            this.launchCommand(new String[]{"branch", "-D", name});
        }
        catch (GitException e) {
            throw new GitException("Could not delete branch " + name, (Throwable)e);
        }
    }

    public void deleteTag(String tagName) throws GitException {
        tagName = tagName.replace(' ', '_');
        try {
            this.launchCommand(new String[]{"tag", "-d", tagName});
        }
        catch (GitException e) {
            throw new GitException("Could not delete tag " + tagName, (Throwable)e);
        }
    }

    public List<IndexEntry> lsTree(String treeIsh) throws GitException {
        ArrayList<IndexEntry> entries = new ArrayList<IndexEntry>();
        String result = this.launchCommand(new String[]{"ls-tree", treeIsh});
        BufferedReader rdr = new BufferedReader(new StringReader(result));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                String[] entry = line.split("\\s+");
                entries.add(new IndexEntry(entry[0], entry[1], entry[2], entry[3]));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing ls tree", (Throwable)e);
        }
        return entries;
    }

    public List<ObjectId> revListAll() throws GitException {
        return this.revList(new String[]{"--all"});
    }

    public List<ObjectId> revListBranch(String branchId) throws GitException {
        return this.revList(new String[]{branchId});
    }

    public List<ObjectId> revList(String ... extraArgs) throws GitException {
        ArrayList<ObjectId> entries = new ArrayList<ObjectId>();
        ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"rev-list"});
        args.add(extraArgs);
        String result = this.launchCommand(args);
        BufferedReader rdr = new BufferedReader(new StringReader(result));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                entries.add(ObjectId.fromString((String)line));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing rev list", (Throwable)e);
        }
        return entries;
    }

    public boolean isCommitInRepo(String sha1) {
        try {
            List revs = this.revList(new String[]{sha1});
            return revs.size() != 0;
        }
        catch (GitException e) {
            return false;
        }
    }

    public void add(String filePattern) throws GitException {
        try {
            this.launchCommand(new String[]{"add", filePattern});
        }
        catch (GitException e) {
            throw new GitException("Cannot add " + filePattern, (Throwable)e);
        }
    }

    public void branch(String name) throws GitException {
        try {
            this.launchCommand(new String[]{"branch", name});
        }
        catch (GitException e) {
            throw new GitException("Cannot create branch " + name, (Throwable)e);
        }
    }

    public void commit(File f) throws GitException {
        try {
            this.launchCommand(new String[]{"commit", "-F", f.getAbsolutePath()});
        }
        catch (GitException e) {
            throw new GitException("Cannot commit " + f, (Throwable)e);
        }
    }

    public void fetch(RemoteConfig remoteRepository) throws GitException {
        this.fetch(((URIish)remoteRepository.getURIs().get(0)).toPrivateString(), ((RefSpec)remoteRepository.getFetchRefSpecs().get(0)).toString());
    }

    public ObjectId mergeBase(ObjectId id1, ObjectId id2) {
        try {
            String result;
            try {
                result = this.launchCommand(new String[]{"merge-base", id1.name(), id2.name()});
            }
            catch (GitException ge) {
                return null;
            }
            BufferedReader rdr = new BufferedReader(new StringReader(result));
            String line = rdr.readLine();
            if (line != null) {
                return ObjectId.fromString((String)line);
            }
        }
        catch (Exception e) {
            throw new GitException("Error parsing merge base", (Throwable)e);
        }
        return null;
    }

    public String getAllLogEntries(String branch) {
        return this.launchCommand(new String[]{"log", "--all", "--pretty=format:'%H#%ct'", branch});
    }

    private Repository getRepository() throws IOException {
        return new Repository(new File(this.workspace.getRemote(), ".git"));
    }

    public List<Tag> getTagsOnCommit(String revName) throws GitException, IOException {
        Repository db = this.getRepository();
        ObjectId commit = db.resolve(revName);
        ArrayList<Tag> ret = new ArrayList<Tag>();
        for (Map.Entry tag : db.getTags().entrySet()) {
            Tag ttag = db.mapTag((String)tag.getKey());
            if (!ttag.getObjId().equals(commit)) continue;
            ret.add(ttag);
        }
        return ret;
    }

    public Set<String> getTagNames(String tagPattern) throws GitException {
        try {
            String tag;
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add(new String[]{"tag", "-l", tagPattern});
            String result = this.launchCommandIn(args, this.workspace);
            HashSet<String> tags = new HashSet<String>();
            BufferedReader rdr = new BufferedReader(new StringReader(result));
            while ((tag = rdr.readLine()) != null) {
                tags.add(tag);
            }
            return tags;
        }
        catch (Exception e) {
            throw new GitException("Error retrieving tag names", (Throwable)e);
        }
    }

    static /* synthetic */ String access$000(GitAPI x0, ArgumentListBuilder x1, FilePath x2) throws GitException {
        return x0.launchCommandIn(x1, x2);
    }
}

