/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitAPI;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Revision;
import hudson.plugins.git.RevisionParameterAction;
import hudson.plugins.git.SubmoduleCombinator;
import hudson.plugins.git.SubmoduleConfig;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.browser.GitWeb;
import hudson.plugins.git.opt.PreBuildMergeOptions;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.BuildChooserDescriptor;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.DefaultBuildChooser;
import hudson.plugins.git.util.GitUtils;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.util.FormValidation;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.RepositoryConfig;
import org.spearce.jgit.transport.RefSpec;
import org.spearce.jgit.transport.RemoteConfig;
import org.spearce.jgit.transport.URIish;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitSCM
extends SCM
implements Serializable {
    public static final String GIT_BRANCH = "GIT_BRANCH";
    public static final String GIT_COMMIT = "GIT_COMMIT";
    private static final long serialVersionUID = 1L;
    @Deprecated
    transient String source;
    @Deprecated
    transient String branch;
    private Long configVersion;
    private List<RemoteConfig> remoteRepositories;
    private List<BranchSpec> branches;
    private String localBranch;
    private PreBuildMergeOptions mergeOptions;
    private boolean recursiveSubmodules;
    private boolean doGenerateSubmoduleConfigurations;
    private boolean authorOrCommitter;
    private boolean clean;
    private boolean wipeOutWorkspace;
    private boolean pruneBranches;
    private transient String choosingStrategy;
    private BuildChooser buildChooser;
    private String gitTool = null;
    private GitRepositoryBrowser browser;
    private Collection<SubmoduleConfig> submoduleCfg;
    private String relativeTargetDir;
    private String excludedRegions;
    private String excludedUsers;
    private String gitConfigName;
    private String gitConfigEmail;
    private boolean skipTag;
    private static final Logger LOGGER = Logger.getLogger(GitSCM.class.getName());
    public static boolean VERBOSE = Boolean.getBoolean(GitSCM.class.getName() + ".verbose");

    public Collection<SubmoduleConfig> getSubmoduleCfg() {
        return this.submoduleCfg;
    }

    public void setSubmoduleCfg(Collection<SubmoduleConfig> submoduleCfg) {
        this.submoduleCfg = submoduleCfg;
    }

    public GitSCM(String repositoryUrl) throws IOException {
        this(DescriptorImpl.createRepositoryConfigurations(new String[]{repositoryUrl}, new String[]{null}, new String[]{null}), Collections.singletonList(new BranchSpec("")), new PreBuildMergeOptions(), false, Collections.emptyList(), false, false, new DefaultBuildChooser(), null, null, false, null, null, null, null, false, false, null, null, false);
    }

    @DataBoundConstructor
    public GitSCM(List<RemoteConfig> repositories, List<BranchSpec> branches, PreBuildMergeOptions mergeOptions, boolean doGenerateSubmoduleConfigurations, Collection<SubmoduleConfig> submoduleCfg, boolean clean, boolean wipeOutWorkspace, BuildChooser buildChooser, GitRepositoryBrowser browser, String gitTool, boolean authorOrCommitter, String relativeTargetDir, String excludedRegions, String excludedUsers, String localBranch, boolean recursiveSubmodules, boolean pruneBranches, String gitConfigName, String gitConfigEmail, boolean skipTag) {
        this.branches = branches;
        this.localBranch = Util.fixEmptyAndTrim((String)localBranch);
        this.remoteRepositories = repositories;
        this.browser = browser;
        this.mergeOptions = mergeOptions;
        this.doGenerateSubmoduleConfigurations = doGenerateSubmoduleConfigurations;
        this.submoduleCfg = submoduleCfg;
        this.clean = clean;
        this.wipeOutWorkspace = wipeOutWorkspace;
        this.configVersion = 1L;
        this.gitTool = gitTool;
        this.authorOrCommitter = authorOrCommitter;
        this.buildChooser = buildChooser;
        this.relativeTargetDir = relativeTargetDir;
        this.excludedRegions = excludedRegions;
        this.excludedUsers = excludedUsers;
        this.recursiveSubmodules = recursiveSubmodules;
        this.pruneBranches = pruneBranches;
        this.gitConfigName = gitConfigName;
        this.gitConfigEmail = gitConfigEmail;
        this.skipTag = skipTag;
        buildChooser.gitSCM = this;
    }

    public Object readResolve() {
        if (this.configVersion == null) {
            this.configVersion = 0L;
        }
        if (this.source != null) {
            this.remoteRepositories = new ArrayList<RemoteConfig>();
            this.branches = new ArrayList<BranchSpec>();
            this.doGenerateSubmoduleConfigurations = false;
            this.mergeOptions = new PreBuildMergeOptions();
            this.recursiveSubmodules = false;
            this.remoteRepositories.add(this.newRemoteConfig("origin", this.source, new RefSpec("+refs/heads/*:refs/remotes/origin/*")));
            if (this.branch != null) {
                this.branches.add(new BranchSpec(this.branch));
            } else {
                this.branches.add(new BranchSpec("*/master"));
            }
        }
        if (this.configVersion < 1L && this.branches != null) {
            for (BranchSpec branchSpec : this.branches) {
                String name = branchSpec.getName();
                name = name.replace("*", "**");
                branchSpec.setName(name);
            }
        }
        if (this.mergeOptions.doMerge() && this.mergeOptions.getMergeRemote() == null) {
            this.mergeOptions.setMergeRemote(this.remoteRepositories.get(0));
        }
        if (this.choosingStrategy != null && this.buildChooser == null) {
            for (BuildChooserDescriptor d : BuildChooser.all()) {
                if (!this.choosingStrategy.equals(d.getLegacyId())) continue;
                try {
                    this.buildChooser = (BuildChooser)d.clazz.newInstance();
                }
                catch (InstantiationException e) {
                    LOGGER.log(Level.WARNING, "Failed to instantiate the build chooser", e);
                }
                catch (IllegalAccessException e) {
                    LOGGER.log(Level.WARNING, "Failed to instantiate the build chooser", e);
                }
            }
        }
        if (this.buildChooser == null) {
            this.buildChooser = new DefaultBuildChooser();
        }
        this.buildChooser.gitSCM = this;
        return this;
    }

    public String getExcludedRegions() {
        return this.excludedRegions;
    }

    public String[] getExcludedRegionsNormalized() {
        return this.excludedRegions == null || this.excludedRegions.trim().equals("") ? null : this.excludedRegions.split("[\\r\\n]+");
    }

    public String getExcludedUsers() {
        return this.excludedUsers;
    }

    public Set<String> getExcludedUsersNormalized() {
        String s = Util.fixEmptyAndTrim((String)this.excludedUsers);
        if (s == null) {
            return Collections.emptySet();
        }
        HashSet<String> users = new HashSet<String>();
        for (String user : s.split("[\\r\\n]+")) {
            users.add(user.trim());
        }
        return users;
    }

    public GitRepositoryBrowser getBrowser() {
        return this.browser;
    }

    public String getGitConfigName() {
        return this.gitConfigName;
    }

    public String getGitConfigEmail() {
        return this.gitConfigEmail;
    }

    public String getGitConfigNameToUse() {
        String globalConfigName = ((DescriptorImpl)this.getDescriptor()).getGlobalConfigName();
        String confName = globalConfigName != null && this.gitConfigName == null && !Util.fixEmptyAndTrim((String)globalConfigName).equals("") ? globalConfigName : this.gitConfigName;
        return Util.fixEmptyAndTrim((String)confName);
    }

    public String getGitConfigEmailToUse() {
        String globalConfigEmail = ((DescriptorImpl)this.getDescriptor()).getGlobalConfigEmail();
        String confEmail = globalConfigEmail != null && this.gitConfigEmail == null && !Util.fixEmptyAndTrim((String)globalConfigEmail).equals("") ? globalConfigEmail : this.gitConfigEmail;
        return Util.fixEmptyAndTrim((String)confEmail);
    }

    public boolean getSkipTag() {
        return this.skipTag;
    }

    public boolean getPruneBranches() {
        return this.pruneBranches;
    }

    public boolean getWipeOutWorkspace() {
        return this.wipeOutWorkspace;
    }

    public boolean getClean() {
        return this.clean;
    }

    public BuildChooser getBuildChooser() {
        return this.buildChooser;
    }

    public List<RemoteConfig> getParamExpandedRepos(AbstractBuild<?, ?> build) {
        ArrayList<RemoteConfig> expandedRepos = new ArrayList<RemoteConfig>();
        for (RemoteConfig oldRepo : Util.fixNull(this.remoteRepositories)) {
            expandedRepos.add(this.newRemoteConfig(oldRepo.getName(), ((URIish)oldRepo.getURIs().get(0)).toPrivateString(), new RefSpec(this.getRefSpec(oldRepo, build))));
        }
        return expandedRepos;
    }

    public RemoteConfig getRepositoryByName(String repoName) {
        for (RemoteConfig r : this.getRepositories()) {
            if (!r.getName().equals(repoName)) continue;
            return r;
        }
        return null;
    }

    public List<RemoteConfig> getRepositories() {
        if (this.remoteRepositories == null) {
            return new ArrayList<RemoteConfig>();
        }
        return this.remoteRepositories;
    }

    public String getGitTool() {
        return this.gitTool;
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> abstractBuild, Launcher launcher, TaskListener taskListener) throws IOException, InterruptedException {
        return SCMRevisionState.NONE;
    }

    public RemoteConfig getSubmoduleRepository(IGitAPI parentGit, RemoteConfig orig, String name) throws GitException {
        String refUrl = parentGit.getSubmoduleUrl(name);
        return this.newRemoteConfig(name, refUrl, (RefSpec)orig.getFetchRefSpecs().get(0));
    }

    public String getGitExe(Node builtOn, TaskListener listener) {
        GitTool[] gitToolInstallations;
        for (GitTool t : gitToolInstallations = (GitTool[])((GitTool.DescriptorImpl)Hudson.getInstance().getDescriptorByType(GitTool.DescriptorImpl.class)).getInstallations()) {
            if (this.gitTool == null) {
                this.gitTool = t.getName();
            }
            if (!t.getName().equals(this.gitTool) || builtOn == null) continue;
            try {
                String s = t.forNode(builtOn, listener).getGitExe();
                return s;
            }
            catch (IOException e) {
                listener.getLogger().println("Failed to get git executable");
            }
            catch (InterruptedException e) {
                listener.getLogger().println("Failed to get git executable");
            }
        }
        return null;
    }

    public boolean getAuthorOrCommitter() {
        return this.authorOrCommitter;
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        RevisionParameterAction rpa;
        Revision parentLastBuiltRev;
        List<RemoteConfig> paramRepos;
        Revision revToBuild;
        BuildData parentBuildData;
        MatrixBuild parentBuild;
        String confEmail;
        listener.getLogger().println("Checkout:" + workspace.getName() + " / " + workspace.getRemote() + " - " + workspace.getChannel());
        listener.getLogger().println("Using strategy: " + this.buildChooser.getDisplayName());
        FilePath workingDirectory = this.workingDirectory(workspace);
        if (!workingDirectory.exists()) {
            workingDirectory.mkdirs();
        }
        int buildNumber = build.getNumber();
        String gitExe = this.getGitExe(build.getBuiltOn(), (TaskListener)listener);
        String internalTagName = "hudson" + "-" + build.getProject().getName() + "-" + build.getNumber();
        String internalTagComment = "Hudson Build #" + build.getNumber();
        BuildData buildData = this.getBuildData(build.getPreviousBuild(), true);
        if (buildData.lastBuild != null) {
            listener.getLogger().println("Last Built Revision: " + buildData.lastBuild.revision);
        }
        EnvVars environment = build.getEnvironment((TaskListener)listener);
        String confName = this.getGitConfigNameToUse();
        if (confName != null && !confName.equals("")) {
            environment.put("GIT_COMMITTER_NAME", confName);
            environment.put("GIT_AUTHOR_NAME", confName);
        }
        if ((confEmail = this.getGitConfigEmailToUse()) != null && !confEmail.equals("")) {
            environment.put("GIT_COMMITTER_EMAIL", confEmail);
            environment.put("GIT_AUTHOR_EMAIL", confEmail);
        }
        String singleBranch = this.getSingleBranch(build);
        String paramLocalBranch = this.getParamLocalBranch(build);
        Revision tempParentLastBuiltRev = null;
        if (build instanceof MatrixRun && (parentBuild = ((MatrixRun)build).getParentBuild()) != null && (parentBuildData = (BuildData)parentBuild.getAction(BuildData.class)) != null) {
            tempParentLastBuiltRev = parentBuildData.getLastBuiltRevision();
        }
        if ((revToBuild = this.gerRevisionToBuild(listener, workingDirectory, gitExe, buildData, environment, singleBranch, paramRepos = this.getParamExpandedRepos(build), parentLastBuiltRev = tempParentLastBuiltRev, rpa = (RevisionParameterAction)build.getAction(RevisionParameterAction.class))) == null) {
            listener.error("Nothing to do");
            return false;
        }
        listener.getLogger().println("Commencing build of " + revToBuild);
        environment.put(GIT_COMMIT, revToBuild.getSha1String());
        if (this.mergeOptions.doMerge() && !revToBuild.containsBranchName(this.mergeOptions.getRemoteBranchName())) {
            BuildConfig buildConfig = this.getMergedBuildConfig(listener, workingDirectory, buildNumber, gitExe, buildData, environment, paramLocalBranch, revToBuild, internalTagName, internalTagComment);
            build.addAction((Action)buildConfig.getBuildData());
            return this.changeLogResult(buildConfig.getChangeLog(), changelogFile);
        }
        BuildConfig buildConfig = this.getBuildConfig(listener, workingDirectory, buildNumber, gitExe, buildData, environment, paramLocalBranch, paramRepos, revToBuild, internalTagName, internalTagComment);
        build.addAction((Action)buildConfig.getBuildData());
        return this.changeLogResult(buildConfig.getChangeLog(), changelogFile);
    }

    private BuildConfig getBuildConfig(final BuildListener listener, FilePath workingDirectory, final int buildNumber, final String gitExe, final BuildData buildData, final EnvVars environment, final String paramLocalBranch, final List<RemoteConfig> paramRepos, final Revision revToBuild, final String internalTagName, final String internalTagComment) throws IOException, InterruptedException {
        return (BuildConfig)workingDirectory.act((FilePath.FileCallable)new FilePath.FileCallable<BuildConfig>(){
            private static final long serialVersionUID = 1L;

            public BuildConfig invoke(File localWorkspace, VirtualChannel channel) throws IOException {
                GitAPI git = new GitAPI(gitExe, new FilePath(localWorkspace), (TaskListener)listener, environment);
                listener.getLogger().println("Checking out " + revToBuild);
                if (GitSCM.this.getClean()) {
                    listener.getLogger().println("Cleaning workspace");
                    git.clean();
                }
                git.checkoutBranch(paramLocalBranch, revToBuild.getSha1().name());
                if (git.hasGitModules()) {
                    if (!GitSCM.this.recursiveSubmodules) {
                        for (RemoteConfig remoteRepository : paramRepos) {
                            GitSCM.this.fetchSubmodulesFrom(git, localWorkspace, (TaskListener)listener, remoteRepository);
                        }
                    }
                    git.setupSubmoduleUrls(revToBuild, (TaskListener)listener);
                    git.submoduleUpdate(GitSCM.this.recursiveSubmodules);
                }
                if (GitSCM.this.doGenerateSubmoduleConfigurations) {
                    SubmoduleCombinator combinator = new SubmoduleCombinator(git, (TaskListener)listener, localWorkspace, GitSCM.this.submoduleCfg);
                    combinator.createSubmoduleCombinations();
                }
                GitSCM.this.createInternalTag(git, internalTagName, internalTagComment);
                String changeLog = GitSCM.this.computeChangeLog(git, revToBuild, listener, buildData);
                buildData.saveBuild(new Build(revToBuild, buildNumber, null));
                return new BuildConfig(changeLog, buildData);
            }
        });
    }

    private BuildConfig getMergedBuildConfig(final BuildListener listener, FilePath workingDirectory, final int buildNumber, final String gitExe, final BuildData buildData, final EnvVars environment, final String paramLocalBranch, final Revision revToBuild, final String internalTagName, final String internalTagComment) throws IOException, InterruptedException {
        return (BuildConfig)workingDirectory.act((FilePath.FileCallable)new FilePath.FileCallable<BuildConfig>(){
            private static final long serialVersionUID = 1L;

            public BuildConfig invoke(File localWorkspace, VirtualChannel channel) throws IOException {
                GitAPI git = new GitAPI(gitExe, new FilePath(localWorkspace), (TaskListener)listener, environment);
                listener.getLogger().println("Merging " + revToBuild + " onto " + GitSCM.this.mergeOptions.getMergeTarget());
                ObjectId target = git.revParse(GitSCM.this.mergeOptions.getRemoteBranchName());
                git.checkoutBranch(paramLocalBranch, target.name());
                try {
                    git.merge(revToBuild.getSha1().name());
                }
                catch (Exception ex) {
                    listener.getLogger().println("Branch not suitable for integration as it does not merge cleanly");
                    git.checkoutBranch(paramLocalBranch, revToBuild.getSha1().name());
                    GitSCM.this.createInternalTag(git, internalTagName, internalTagComment);
                    buildData.saveBuild(new Build(revToBuild, buildNumber, Result.FAILURE));
                    return new BuildConfig(null, buildData);
                }
                if (git.hasGitModules()) {
                    git.setupSubmoduleUrls(revToBuild, (TaskListener)listener);
                    git.submoduleUpdate(GitSCM.this.recursiveSubmodules);
                }
                GitSCM.this.createInternalTag(git, internalTagName, internalTagComment);
                String changeLog = GitSCM.this.computeChangeLog(git, revToBuild, listener, buildData);
                Build build = new Build(revToBuild, buildNumber, null);
                buildData.saveBuild(build);
                GitUtils gu = new GitUtils((TaskListener)listener, git);
                build.mergeRevision = gu.getRevisionForSHA1(target);
                if (GitSCM.this.getClean()) {
                    listener.getLogger().println("Cleaning workspace");
                    git.clean();
                    if (git.hasGitModules()) {
                        git.submoduleClean(GitSCM.this.recursiveSubmodules);
                    }
                }
                return new BuildConfig(changeLog, buildData);
            }
        });
    }

    private Revision gerRevisionToBuild(final BuildListener listener, FilePath workingDirectory, final String gitExe, final BuildData buildData, final EnvVars environment, final String singleBranch, final List<RemoteConfig> paramRepos, final Revision parentLastBuiltRev, final RevisionParameterAction rpa) throws IOException, InterruptedException {
        return (Revision)workingDirectory.act((FilePath.FileCallable)new FilePath.FileCallable<Revision>(){
            private static final long serialVersionUID = 1L;

            public Revision invoke(File localWorkspace, VirtualChannel channel) throws IOException {
                FilePath ws = new FilePath(localWorkspace);
                listener.getLogger().println("Checkout:" + ws.getName() + " / " + ws.getRemote() + " - " + ws.getChannel());
                GitAPI git = new GitAPI(gitExe, ws, (TaskListener)listener, environment);
                if (GitSCM.this.wipeOutWorkspace) {
                    listener.getLogger().println("Wiping out workspace first.");
                    try {
                        ws.deleteContents();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (git.hasGitRepo()) {
                    if (GitSCM.this.pruneBranches) {
                        listener.getLogger().println("Pruning obsolete local branches");
                        for (RemoteConfig remoteRepository : paramRepos) {
                            git.prune(remoteRepository);
                        }
                    }
                    listener.getLogger().println("Fetching changes from the remote Git repository");
                    boolean fetched = false;
                    for (RemoteConfig remoteRepository : paramRepos) {
                        if (!GitSCM.this.fetchFrom(git, (TaskListener)listener, remoteRepository)) continue;
                        fetched = true;
                    }
                    if (!fetched) {
                        listener.error("Could not fetch from any repository");
                        throw new GitException("Could not fetch from any repository");
                    }
                } else {
                    listener.getLogger().println("Cloning the remote Git repository");
                    boolean successfullyCloned = false;
                    for (RemoteConfig rc : paramRepos) {
                        try {
                            git.clone(rc);
                            successfullyCloned = true;
                            break;
                        }
                        catch (GitException ex) {
                            listener.error("Error cloning remote repo '%s' : %s", new Object[]{rc.getName(), ex.getMessage()});
                            if (ex.getCause() != null) {
                                listener.error("Cause: %s", new Object[]{ex.getCause().getMessage()});
                            }
                            listener.getLogger().println("Trying next repository");
                        }
                    }
                    if (!successfullyCloned) {
                        listener.error("Could not clone repository");
                        throw new GitException("Could not clone");
                    }
                    boolean fetched = false;
                    for (RemoteConfig remoteRepository : paramRepos) {
                        try {
                            git.fetch(remoteRepository);
                            fetched = true;
                        }
                        catch (Exception e) {
                            listener.error("Problem fetching from " + remoteRepository.getName() + " / " + remoteRepository.getName() + " - could be unavailable. Continuing anyway");
                        }
                    }
                    if (!fetched) {
                        listener.error("Could not fetch from any repository");
                        throw new GitException("Could not fetch from any repository");
                    }
                    if (GitSCM.this.getClean()) {
                        listener.getLogger().println("Cleaning workspace");
                        git.clean();
                        if (git.hasGitModules()) {
                            git.submoduleClean(GitSCM.this.recursiveSubmodules);
                        }
                    }
                }
                if (parentLastBuiltRev != null) {
                    return parentLastBuiltRev;
                }
                if (rpa != null) {
                    return rpa.toRevision(git);
                }
                Collection<Revision> candidates = GitSCM.this.buildChooser.getCandidateRevisions(false, singleBranch, git, (TaskListener)listener, buildData);
                if (candidates.size() == 0) {
                    return null;
                }
                return candidates.iterator().next();
            }
        });
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        String commit;
        BuildData bd;
        super.buildEnvVars(build, env);
        String branch = this.getSingleBranch(build);
        if (branch != null) {
            env.put(GIT_BRANCH, branch);
        }
        if ((bd = this.fixNull(this.getBuildData((Run)build, false))) != null && bd.getLastBuiltRevision() != null && (commit = bd.getLastBuiltRevision().getSha1String()) != null) {
            env.put(GIT_COMMIT, commit);
        }
    }

    public ChangeLogParser createChangeLogParser() {
        return new GitChangeLogParser(this.getAuthorOrCommitter());
    }

    public boolean getRecursiveSubmodules() {
        return this.recursiveSubmodules;
    }

    public boolean getDoGenerate() {
        return this.doGenerateSubmoduleConfigurations;
    }

    public List<BranchSpec> getBranches() {
        return this.branches;
    }

    public PreBuildMergeOptions getMergeOptions() {
        return this.mergeOptions;
    }

    public BuildData getBuildData(Run build, boolean clone) {
        BuildData buildData = null;
        while (build != null && (buildData = (BuildData)build.getAction(BuildData.class)) == null) {
            build = build.getPreviousBuild();
        }
        if (buildData == null) {
            return clone ? new BuildData() : null;
        }
        if (clone) {
            return buildData.clone();
        }
        return buildData;
    }

    public String getLocalBranch() {
        return Util.fixEmpty((String)this.localBranch);
    }

    public String getParamLocalBranch(AbstractBuild<?, ?> build) {
        String branch = this.getLocalBranch();
        ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
        if (parameters != null) {
            branch = parameters.substitute(build, branch);
        }
        return branch;
    }

    public String getRelativeTargetDir() {
        return this.relativeTargetDir;
    }

    protected FilePath workingDirectory(FilePath workspace) {
        if (this.relativeTargetDir == null || this.relativeTargetDir.length() == 0 || this.relativeTargetDir.equals(".")) {
            return workspace;
        }
        return workspace.child(this.relativeTargetDir);
    }

    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, final TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        String singleBranch;
        List<RemoteConfig> paramRepos;
        String gitExe;
        Label label;
        listener.getLogger().println("Using strategy: " + this.buildChooser.getDisplayName());
        AbstractBuild lastBuild = (AbstractBuild)project.getLastBuild();
        if (lastBuild == null) {
            listener.getLogger().println("[poll] No previous build, so forcing an initial build.");
            return PollingResult.BUILD_NOW;
        }
        listener.getLogger().println("[poll] Last Build : #" + lastBuild.getNumber());
        BuildData buildData = this.fixNull(this.getBuildData((Run)lastBuild, false));
        if (buildData != null && buildData.lastBuild != null) {
            listener.getLogger().println("[poll] Last Built Revision: " + buildData.lastBuild.revision);
        }
        if ((label = project.getAssignedLabel()) != null && label.isSelfLabel()) {
            if (label.getNodes().iterator().next() != project.getLastBuiltOn()) {
                listener.getLogger().println("Last build was not on tied node, forcing rebuild.");
                return PollingResult.BUILD_NOW;
            }
            gitExe = this.getGitExe((Node)label.getNodes().iterator().next(), listener);
        } else {
            gitExe = this.getGitExe(project.getLastBuiltOn(), listener);
        }
        FilePath workingDirectory = this.workingDirectory(workspace);
        if (!workingDirectory.exists()) {
            return PollingResult.BUILD_NOW;
        }
        final EnvVars environment = GitUtils.getPollEnvironment(project, workspace, launcher, listener);
        boolean pollChangesResult = (Boolean)workingDirectory.act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(paramRepos = this.getParamExpandedRepos(lastBuild), singleBranch = this.getSingleBranch(lastBuild), buildData){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ List val$paramRepos;
            final /* synthetic */ String val$singleBranch;
            final /* synthetic */ BuildData val$buildData;
            {
                this.val$paramRepos = list;
                this.val$singleBranch = string2;
                this.val$buildData = buildData;
            }

            public Boolean invoke(File localWorkspace, VirtualChannel channel) throws IOException {
                GitAPI git = new GitAPI(gitExe, new FilePath(localWorkspace), listener, environment);
                if (git.hasGitRepo()) {
                    listener.getLogger().println("Fetching changes from the remote Git repositories");
                    for (RemoteConfig remoteRepository : this.val$paramRepos) {
                        GitSCM.this.fetchFrom(git, listener, remoteRepository);
                    }
                    listener.getLogger().println("Polling for changes in");
                    Collection<Revision> origCandidates = GitSCM.this.buildChooser.getCandidateRevisions(true, this.val$singleBranch, git, listener, this.val$buildData);
                    ArrayList<Revision> candidates = new ArrayList<Revision>();
                    for (Revision c : origCandidates) {
                        if (GitSCM.this.isRevExcluded(git, c, listener)) continue;
                        candidates.add(c);
                    }
                    return candidates.size() > 0;
                }
                listener.getLogger().println("No Git repository yet, an initial checkout is required");
                return true;
            }
        });
        return pollChangesResult ? PollingResult.SIGNIFICANT : PollingResult.NO_CHANGES;
    }

    private RemoteConfig newRemoteConfig(String name, String refUrl, RefSpec refSpec) {
        File temp = null;
        try {
            temp = File.createTempFile("tmp", "config");
            RepositoryConfig repoConfig = new RepositoryConfig(null, temp);
            repoConfig.setString("remote", name, "url", refUrl);
            repoConfig.setString("remote", name, "fetch", refSpec.toString());
            repoConfig.save();
            RemoteConfig remoteConfig = (RemoteConfig)RemoteConfig.getAllRemoteConfigs((RepositoryConfig)repoConfig).get(0);
            return remoteConfig;
        }
        catch (Exception ex) {
            throw new GitException("Error creating temp file");
        }
        finally {
            if (temp != null) {
                temp.delete();
            }
        }
    }

    private boolean changeLogResult(String changeLog, File changelogFile) throws IOException {
        if (changeLog == null) {
            return false;
        }
        changelogFile.delete();
        FileOutputStream fos = new FileOutputStream(changelogFile);
        fos.write(changeLog.getBytes());
        fos.close();
        return true;
    }

    private Pattern[] getExcludedRegionsPatterns() {
        String[] excluded = this.getExcludedRegionsNormalized();
        if (excluded != null) {
            Pattern[] patterns = new Pattern[excluded.length];
            int i = 0;
            for (String excludedRegion : excluded) {
                patterns[i++] = Pattern.compile(excludedRegion);
            }
            return patterns;
        }
        return new Pattern[0];
    }

    private String getRefSpec(RemoteConfig repo, AbstractBuild<?, ?> build) {
        String refSpec = ((RefSpec)repo.getFetchRefSpecs().get(0)).toString();
        ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
        if (parameters != null) {
            refSpec = parameters.substitute(build, refSpec);
        }
        return refSpec;
    }

    private String getSingleBranch(AbstractBuild<?, ?> build) {
        if (this.getBranches().size() != 1 || this.getRepositories().size() != 1) {
            return null;
        }
        String branch = this.getBranches().get(0).getName();
        String repository = this.getRepositories().get(0).getName();
        if (branch.startsWith("*/")) {
            branch = repository + branch.substring(1);
        }
        if (branch.contains("*")) {
            return null;
        }
        ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
        if (parameters != null) {
            branch = parameters.substitute(build, branch);
        }
        return branch;
    }

    private BuildData fixNull(BuildData bd) {
        return bd != null ? bd : new BuildData();
    }

    private boolean fetchFrom(IGitAPI git, TaskListener listener, RemoteConfig remoteRepository) {
        try {
            git.fetch(remoteRepository);
            return true;
        }
        catch (GitException ex) {
            listener.error("Problem fetching from " + remoteRepository.getName() + " / " + remoteRepository.getName() + " - could be unavailable. Continuing anyway");
            listener.error(" (Underlying report) : " + ex.getMessage());
            return false;
        }
    }

    private boolean fetchSubmodulesFrom(IGitAPI git, File workspace, TaskListener listener, RemoteConfig remoteRepository) {
        boolean fetched = true;
        try {
            git.setupSubmoduleUrls(remoteRepository.getName(), listener);
            boolean hasHead = true;
            try {
                git.revParse("HEAD");
            }
            catch (GitException e) {
                hasHead = false;
            }
            if (hasHead) {
                List<IndexEntry> submodules = git.getSubmodules("HEAD");
                for (IndexEntry submodule : submodules) {
                    try {
                        RemoteConfig submoduleRemoteRepository = this.getSubmoduleRepository(git, remoteRepository, submodule.getFile());
                        File subdir = new File(workspace, submodule.getFile());
                        listener.getLogger().println("Trying to fetch " + submodule.getFile() + " into " + subdir);
                        GitAPI subGit = new GitAPI(git.getGitExe(), new FilePath(subdir), listener, git.getEnvironment());
                        subGit.fetch(submoduleRemoteRepository);
                    }
                    catch (Exception ex) {
                        listener.getLogger().println("Problem fetching from submodule " + submodule.getFile() + " - could be unavailable. Continuing anyway");
                    }
                }
            }
        }
        catch (GitException ex) {
            ex.printStackTrace(listener.error("Problem fetching submodules from a path relative to " + remoteRepository.getName() + " / " + remoteRepository.getName() + " - could be unavailable. Continuing anyway"));
            fetched = false;
        }
        return fetched;
    }

    private void createInternalTag(IGitAPI git, String tagName, String tagComment) {
        if (!this.getSkipTag()) {
            git.tag(tagName, tagComment);
        }
    }

    private String computeChangeLog(IGitAPI git, Revision revToBuild, BuildListener listener, BuildData buildData) throws IOException {
        int histories = 0;
        StringBuilder changeLog = new StringBuilder();
        try {
            for (Branch b : revToBuild.getBranches()) {
                Build lastRevWas = this.buildChooser.prevBuildForChangelog(b.getName(), buildData, git);
                if (lastRevWas != null) {
                    if (git.isCommitInRepo(lastRevWas.getSHA1().name())) {
                        changeLog.append(this.putChangelogDiffsIntoFile(git, b.name, lastRevWas.getSHA1().name(), revToBuild.getSha1().name()));
                        ++histories;
                        continue;
                    }
                    listener.getLogger().println("Could not record history. Previous build's commit, " + lastRevWas.getSHA1().name() + ", does not exist in the current repository.");
                    continue;
                }
                listener.getLogger().println("No change to record in branch " + b.getName());
            }
        }
        catch (GitException ge) {
            changeLog.append("Unable to retrieve changeset");
        }
        if (histories > 1) {
            listener.getLogger().println("Warning : There are multiple branch changesets here");
        }
        return changeLog.toString();
    }

    private String putChangelogDiffsIntoFile(IGitAPI git, String branchName, String revFrom, String revTo) throws IOException {
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        String changeset = "Changes in branch " + branchName + ", between " + revFrom + " and " + revTo + "\n";
        fos.write(changeset.getBytes());
        git.changelog(revFrom, revTo, fos);
        fos.close();
        return fos.toString("UTF-8");
    }

    private boolean isRevExcluded(IGitAPI git, Revision r, TaskListener listener) {
        try {
            String author;
            List<String> revShow = git.showRevision(r);
            if (revShow.size() == 0) {
                return false;
            }
            GitChangeSet change = new GitChangeSet(revShow, this.authorOrCommitter);
            Pattern[] excludedPatterns = this.getExcludedRegionsPatterns();
            Set<String> excludedUsers = this.getExcludedUsersNormalized();
            if (excludedUsers.contains(author = change.getAuthorName())) {
                listener.getLogger().println("Ignored commit " + r.getSha1String() + ": Found excluded author: " + author);
                return true;
            }
            ArrayList<String> paths = new ArrayList<String>(change.getAffectedPaths());
            if (paths.isEmpty()) {
                return false;
            }
            ArrayList<String> excludedPaths = new ArrayList<String>();
            if (excludedPatterns.length > 0) {
                block2: for (String path : paths) {
                    for (Pattern pattern : excludedPatterns) {
                        if (!pattern.matcher(path).matches()) continue;
                        excludedPaths.add(path);
                        continue block2;
                    }
                }
            }
            if (paths.size() == excludedPaths.size()) {
                listener.getLogger().println("Ignored commit " + r.getSha1String() + ": Found only excluded paths: " + Util.join(excludedPaths, (String)", "));
                return true;
            }
        }
        catch (GitException e) {
            return false;
        }
        return false;
    }

    private class BuildConfig
    implements Serializable {
        private BuildData buildData;
        private String changeLog;

        public BuildConfig(String changeLog, BuildData buildData) {
            this.changeLog = changeLog;
            this.buildData = buildData;
        }

        public BuildData getBuildData() {
            return this.buildData;
        }

        public String getChangeLog() {
            return this.changeLog;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends SCMDescriptor<GitSCM> {
        private String gitExe;
        private String globalConfigName;
        private String globalConfigEmail;

        public DescriptorImpl() {
            super(GitSCM.class, GitRepositoryBrowser.class);
            this.load();
        }

        public String getDisplayName() {
            return "Git";
        }

        public List<BuildChooserDescriptor> getBuildChooserDescriptors() {
            return BuildChooser.all();
        }

        public List<GitTool> getGitTools() {
            GitTool[] gitToolInstallations = (GitTool[])((GitTool.DescriptorImpl)Hudson.getInstance().getDescriptorByType(GitTool.DescriptorImpl.class)).getInstallations();
            return Arrays.asList(gitToolInstallations);
        }

        @Deprecated
        public String getGitExe() {
            return this.gitExe;
        }

        public String getGlobalConfigName() {
            return this.globalConfigName;
        }

        public String getGlobalConfigEmail() {
            return this.globalConfigEmail;
        }

        public String getOldGitExe() {
            return this.gitExe;
        }

        private GitRepositoryBrowser getBrowserFromRequest(StaplerRequest req, JSONObject scmData) {
            if (scmData.containsKey((Object)"browser")) {
                return (GitRepositoryBrowser)((Object)req.bindJSON(GitRepositoryBrowser.class, scmData.getJSONObject("browser")));
            }
            return null;
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            List<RemoteConfig> remoteRepositories;
            try {
                remoteRepositories = DescriptorImpl.createRepositoryConfigurations(req.getParameterValues("git.repo.url"), req.getParameterValues("git.repo.name"), req.getParameterValues("git.repo.refspec"));
            }
            catch (IOException e1) {
                throw new GitException("Error creating repositories", e1);
            }
            List<BranchSpec> branches = DescriptorImpl.createBranches(req.getParameterValues("git.branch"));
            PreBuildMergeOptions mergeOptions = DescriptorImpl.createMergeOptions(req.getParameter("git.doMerge"), req.getParameter("git.mergeRemote"), req.getParameter("git.mergeTarget"), remoteRepositories);
            String[] urls = req.getParameterValues("git.repo.url");
            String[] names = req.getParameterValues("git.repo.name");
            ArrayList<SubmoduleConfig> submoduleCfg = new ArrayList<SubmoduleConfig>();
            GitRepositoryBrowser gitBrowser = this.getBrowserFromRequest(req, formData);
            String gitTool = req.getParameter("git.gitTool");
            return new GitSCM(remoteRepositories, branches, mergeOptions, req.getParameter("git.generate") != null, submoduleCfg, req.getParameter("git.clean") != null, req.getParameter("git.wipeOutWorkspace") != null, (BuildChooser)req.bindJSON(BuildChooser.class, formData.getJSONObject("buildChooser")), gitBrowser, gitTool, req.getParameter("git.authorOrCommitter") != null, req.getParameter("git.relativeTargetDir"), req.getParameter("git.excludedRegions"), req.getParameter("git.excludedUsers"), req.getParameter("git.localBranch"), req.getParameter("git.recursiveSubmodules") != null, req.getParameter("git.pruneBranches") != null, req.getParameter("git.gitConfigName"), req.getParameter("git.gitConfigEmail"), req.getParameter("git.skipTag") != null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static List<RemoteConfig> createRepositoryConfigurations(String[] pUrls, String[] repoNames, String[] refSpecs) throws IOException {
            File temp = File.createTempFile("tmp", "config");
            try {
                List<RemoteConfig> list = DescriptorImpl.createRepositoryConfigurations(pUrls, repoNames, refSpecs, temp);
                return list;
            }
            finally {
                temp.delete();
            }
        }

        public static List<RemoteConfig> createRepositoryConfigurations(String[] pUrls, String[] repoNames, String[] refSpecs, File temp) {
            List remoteRepositories;
            RepositoryConfig repoConfig = new RepositoryConfig(null, temp);
            String[] urls = pUrls;
            String[] names = repoNames;
            names = GitUtils.fixupNames(names, urls);
            String[] refs = refSpecs;
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    String name = names[i];
                    name = name.replace(' ', '_');
                    if (refs[i] == null || refs[i].length() == 0) {
                        refs[i] = "+refs/heads/*:refs/remotes/" + name + "/*";
                    }
                    repoConfig.setString("remote", name, "url", urls[i]);
                    repoConfig.setString("remote", name, "fetch", refs[i]);
                }
            }
            try {
                repoConfig.save();
                remoteRepositories = RemoteConfig.getAllRemoteConfigs((RepositoryConfig)repoConfig);
            }
            catch (Exception e) {
                throw new GitException("Error creating repositories", e);
            }
            return remoteRepositories;
        }

        public static List<BranchSpec> createBranches(String[] branch) {
            ArrayList<BranchSpec> branches = new ArrayList<BranchSpec>();
            String[] branchData = branch;
            for (int i = 0; i < branchData.length; ++i) {
                branches.add(new BranchSpec(branchData[i]));
            }
            if (branches.size() == 0) {
                branches.add(new BranchSpec("*/master"));
            }
            return branches;
        }

        public static PreBuildMergeOptions createMergeOptions(String doMerge, String pMergeRemote, String mergeTarget, List<RemoteConfig> remoteRepositories) throws Descriptor.FormException {
            PreBuildMergeOptions mergeOptions = new PreBuildMergeOptions();
            if (doMerge != null && doMerge.trim().length() > 0) {
                RemoteConfig mergeRemote = null;
                String mergeRemoteName = pMergeRemote.trim();
                if (mergeRemoteName.length() == 0) {
                    mergeRemote = remoteRepositories.get(0);
                } else {
                    for (RemoteConfig remote : remoteRepositories) {
                        if (!remote.getName().equals(mergeRemoteName)) continue;
                        mergeRemote = remote;
                        break;
                    }
                }
                if (mergeRemote == null) {
                    throw new Descriptor.FormException("No remote repository configured with name '" + mergeRemoteName + "'", "git.mergeRemote");
                }
                mergeOptions.setMergeRemote(mergeRemote);
                mergeOptions.setMergeTarget(mergeTarget);
            }
            return mergeOptions;
        }

        public static GitWeb createGitWeb(String url) {
            GitWeb gitWeb = null;
            String gitWebUrl = url;
            if (gitWebUrl != null && gitWebUrl.length() > 0) {
                try {
                    gitWeb = new GitWeb(gitWebUrl);
                }
                catch (MalformedURLException e) {
                    throw new GitException("Error creating GitWeb", e);
                }
            }
            return gitWeb;
        }

        public FormValidation doGitRemoteNameCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            boolean isMerge;
            String mergeRemoteName = req.getParameter("value");
            boolean bl = isMerge = req.getParameter("isMerge") != null;
            if (mergeRemoteName.length() == 0 && isMerge) {
                return FormValidation.ok();
            }
            String[] urls = req.getParameterValues("git.repo.url");
            String[] names = req.getParameterValues("git.repo.name");
            for (String name : names = GitUtils.fixupNames(names, urls)) {
                if (!name.equals(mergeRemoteName)) continue;
                return FormValidation.ok();
            }
            return FormValidation.error((String)("No remote repository configured with name '" + mergeRemoteName + "'"));
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindJSON((Object)this, formData);
            this.save();
            return true;
        }
    }
}

