/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats;

import hudson.Plugin;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.TopLevelItem;
import hudson.plugins.global_build_stats.JobBuildResultFactory;
import hudson.plugins.global_build_stats.JobFilter;
import hudson.plugins.global_build_stats.model.BuildStatConfiguration;
import hudson.plugins.global_build_stats.model.DateRange;
import hudson.plugins.global_build_stats.model.HistoricScale;
import hudson.plugins.global_build_stats.model.JobBuildResult;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalBuildStatsPlugin
extends Plugin {
    private List<JobBuildResult> jobBuildResults = new ArrayList();
    private List<BuildStatConfiguration> buildStatConfigs = new ArrayList();

    public void postInitialize() throws Exception {
        super.postInitialize();
        this.load();
    }

    public void doRecordBuildInfos(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        this.jobBuildResults.clear();
        for (TopLevelItem item : Hudson.getInstance().getItems()) {
            if (!(item instanceof AbstractProject)) continue;
            this.addBuildsFrom((AbstractProject)item);
        }
        this.save();
        res.forwardToPreviousPage(req);
    }

    public void doCreateChart(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        BuildStatConfiguration config = this.createBuildStatConfig(req);
        List filteredJobBuildResults = this.createFilteredAndSortedBuildResults(config);
        DataSetBuilder dsb = this.createDataSetBuilder(filteredJobBuildResults, config);
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)res, (JFreeChart)this.createChart(req, dsb.build(), config.getBuildStatTitle()), (int)500, (int)250);
    }

    private BuildStatConfiguration createBuildStatConfig(StaplerRequest req) {
        return new BuildStatConfiguration(req.getParameter("title"), Integer.parseInt(req.getParameter("historicLength")), HistoricScale.valueOf((String)req.getParameter("historicScale")), JobFilter.ALL, Boolean.parseBoolean(req.getParameter("successShown")), Boolean.parseBoolean(req.getParameter("failuresShown")), Boolean.parseBoolean(req.getParameter("unstablesShown")), Boolean.parseBoolean(req.getParameter("abortedShown")), Boolean.parseBoolean(req.getParameter("notBuildsShown")));
    }

    private JFreeChart createChart(StaplerRequest req, CategoryDataset dataset, String title) {
        JFreeChart chart = ChartFactory.createLineChart((String)title, null, (String)"Count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setLowerBound(0.0);
        rangeAxis.setUpperBound(rangeAxis.getUpperBound() + 1.0);
        StackedAreaRenderer2 renderer = new StackedAreaRenderer2();
        renderer.setSeriesPaint(0, (Paint)Color.yellow);
        renderer.setSeriesPaint(1, (Paint)Color.red);
        renderer.setSeriesPaint(2, (Paint)Color.gray);
        renderer.setSeriesPaint(3, (Paint)Color.blue);
        renderer.setSeriesPaint(4, (Paint)Color.pink);
        plot.setRenderer((CategoryItemRenderer)renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }

    private DataSetBuilder<String, DateRange> createDataSetBuilder(List<JobBuildResult> filteredJobBuildResults, BuildStatConfiguration config) {
        DataSetBuilder dsb = new DataSetBuilder();
        if (filteredJobBuildResults.size() == 0) {
            return dsb;
        }
        Calendar d2 = new GregorianCalendar();
        Calendar d1 = config.getHistoricScale().getPreviousStep(d2);
        int nbSuccess = 0;
        int nbFailures = 0;
        int nbUnstables = 0;
        int nbAborted = 0;
        int nbNotBuild = 0;
        int nbSteps = 0;
        Iterator<JobBuildResult> buildsIter = filteredJobBuildResults.iterator();
        JobBuildResult currentBuild = buildsIter.next();
        Calendar buildDate = currentBuild.getBuildDate();
        while (nbSteps != config.getHistoricLength()) {
            while (nbSteps < config.getHistoricLength() && d1.after(buildDate)) {
                DateRange range = new DateRange(d1, d2);
                dsb.add((Number)nbSuccess, (Comparable)((Object)"success"), (Comparable)range);
                dsb.add((Number)nbFailures, (Comparable)((Object)"failures"), (Comparable)range);
                dsb.add((Number)nbUnstables, (Comparable)((Object)"unstables"), (Comparable)range);
                dsb.add((Number)nbAborted, (Comparable)((Object)"aborted"), (Comparable)range);
                dsb.add((Number)nbNotBuild, (Comparable)((Object)"not build"), (Comparable)range);
                d2 = (Calendar)d1.clone();
                d1 = config.getHistoricScale().getPreviousStep(d2);
                nbSuccess = 0;
                nbFailures = 0;
                nbUnstables = 0;
                nbAborted = 0;
                nbNotBuild = 0;
                ++nbSteps;
            }
            if (nbSteps == config.getHistoricLength() || currentBuild == null) continue;
            nbSuccess += config.isSuccessShown() ? currentBuild.getResult().getSuccessCount() : 0;
            nbFailures += config.isFailuresShown() ? currentBuild.getResult().getFailureCount() : 0;
            nbUnstables += config.isUnstablesShown() ? currentBuild.getResult().getUnstableCount() : 0;
            nbAborted += config.isAbortedShown() ? currentBuild.getResult().getAbortedCount() : 0;
            nbNotBuild += config.isNotBuildShown() ? currentBuild.getResult().getNotBuildCount() : 0;
            if (buildsIter.hasNext()) {
                currentBuild = buildsIter.next();
                buildDate = currentBuild.getBuildDate();
                continue;
            }
            currentBuild = null;
            buildDate = new GregorianCalendar();
            buildDate.setTimeInMillis(1L);
        }
        return dsb;
    }

    private List<JobBuildResult> createFilteredAndSortedBuildResults(BuildStatConfiguration config) {
        ArrayList<JobBuildResult> filteredJobBuildResults = new ArrayList<JobBuildResult>();
        for (JobBuildResult r : this.jobBuildResults) {
            if (!config.getTargetJobs().isJobApplicable(r.getJobName())) continue;
            filteredJobBuildResults.add(r);
        }
        Collections.sort(filteredJobBuildResults, Collections.reverseOrder(new /* Unavailable Anonymous Inner Class!! */));
        return filteredJobBuildResults;
    }

    private void addBuildsFrom(AbstractProject project) {
        List builds = project.getBuilds();
        Iterator buildIterator = builds.iterator();
        while (buildIterator.hasNext()) {
            this.addBuild((AbstractBuild)buildIterator.next());
        }
    }

    private void addBuild(AbstractBuild build) {
        this.jobBuildResults.add(JobBuildResultFactory.INSTANCE.createJobBuildResult(build));
    }

    static /* synthetic */ void access$000(GlobalBuildStatsPlugin x0, AbstractBuild x1) {
        x0.addBuild(x1);
    }
}

