/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.global_build_stats.model.BuildResult;
import hudson.plugins.global_build_stats.model.JobBuildResult;

public class JobBuildResultFactory {
    public static final JobBuildResultFactory INSTANCE = new JobBuildResultFactory();

    private JobBuildResultFactory() {
    }

    public JobBuildResult createJobBuildResult(AbstractBuild build) {
        String buildName = build.getProject().getName();
        return new JobBuildResult(this.createBuildResult(build.getResult()), buildName, build.getNumber(), build.getTimestamp());
    }

    public BuildResult createBuildResult(Result result) {
        if (Result.ABORTED.equals(result)) {
            return BuildResult.ABORTED;
        }
        if (Result.FAILURE.equals(result)) {
            return BuildResult.FAILURE;
        }
        if (Result.NOT_BUILT.equals(result)) {
            return BuildResult.NOT_BUILD;
        }
        if (Result.SUCCESS.equals(result)) {
            return BuildResult.SUCCESS;
        }
        return BuildResult.UNSTABLE;
    }
}

