/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.model;

import hudson.plugins.global_build_stats.JobFilter;
import hudson.plugins.global_build_stats.model.BuildResult;
import hudson.plugins.global_build_stats.model.HistoricScale;
import java.io.Serializable;

public class BuildStatConfiguration
implements Serializable {
    private String buildStatTitle;
    private int historicLength;
    private HistoricScale historicScale;
    private JobFilter targetJobs;
    private short shownBuildResults;

    public BuildStatConfiguration(String _buildStatTitle, int _historicLength, HistoricScale _historicScale, JobFilter _targetJobs, boolean successShown, boolean failuresShown, boolean unstablesShown, boolean abortedShown, boolean notBuildsShown) {
        this.buildStatTitle = _buildStatTitle;
        this.historicLength = _historicLength;
        this.historicScale = _historicScale;
        this.targetJobs = _targetJobs;
        this.shownBuildResults = 0;
        this.shownBuildResults = (short)(this.shownBuildResults | (successShown ? BuildResult.SUCCESS.code : (short)0));
        this.shownBuildResults = (short)(this.shownBuildResults | (failuresShown ? BuildResult.FAILURE.code : (short)0));
        this.shownBuildResults = (short)(this.shownBuildResults | (unstablesShown ? BuildResult.UNSTABLE.code : (short)0));
        this.shownBuildResults = (short)(this.shownBuildResults | (abortedShown ? BuildResult.ABORTED.code : (short)0));
        this.shownBuildResults = (short)(this.shownBuildResults | (notBuildsShown ? BuildResult.NOT_BUILD.code : (short)0));
    }

    public boolean isSuccessShown() {
        return (this.shownBuildResults & BuildResult.SUCCESS.code) != 0;
    }

    public boolean isFailuresShown() {
        return (this.shownBuildResults & BuildResult.FAILURE.code) != 0;
    }

    public boolean isUnstablesShown() {
        return (this.shownBuildResults & BuildResult.UNSTABLE.code) != 0;
    }

    public boolean isAbortedShown() {
        return (this.shownBuildResults & BuildResult.ABORTED.code) != 0;
    }

    public boolean isNotBuildShown() {
        return (this.shownBuildResults & BuildResult.NOT_BUILD.code) != 0;
    }

    public String getBuildStatTitle() {
        return this.buildStatTitle;
    }

    public int getHistoricLength() {
        return this.historicLength;
    }

    public HistoricScale getHistoricScale() {
        return this.historicScale;
    }

    public short getShownBuildResults() {
        return this.shownBuildResults;
    }

    public JobFilter getTargetJobs() {
        return this.targetJobs;
    }
}

