/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats;

import hudson.Plugin;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.ManagementLink;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.listeners.RunListener;
import hudson.plugins.global_build_stats.JobBuildResultFactory;
import hudson.plugins.global_build_stats.JobFilterFactory;
import hudson.plugins.global_build_stats.model.BuildStatConfiguration;
import hudson.plugins.global_build_stats.model.DateRange;
import hudson.plugins.global_build_stats.model.HistoricScale;
import hudson.plugins.global_build_stats.model.JobBuildResult;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.FormValidation;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalBuildStatsPlugin
extends Plugin {
    private List<JobBuildResult> jobBuildResults = new ArrayList<JobBuildResult>();
    private List<BuildStatConfiguration> buildStatConfigs = new ArrayList<BuildStatConfiguration>();

    public void postInitialize() throws Exception {
        super.postInitialize();
        this.load();
    }

    public void doRecordBuildInfos(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        this.jobBuildResults.clear();
        for (TopLevelItem item : Hudson.getInstance().getItems()) {
            if (!(item instanceof AbstractProject)) continue;
            this.addBuildsFrom((AbstractProject)item);
        }
        this.save();
        res.forwardToPreviousPage(req);
    }

    public void doCreateChart(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        BuildStatConfiguration config = this.createBuildStatConfig(req);
        List<JobBuildResult> filteredJobBuildResults = this.createFilteredAndSortedBuildResults(config);
        DataSetBuilder<String, DateRange> dsb = this.createDataSetBuilder(filteredJobBuildResults, config);
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)res, (JFreeChart)this.createChart(req, dsb.build(), config.getBuildStatTitle()), (int)config.getBuildStatWidth(), (int)config.getBuildStatHeight());
    }

    protected static void mustBeInt(List<FormValidation> errors, String param, String errorMessage) {
        try {
            Integer.parseInt(param);
        }
        catch (NumberFormatException e) {
            errors.add(FormValidation.error((String)errorMessage));
        }
    }

    protected static void isMandatory(List<FormValidation> errors, String param, String errorMessage) {
        if (param == null || "".equals(param)) {
            errors.add(FormValidation.error((String)errorMessage));
        }
    }

    protected static void mustBeBool(List<FormValidation> errors, String param, String errorMessage) {
        try {
            Boolean.valueOf(param);
        }
        catch (Throwable t) {
            errors.add(FormValidation.error((String)errorMessage));
        }
    }

    protected boolean validateBuildStats(StaplerRequest req, StaplerResponse res) throws IOException, ServletException {
        ArrayList<FormValidation> errors = new ArrayList<FormValidation>();
        GlobalBuildStatsPlugin.isMandatory(errors, req.getParameter("title"), "Title is mandatory");
        GlobalBuildStatsPlugin.isMandatory(errors, req.getParameter("buildStatWidth"), "Build stats width is mandatory");
        GlobalBuildStatsPlugin.mustBeInt(errors, req.getParameter("buildStatWidth"), "Build stats width should be an integer");
        GlobalBuildStatsPlugin.isMandatory(errors, req.getParameter("buildStatHeight"), "Build stats height is mandatory");
        GlobalBuildStatsPlugin.mustBeInt(errors, req.getParameter("buildStatHeight"), "Build stats height should be an integer");
        GlobalBuildStatsPlugin.isMandatory(errors, req.getParameter("historicLength"), "Build stats length is mandatory");
        GlobalBuildStatsPlugin.mustBeInt(errors, req.getParameter("historicLength"), "Build stats length should be an integer");
        GlobalBuildStatsPlugin.isMandatory(errors, req.getParameter("buildStatWidth"), "Build stats width is mandatory");
        GlobalBuildStatsPlugin.mustBeInt(errors, req.getParameter("buildStatWidth"), "Build stats width should be an integer");
        GlobalBuildStatsPlugin.mustBeBool(errors, req.getParameter("successShown"), "SuccessShown must be a boolean");
        GlobalBuildStatsPlugin.mustBeBool(errors, req.getParameter("failuresShown"), "FailuresShown must be a boolean");
        GlobalBuildStatsPlugin.mustBeBool(errors, req.getParameter("unstablesShown"), "UnstablesShown must be a boolean");
        GlobalBuildStatsPlugin.mustBeBool(errors, req.getParameter("abortedShown"), "AbortedShown must be a boolean");
        GlobalBuildStatsPlugin.mustBeBool(errors, req.getParameter("notBuildsShown"), "NotBuildsShown must be a boolean");
        try {
            HistoricScale.valueOf(req.getParameter("historicScale"));
        }
        catch (Throwable t) {
            errors.add(FormValidation.error((String)"HistoricScale is invalid"));
        }
        try {
            JobFilterFactory.createJobFilter(req.getParameter("jobFilter"));
        }
        catch (Throwable t) {
            errors.add(FormValidation.error((String)"JobFilter is invalid"));
        }
        if (errors.size() == 0) {
            return true;
        }
        req.setAttribute("errors", errors);
        res.forwardToPreviousPage(req);
        return false;
    }

    public void doUpdateBuildStatConfiguration(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        if (this.validateBuildStats(req, res)) {
            this.buildStatConfigs.set(Integer.parseInt(req.getParameter("buildStatId")), this.createBuildStatConfig(req));
            this.save();
            res.forwardToPreviousPage(req);
        }
    }

    public void doAddBuildStatConfiguration(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        if (this.validateBuildStats(req, res)) {
            this.buildStatConfigs.add(this.createBuildStatConfig(req));
            this.save();
            res.forwardToPreviousPage(req);
        }
    }

    public void doDeleteConfiguration(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        this.buildStatConfigs.remove(Integer.parseInt(req.getParameter("buildStatId")));
        this.save();
        res.forwardToPreviousPage(req);
    }

    public void doMoveUpConf(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        int index = Integer.parseInt(req.getParameter("buildStatId"));
        BuildStatConfiguration b = this.buildStatConfigs.get(index);
        this.buildStatConfigs.set(index, this.buildStatConfigs.get(index - 1));
        this.buildStatConfigs.set(index - 1, b);
        this.save();
        res.forwardToPreviousPage(req);
    }

    public void doMoveDownConf(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        int index = Integer.parseInt(req.getParameter("buildStatId"));
        BuildStatConfiguration b = this.buildStatConfigs.get(index);
        this.buildStatConfigs.set(index, this.buildStatConfigs.get(index + 1));
        this.buildStatConfigs.set(index + 1, b);
        this.save();
        res.forwardToPreviousPage(req);
    }

    private BuildStatConfiguration createBuildStatConfig(StaplerRequest req) {
        return new BuildStatConfiguration(req.getParameter("title"), Integer.parseInt(req.getParameter("buildStatWidth")), Integer.parseInt(req.getParameter("buildStatHeight")), Integer.parseInt(req.getParameter("historicLength")), HistoricScale.valueOf(req.getParameter("historicScale")), req.getParameter("jobFilter"), Boolean.parseBoolean(req.getParameter("successShown")), Boolean.parseBoolean(req.getParameter("failuresShown")), Boolean.parseBoolean(req.getParameter("unstablesShown")), Boolean.parseBoolean(req.getParameter("abortedShown")), Boolean.parseBoolean(req.getParameter("notBuildsShown")));
    }

    private JFreeChart createChart(StaplerRequest req, CategoryDataset dataset, String title) {
        JFreeChart chart = ChartFactory.createLineChart((String)title, null, (String)"Count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        domainAxis.setMaximumCategoryLabelLines(2);
        domainAxis.setMaximumCategoryLabelWidthRatio(2.0f);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setLowerBound(0.0);
        rangeAxis.setUpperBound(rangeAxis.getUpperBound() + 1.0);
        StackedAreaRenderer2 renderer = new StackedAreaRenderer2();
        renderer.setSeriesPaint(0, (Paint)Color.yellow);
        renderer.setSeriesPaint(1, (Paint)Color.red);
        renderer.setSeriesPaint(2, (Paint)Color.gray);
        renderer.setSeriesPaint(3, (Paint)Color.blue);
        renderer.setSeriesPaint(4, (Paint)Color.pink);
        plot.setRenderer((CategoryItemRenderer)renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }

    private DataSetBuilder<String, DateRange> createDataSetBuilder(List<JobBuildResult> filteredJobBuildResults, BuildStatConfiguration config) {
        DataSetBuilder dsb = new DataSetBuilder();
        if (filteredJobBuildResults.size() == 0) {
            return dsb;
        }
        Calendar d2 = new GregorianCalendar();
        Calendar d1 = config.getHistoricScale().getPreviousStep(d2);
        int nbSuccess = 0;
        int nbFailures = 0;
        int nbUnstables = 0;
        int nbAborted = 0;
        int nbNotBuild = 0;
        int nbSteps = 0;
        Iterator<JobBuildResult> buildsIter = filteredJobBuildResults.iterator();
        JobBuildResult currentBuild = buildsIter.next();
        Calendar buildDate = currentBuild.getBuildDate();
        while (nbSteps != config.getHistoricLength()) {
            while (nbSteps < config.getHistoricLength() && d1.after(buildDate)) {
                DateRange range = new DateRange(d1, d2);
                dsb.add((Number)nbSuccess, (Comparable)((Object)"success"), (Comparable)range);
                dsb.add((Number)nbFailures, (Comparable)((Object)"failures"), (Comparable)range);
                dsb.add((Number)nbUnstables, (Comparable)((Object)"unstables"), (Comparable)range);
                dsb.add((Number)nbAborted, (Comparable)((Object)"aborted"), (Comparable)range);
                dsb.add((Number)nbNotBuild, (Comparable)((Object)"not build"), (Comparable)range);
                d2 = (Calendar)d1.clone();
                d1 = config.getHistoricScale().getPreviousStep(d2);
                nbSuccess = 0;
                nbFailures = 0;
                nbUnstables = 0;
                nbAborted = 0;
                nbNotBuild = 0;
                ++nbSteps;
            }
            if (nbSteps == config.getHistoricLength() || currentBuild == null) continue;
            nbSuccess += config.isSuccessShown() ? currentBuild.getResult().getSuccessCount() : 0;
            nbFailures += config.isFailuresShown() ? currentBuild.getResult().getFailureCount() : 0;
            nbUnstables += config.isUnstablesShown() ? currentBuild.getResult().getUnstableCount() : 0;
            nbAborted += config.isAbortedShown() ? currentBuild.getResult().getAbortedCount() : 0;
            nbNotBuild += config.isNotBuildShown() ? currentBuild.getResult().getNotBuildCount() : 0;
            if (buildsIter.hasNext()) {
                currentBuild = buildsIter.next();
                buildDate = currentBuild.getBuildDate();
                continue;
            }
            currentBuild = null;
            buildDate = new GregorianCalendar();
            buildDate.setTimeInMillis(1L);
        }
        return dsb;
    }

    private List<JobBuildResult> createFilteredAndSortedBuildResults(BuildStatConfiguration config) {
        ArrayList<JobBuildResult> filteredJobBuildResults = new ArrayList<JobBuildResult>();
        for (JobBuildResult r : this.jobBuildResults) {
            if (!JobFilterFactory.createJobFilter(config.getJobFilter()).isJobApplicable(r.getJobName())) continue;
            filteredJobBuildResults.add(r);
        }
        Collections.sort(filteredJobBuildResults, Collections.reverseOrder(new Comparator<JobBuildResult>(){

            @Override
            public int compare(JobBuildResult o1, JobBuildResult o2) {
                return o1.getBuildDate().compareTo(o2.getBuildDate());
            }
        }));
        return filteredJobBuildResults;
    }

    private void addBuildsFrom(AbstractProject project) {
        List builds = project.getBuilds();
        Iterator buildIterator = builds.iterator();
        while (buildIterator.hasNext()) {
            this.addBuild((AbstractBuild)buildIterator.next());
        }
    }

    private void addBuild(AbstractBuild build) {
        this.jobBuildResults.add(JobBuildResultFactory.INSTANCE.createJobBuildResult(build));
    }

    public BuildStatConfiguration[] getBuildStatConfigs() {
        return this.buildStatConfigs.toArray(new BuildStatConfiguration[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GlobalBuildStatsRunListener
    extends RunListener<AbstractBuild> {
        public GlobalBuildStatsRunListener() {
            super(AbstractBuild.class);
        }

        public void onCompleted(AbstractBuild r, TaskListener listener) {
            super.onCompleted((Run)r, listener);
            GlobalBuildStatsPlugin plugin = (GlobalBuildStatsPlugin)Hudson.getInstance().getPlugin(GlobalBuildStatsPlugin.class);
            plugin.addBuild(r);
            try {
                plugin.save();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public static class GlobalBuildStatsManagementLink
    extends ManagementLink {
        public String getIconFileName() {
            return "/plugin/global-build-stats/icons/global-build-stats.png";
        }

        public String getDisplayName() {
            return "Global Builds Stats";
        }

        public String getUrlName() {
            return "plugin/global-build-stats/";
        }

        public String getDescription() {
            return "Displays stats about daily build failures";
        }
    }
}

