/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.model;

import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HistoricScale {
    YEARLY(1),
    MONTHLY(2),
    WEEKLY(3),
    DAILY(6, new Integer[]{10, 12}),
    HOURLY(10, new Integer[]{12});

    private int calendarField;
    private Integer[] fieldsToReset;

    private HistoricScale(int _calendarField) {
        this(_calendarField, new Integer[0]);
    }

    private HistoricScale(int _calendarField, Integer[] _fieldsToReset) {
        this.calendarField = _calendarField;
        this.fieldsToReset = _fieldsToReset;
    }

    public Calendar getPreviousStep(Calendar currentStep) {
        int i;
        Calendar previousStep = (Calendar)currentStep.clone();
        boolean fieldToResetAlreadyReseted = true;
        for (i = 0; fieldToResetAlreadyReseted && i < this.fieldsToReset.length; ++i) {
            fieldToResetAlreadyReseted = currentStep.get(this.fieldsToReset[i]) == 0;
        }
        if (fieldToResetAlreadyReseted) {
            previousStep.add(this.calendarField, -1);
        } else {
            for (i = 0; i < this.fieldsToReset.length; ++i) {
                previousStep.set(this.fieldsToReset[i], 0);
            }
        }
        return previousStep;
    }
}

