/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats;

import hudson.Plugin;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.TopLevelItem;
import hudson.plugins.global_build_stats.JobBuildResultFactory;
import hudson.plugins.global_build_stats.JobFilterFactory;
import hudson.plugins.global_build_stats.model.BuildStatConfiguration;
import hudson.plugins.global_build_stats.model.DateRange;
import hudson.plugins.global_build_stats.model.HistoricScale;
import hudson.plugins.global_build_stats.model.JobBuildResult;
import hudson.security.Permission;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.FormValidation;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class GlobalBuildStatsPlugin
extends Plugin {
    private List<JobBuildResult> jobBuildResults = new ArrayList();
    private List<BuildStatConfiguration> buildStatConfigs = new ArrayList();

    public void postInitialize() throws Exception {
        super.postInitialize();
        this.load();
    }

    public FormValidation doCheckJobFilter(@QueryParameter String value) {
        try {
            JobFilterFactory.createJobFilter((String)value);
            return FormValidation.ok();
        }
        catch (Throwable t) {
            return FormValidation.error((String)"JobFilter is invalid");
        }
    }

    public FormValidation doCheckFailuresShown(@QueryParameter String value) {
        if (!GlobalBuildStatsPlugin.isBool((String)value)) {
            return FormValidation.error((String)"FailuresShown must be a boolean");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckUnstablesShown(@QueryParameter String value) {
        if (!GlobalBuildStatsPlugin.isBool((String)value)) {
            return FormValidation.error((String)"UnstablesShown must be a boolean");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckAbortedShown(@QueryParameter String value) {
        if (!GlobalBuildStatsPlugin.isBool((String)value)) {
            return FormValidation.error((String)"AbortedShown must be a boolean");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckNotBuildsShown(@QueryParameter String value) {
        if (!GlobalBuildStatsPlugin.isBool((String)value)) {
            return FormValidation.error((String)"NotBuildsShown must be a boolean");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckSuccessShown(@QueryParameter String value) {
        if (!GlobalBuildStatsPlugin.isBool((String)value)) {
            return FormValidation.error((String)"SuccessShown must be a boolean");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckHistoricScale(@QueryParameter String value) {
        if (!GlobalBuildStatsPlugin.isMandatory((String)value)) {
            return FormValidation.error((String)"Historic scale is mandatory");
        }
        try {
            HistoricScale.valueOf((String)value);
            return FormValidation.ok();
        }
        catch (Throwable t) {
            return FormValidation.error((String)"HistoricScale is invalid");
        }
    }

    public FormValidation doCheckHistoricLength(@QueryParameter String value) {
        if (!GlobalBuildStatsPlugin.isMandatory((String)value)) {
            return FormValidation.error((String)"Historic length is mandatory");
        }
        if (!GlobalBuildStatsPlugin.isInt((String)value)) {
            return FormValidation.error((String)"Historic length should be an integer");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckBuildStatHeight(@QueryParameter String value) {
        if (!GlobalBuildStatsPlugin.isMandatory((String)value)) {
            return FormValidation.error((String)"Build stats height is mandatory");
        }
        if (!GlobalBuildStatsPlugin.isInt((String)value)) {
            return FormValidation.error((String)"Build stats height should be an integer");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckBuildStatWidth(@QueryParameter String value) {
        if (!GlobalBuildStatsPlugin.isMandatory((String)value)) {
            return FormValidation.error((String)"Build stats width is mandatory");
        }
        if (!GlobalBuildStatsPlugin.isInt((String)value)) {
            return FormValidation.error((String)"Build stats width should be an integer");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckTitle(@QueryParameter String value) {
        if (!GlobalBuildStatsPlugin.isMandatory((String)value)) {
            return FormValidation.error((String)"Title is mandatory");
        }
        return FormValidation.ok();
    }

    public HttpResponse doRecordBuildInfos() throws IOException {
        Hudson.getInstance().checkPermission(this.getRequiredPermission());
        ArrayList jobBuildResultsRead = new ArrayList();
        for (TopLevelItem item : Hudson.getInstance().getItems()) {
            if (!(item instanceof AbstractProject)) continue;
            GlobalBuildStatsPlugin.addBuildsFrom(jobBuildResultsRead, (AbstractProject)((AbstractProject)item));
        }
        this.jobBuildResults = GlobalBuildStatsPlugin.mergeJobBuildResults((List)this.jobBuildResults, jobBuildResultsRead);
        this.save();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void doCreateChart(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(this.getRequiredPermission());
        BuildStatConfiguration config = this.createBuildStatConfig(req);
        List filteredJobBuildResults = this.createFilteredAndSortedBuildResults(config);
        DataSetBuilder dsb = this.createDataSetBuilder(filteredJobBuildResults, config);
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)res, (JFreeChart)this.createChart(req, dsb.build(), config.getBuildStatTitle()), (int)config.getBuildStatWidth(), (int)config.getBuildStatHeight());
    }

    protected static boolean isInt(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected static boolean isMandatory(String value) {
        return value != null && !"".equals(value);
    }

    protected static boolean isBool(String value) {
        try {
            Boolean.valueOf(value);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void doUpdateBuildStatConfiguration(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(this.getRequiredPermission());
        this.buildStatConfigs.set(Integer.parseInt(req.getParameter("buildStatId")), this.createBuildStatConfig(req));
        this.save();
        res.forwardToPreviousPage(req);
    }

    public void doAddBuildStatConfiguration(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(this.getRequiredPermission());
        this.buildStatConfigs.add(this.createBuildStatConfig(req));
        this.save();
        res.forwardToPreviousPage(req);
    }

    public void doDeleteConfiguration(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(this.getRequiredPermission());
        this.buildStatConfigs.remove(Integer.parseInt(req.getParameter("buildStatId")));
        this.save();
        res.forwardToPreviousPage(req);
    }

    public void doMoveUpConf(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(this.getRequiredPermission());
        int index = Integer.parseInt(req.getParameter("buildStatId"));
        BuildStatConfiguration b = (BuildStatConfiguration)this.buildStatConfigs.get(index);
        this.buildStatConfigs.set(index, this.buildStatConfigs.get(index - 1));
        this.buildStatConfigs.set(index - 1, b);
        this.save();
        res.forwardToPreviousPage(req);
    }

    public void doMoveDownConf(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(this.getRequiredPermission());
        int index = Integer.parseInt(req.getParameter("buildStatId"));
        BuildStatConfiguration b = (BuildStatConfiguration)this.buildStatConfigs.get(index);
        this.buildStatConfigs.set(index, this.buildStatConfigs.get(index + 1));
        this.buildStatConfigs.set(index + 1, b);
        this.save();
        res.forwardToPreviousPage(req);
    }

    private BuildStatConfiguration createBuildStatConfig(StaplerRequest req) {
        return new BuildStatConfiguration(req.getParameter("title"), Integer.parseInt(req.getParameter("buildStatWidth")), Integer.parseInt(req.getParameter("buildStatHeight")), Integer.parseInt(req.getParameter("historicLength")), HistoricScale.valueOf((String)req.getParameter("historicScale")), req.getParameter("jobFilter"), Boolean.parseBoolean(req.getParameter("successShown")), Boolean.parseBoolean(req.getParameter("failuresShown")), Boolean.parseBoolean(req.getParameter("unstablesShown")), Boolean.parseBoolean(req.getParameter("abortedShown")), Boolean.parseBoolean(req.getParameter("notBuildsShown")));
    }

    private JFreeChart createChart(StaplerRequest req, CategoryDataset dataset, String title) {
        JFreeChart chart = ChartFactory.createStackedAreaChart((String)title, null, (String)"Count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setForegroundAlpha(0.85f);
        plot.setRangeGridlinesVisible(true);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        StackedAreaRenderer2 renderer = new StackedAreaRenderer2();
        renderer.setSeriesPaint(0, (Paint)new Color(255, 255, 85));
        renderer.setSeriesPaint(1, (Paint)new Color(255, 85, 85));
        renderer.setSeriesPaint(2, (Paint)new Color(85, 85, 85));
        renderer.setSeriesPaint(3, (Paint)new Color(85, 85, 255));
        renderer.setSeriesPaint(4, (Paint)new Color(255, 85, 255));
        plot.setRenderer((CategoryItemRenderer)renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }

    private DataSetBuilder<String, DateRange> createDataSetBuilder(List<JobBuildResult> filteredJobBuildResults, BuildStatConfiguration config) {
        DataSetBuilder dsb = new DataSetBuilder();
        if (filteredJobBuildResults.size() == 0) {
            return dsb;
        }
        Calendar d2 = new GregorianCalendar();
        Calendar d1 = config.getHistoricScale().getPreviousStep(d2);
        int nbSuccess = 0;
        int nbFailures = 0;
        int nbUnstables = 0;
        int nbAborted = 0;
        int nbNotBuild = 0;
        int nbSteps = 0;
        Iterator<JobBuildResult> buildsIter = filteredJobBuildResults.iterator();
        JobBuildResult currentBuild = buildsIter.next();
        Calendar buildDate = currentBuild.getBuildDate();
        while (nbSteps != config.getHistoricLength()) {
            while (nbSteps < config.getHistoricLength() && d1.after(buildDate)) {
                DateRange range = new DateRange(d1, d2);
                dsb.add((Number)nbSuccess, (Comparable)((Object)"success"), (Comparable)range);
                dsb.add((Number)nbFailures, (Comparable)((Object)"failures"), (Comparable)range);
                dsb.add((Number)nbUnstables, (Comparable)((Object)"unstables"), (Comparable)range);
                dsb.add((Number)nbAborted, (Comparable)((Object)"aborted"), (Comparable)range);
                dsb.add((Number)nbNotBuild, (Comparable)((Object)"not build"), (Comparable)range);
                d2 = (Calendar)d1.clone();
                d1 = config.getHistoricScale().getPreviousStep(d2);
                nbSuccess = 0;
                nbFailures = 0;
                nbUnstables = 0;
                nbAborted = 0;
                nbNotBuild = 0;
                ++nbSteps;
            }
            if (nbSteps == config.getHistoricLength() || currentBuild == null) continue;
            nbSuccess += config.isSuccessShown() ? currentBuild.getResult().getSuccessCount() : 0;
            nbFailures += config.isFailuresShown() ? currentBuild.getResult().getFailureCount() : 0;
            nbUnstables += config.isUnstablesShown() ? currentBuild.getResult().getUnstableCount() : 0;
            nbAborted += config.isAbortedShown() ? currentBuild.getResult().getAbortedCount() : 0;
            nbNotBuild += config.isNotBuildShown() ? currentBuild.getResult().getNotBuildCount() : 0;
            if (buildsIter.hasNext()) {
                currentBuild = buildsIter.next();
                buildDate = currentBuild.getBuildDate();
                continue;
            }
            currentBuild = null;
            buildDate = new GregorianCalendar();
            buildDate.setTimeInMillis(1L);
        }
        return dsb;
    }

    private List<JobBuildResult> createFilteredAndSortedBuildResults(BuildStatConfiguration config) {
        ArrayList<JobBuildResult> filteredJobBuildResults = new ArrayList<JobBuildResult>();
        for (JobBuildResult r : this.jobBuildResults) {
            if (!JobFilterFactory.createJobFilter((String)config.getJobFilter()).isJobApplicable(r.getJobName())) continue;
            filteredJobBuildResults.add(r);
        }
        Collections.sort(filteredJobBuildResults, Collections.reverseOrder(new /* Unavailable Anonymous Inner Class!! */));
        return filteredJobBuildResults;
    }

    private static void addBuildsFrom(List<JobBuildResult> jobBuildResultsRead, AbstractProject project) {
        List builds = project.getBuilds();
        Iterator buildIterator = builds.iterator();
        while (buildIterator.hasNext()) {
            GlobalBuildStatsPlugin.addBuild(jobBuildResultsRead, (AbstractBuild)((AbstractBuild)buildIterator.next()));
        }
    }

    private static void addBuild(List<JobBuildResult> jobBuildResultsRead, AbstractBuild build) {
        jobBuildResultsRead.add(JobBuildResultFactory.INSTANCE.createJobBuildResult(build));
    }

    protected static List<JobBuildResult> mergeJobBuildResults(List<JobBuildResult> existingJobResults, List<JobBuildResult> jobResultsToMerge) {
        ArrayList<JobBuildResult> mergedJobResultsList = new ArrayList<JobBuildResult>(existingJobResults);
        for (JobBuildResult jbrToMerge : jobResultsToMerge) {
            if (mergedJobResultsList.contains(jbrToMerge)) continue;
            mergedJobResultsList.add(jbrToMerge);
        }
        return mergedJobResultsList;
    }

    public BuildStatConfiguration[] getBuildStatConfigs() {
        return this.buildStatConfigs.toArray(new BuildStatConfiguration[0]);
    }

    public Permission getRequiredPermission() {
        return Hudson.ADMINISTER;
    }

    static /* synthetic */ List access$000(GlobalBuildStatsPlugin x0) {
        return x0.jobBuildResults;
    }

    static /* synthetic */ void access$100(List x0, AbstractBuild x1) {
        GlobalBuildStatsPlugin.addBuild((List)x0, (AbstractBuild)x1);
    }
}

