/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.model;

import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HistoricScale {
    HOURLY(10, new Integer[]{12}, "hours"),
    HOURLY_FROM_NOW(10, "hours"),
    DAILY(6, new Integer[]{10, 12}, "days"),
    DAILY_FROM_NOW(6, "days"),
    WEEKLY(3, new Integer[]{7, 10, 12}, "weeks"),
    WEEKLY_FROM_NOW(3, "weeks"),
    MONTHLY(2, new Integer[]{5, 10, 12}, "monthes"),
    MONTHLY_FROM_NOW(2, "monthes"),
    YEARLY(1, new Integer[]{2, 6, 10, 12}, "years"),
    YEARLY_FROM_NOW(1, "years");

    private int calendarField;
    private Integer[] fieldsToReset;
    private String tickLabel;

    private HistoricScale(int _calendarField, String tickLabel) {
        this(_calendarField, new Integer[0], tickLabel);
    }

    private HistoricScale(int _calendarField, Integer[] _fieldsToReset, String tickLabel) {
        this.calendarField = _calendarField;
        this.fieldsToReset = _fieldsToReset;
        this.tickLabel = tickLabel;
    }

    public String getLabel() {
        return this.tickLabel;
    }

    public Calendar getPreviousStep(Calendar currentStep) {
        int i;
        Calendar previousStep = (Calendar)currentStep.clone();
        boolean atLeastOneFieldToResetIsNotReseted = false;
        for (i = 0; !atLeastOneFieldToResetIsNotReseted && i < this.fieldsToReset.length; ++i) {
            atLeastOneFieldToResetIsNotReseted = !this.isFieldReseted(this.fieldsToReset[i], currentStep);
        }
        if (atLeastOneFieldToResetIsNotReseted) {
            for (i = 0; i < this.fieldsToReset.length; ++i) {
                previousStep.set(this.fieldsToReset[i], this.getResetValueForCalendarField(this.fieldsToReset[i], previousStep));
            }
        } else {
            previousStep.add(this.calendarField, -1);
        }
        return previousStep;
    }

    private boolean isFieldReseted(int calendarField, Calendar c) {
        return c.get(calendarField) == this.getResetValueForCalendarField(calendarField, c);
    }

    private int getResetValueForCalendarField(int calendarField, Calendar c) {
        int resetValue = -1;
        resetValue = calendarField == 6 || calendarField == 5 ? 1 : (calendarField == 7 ? c.getFirstDayOfWeek() : 0);
        return resetValue;
    }
}

