/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats;

import hudson.Plugin;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.ManagementLink;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.listeners.RunListener;
import hudson.plugins.global_build_stats.JobBuildResultFactory;
import hudson.plugins.global_build_stats.JobFilter;
import hudson.plugins.global_build_stats.JobFilterFactory;
import hudson.plugins.global_build_stats.model.BuildHistorySearchCriteria;
import hudson.plugins.global_build_stats.model.BuildResult;
import hudson.plugins.global_build_stats.model.BuildStatConfiguration;
import hudson.plugins.global_build_stats.model.DateRange;
import hudson.plugins.global_build_stats.model.HistoricScale;
import hudson.plugins.global_build_stats.model.JobBuildResult;
import hudson.security.Permission;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.FormValidation;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalBuildStatsPlugin
extends Plugin {
    private List<JobBuildResult> jobBuildResults = new ArrayList<JobBuildResult>();
    private List<BuildStatConfiguration> buildStatConfigs = new ArrayList<BuildStatConfiguration>();

    public void postInitialize() throws Exception {
        super.postInitialize();
        this.load();
    }

    public FormValidation doCheckJobFilter(@QueryParameter String value) {
        try {
            JobFilterFactory.createJobFilter(value);
            return FormValidation.ok();
        }
        catch (Throwable t) {
            return FormValidation.error((String)"JobFilter is invalid");
        }
    }

    public FormValidation doCheckFailuresShown(@QueryParameter String value) {
        if (!GlobalBuildStatsPlugin.isBool(value)) {
            return FormValidation.error((String)"FailuresShown must be a boolean");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckUnstablesShown(@QueryParameter String value) {
        if (!GlobalBuildStatsPlugin.isBool(value)) {
            return FormValidation.error((String)"UnstablesShown must be a boolean");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckAbortedShown(@QueryParameter String value) {
        if (!GlobalBuildStatsPlugin.isBool(value)) {
            return FormValidation.error((String)"AbortedShown must be a boolean");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckNotBuildsShown(@QueryParameter String value) {
        if (!GlobalBuildStatsPlugin.isBool(value)) {
            return FormValidation.error((String)"NotBuildsShown must be a boolean");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckSuccessShown(@QueryParameter String value) {
        if (!GlobalBuildStatsPlugin.isBool(value)) {
            return FormValidation.error((String)"SuccessShown must be a boolean");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckHistoricScale(@QueryParameter String value) {
        if (!GlobalBuildStatsPlugin.isMandatory(value)) {
            return FormValidation.error((String)"Historic scale is mandatory");
        }
        try {
            HistoricScale.valueOf(value);
            return FormValidation.ok();
        }
        catch (Throwable t) {
            return FormValidation.error((String)"HistoricScale is invalid");
        }
    }

    public FormValidation doCheckHistoricLength(@QueryParameter String value) {
        if (!GlobalBuildStatsPlugin.isMandatory(value)) {
            return FormValidation.error((String)"Historic length is mandatory");
        }
        if (!GlobalBuildStatsPlugin.isInt(value)) {
            return FormValidation.error((String)"Historic length should be an integer");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckBuildStatHeight(@QueryParameter String value) {
        if (!GlobalBuildStatsPlugin.isMandatory(value)) {
            return FormValidation.error((String)"Build stats height is mandatory");
        }
        if (!GlobalBuildStatsPlugin.isInt(value)) {
            return FormValidation.error((String)"Build stats height should be an integer");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckBuildStatWidth(@QueryParameter String value) {
        if (!GlobalBuildStatsPlugin.isMandatory(value)) {
            return FormValidation.error((String)"Build stats width is mandatory");
        }
        if (!GlobalBuildStatsPlugin.isInt(value)) {
            return FormValidation.error((String)"Build stats width should be an integer");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckTitle(@QueryParameter String value) {
        if (!GlobalBuildStatsPlugin.isMandatory(value)) {
            return FormValidation.error((String)"Title is mandatory");
        }
        return FormValidation.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse doRecordBuildInfos() throws IOException {
        Hudson.getInstance().checkPermission(this.getRequiredPermission());
        ArrayList<JobBuildResult> jobBuildResultsRead = new ArrayList<JobBuildResult>();
        GlobalBuildStatsPlugin globalBuildStatsPlugin = this;
        synchronized (globalBuildStatsPlugin) {
            for (TopLevelItem item : Hudson.getInstance().getItems()) {
                if (!(item instanceof AbstractProject)) continue;
                GlobalBuildStatsPlugin.addBuildsFrom(jobBuildResultsRead, (AbstractProject)item);
            }
            this.jobBuildResults = GlobalBuildStatsPlugin.mergeJobBuildResults(this.jobBuildResults, jobBuildResultsRead);
            this.save();
        }
        return new HttpResponse(){

            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
            }
        };
    }

    public void doCreateChart(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(this.getRequiredPermission());
        BuildStatConfiguration config = this.createBuildStatConfig(req);
        List<JobBuildResult> filteredJobBuildResults = this.createFilteredAndSortedBuildResults(config);
        DataSetBuilder<String, DateRange> dsb = this.createDataSetBuilder(filteredJobBuildResults, config);
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)res, (JFreeChart)this.createChart(req, dsb.build(), config.getBuildStatTitle()), (int)config.getBuildStatWidth(), (int)config.getBuildStatHeight());
    }

    public void doCreateChartMap(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(this.getRequiredPermission());
        BuildStatConfiguration config = this.createBuildStatConfig(req);
        List<JobBuildResult> filteredJobBuildResults = this.createFilteredAndSortedBuildResults(config);
        DataSetBuilder<String, DateRange> dsb = this.createDataSetBuilder(filteredJobBuildResults, config);
        ChartUtil.generateClickableMap((StaplerRequest)req, (StaplerResponse)res, (JFreeChart)this.createChart(req, dsb.build(), config.getBuildStatTitle()), (int)config.getBuildStatWidth(), (int)config.getBuildStatHeight());
    }

    public void doBuildHistory(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(this.getRequiredPermission());
        BuildHistorySearchCriteria searchCriteria = new BuildHistorySearchCriteria();
        req.bindParameters((Object)searchCriteria);
        JobFilter jobFilter = JobFilterFactory.createJobFilter(searchCriteria.jobFilter);
        ArrayList<JobBuildResult> filteredJobBuildResults = new ArrayList<JobBuildResult>();
        for (JobBuildResult r : this.jobBuildResults) {
            if (r.getBuildDate().getTimeInMillis() < searchCriteria.start || r.getBuildDate().getTimeInMillis() >= searchCriteria.end || !GlobalBuildStatsPlugin.jobResultStatusMatchesWith(r.getResult(), searchCriteria) || !jobFilter.isJobApplicable(r.getJobName())) continue;
            filteredJobBuildResults.add(r);
        }
        GlobalBuildStatsPlugin.sortJobBuildResultsByBuildDate(filteredJobBuildResults);
        req.setAttribute("jobResults", filteredJobBuildResults);
        req.setAttribute("searchCriteria", (Object)searchCriteria);
        req.getView((Object)this, "/hudson/plugins/global_build_stats/GlobalBuildStatsPlugin/buildHistory.jelly").forward((ServletRequest)req, (ServletResponse)res);
    }

    public static String escapeAntiSlashes(String value) {
        if (value != null) {
            return value.replaceAll("\\\\", "\\\\\\\\");
        }
        return null;
    }

    protected static boolean jobResultStatusMatchesWith(BuildResult r, BuildHistorySearchCriteria c) {
        return BuildResult.ABORTED.equals((Object)r) && c.abortedShown || BuildResult.FAILURE.equals((Object)r) && c.failuresShown || BuildResult.NOT_BUILD.equals((Object)r) && c.notBuildShown || BuildResult.SUCCESS.equals((Object)r) && c.successShown || BuildResult.UNSTABLE.equals((Object)r) && c.unstablesShown;
    }

    protected static boolean isInt(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected static boolean isMandatory(String value) {
        return value != null && !"".equals(value);
    }

    protected static boolean isBool(String value) {
        try {
            Boolean.valueOf(value);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdateBuildStatConfiguration(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(this.getRequiredPermission());
        GlobalBuildStatsPlugin globalBuildStatsPlugin = this;
        synchronized (globalBuildStatsPlugin) {
            this.buildStatConfigs.set(Integer.parseInt(req.getParameter("buildStatId")), this.createBuildStatConfig(req));
            this.save();
        }
        res.forwardToPreviousPage(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAddBuildStatConfiguration(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(this.getRequiredPermission());
        GlobalBuildStatsPlugin globalBuildStatsPlugin = this;
        synchronized (globalBuildStatsPlugin) {
            this.buildStatConfigs.add(this.createBuildStatConfig(req));
            this.save();
        }
        res.forwardToPreviousPage(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDeleteConfiguration(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(this.getRequiredPermission());
        GlobalBuildStatsPlugin globalBuildStatsPlugin = this;
        synchronized (globalBuildStatsPlugin) {
            this.buildStatConfigs.remove(Integer.parseInt(req.getParameter("buildStatId")));
            this.save();
        }
        res.forwardToPreviousPage(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMoveUpConf(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(this.getRequiredPermission());
        int index = Integer.parseInt(req.getParameter("buildStatId"));
        GlobalBuildStatsPlugin globalBuildStatsPlugin = this;
        synchronized (globalBuildStatsPlugin) {
            BuildStatConfiguration b = this.buildStatConfigs.get(index);
            this.buildStatConfigs.set(index, this.buildStatConfigs.get(index - 1));
            this.buildStatConfigs.set(index - 1, b);
            this.save();
        }
        res.forwardToPreviousPage(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMoveDownConf(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(this.getRequiredPermission());
        int index = Integer.parseInt(req.getParameter("buildStatId"));
        GlobalBuildStatsPlugin globalBuildStatsPlugin = this;
        synchronized (globalBuildStatsPlugin) {
            BuildStatConfiguration b = this.buildStatConfigs.get(index);
            this.buildStatConfigs.set(index, this.buildStatConfigs.get(index + 1));
            this.buildStatConfigs.set(index + 1, b);
            this.save();
        }
        res.forwardToPreviousPage(req);
    }

    private BuildStatConfiguration createBuildStatConfig(StaplerRequest req) {
        return new BuildStatConfiguration(req.getParameter("title"), Integer.parseInt(req.getParameter("buildStatWidth")), Integer.parseInt(req.getParameter("buildStatHeight")), Integer.parseInt(req.getParameter("historicLength")), HistoricScale.valueOf(req.getParameter("historicScale")), req.getParameter("jobFilter"), Boolean.parseBoolean(req.getParameter("successShown")), Boolean.parseBoolean(req.getParameter("failuresShown")), Boolean.parseBoolean(req.getParameter("unstablesShown")), Boolean.parseBoolean(req.getParameter("abortedShown")), Boolean.parseBoolean(req.getParameter("notBuildsShown")));
    }

    private JFreeChart createChart(final StaplerRequest req, CategoryDataset dataset, String title) {
        JFreeChart chart = ChartFactory.createStackedAreaChart((String)title, null, (String)"Count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setForegroundAlpha(0.85f);
        plot.setRangeGridlinesVisible(true);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        StackedAreaRenderer2 renderer = new StackedAreaRenderer2(){

            public String generateURL(CategoryDataset dataset, int row, int column) {
                DateRange range = (DateRange)dataset.getColumnKey(column);
                String status = (String)((Object)dataset.getRowKey(row));
                boolean successShown = "success".equals(status);
                boolean failuresShown = "failures".equals(status);
                boolean unstablesShown = "unstables".equals(status);
                boolean abortedShown = "aborted".equals(status);
                boolean notBuildShown = "not build".equals(status);
                return "buildHistory?jobFilter=" + req.getParameter("jobFilter") + "&start=" + range.getStart().getTimeInMillis() + "&end=" + range.getEnd().getTimeInMillis() + "&successShown=" + successShown + "&failuresShown=" + failuresShown + "&unstablesShown=" + unstablesShown + "&abortedShown=" + abortedShown + "&notBuildShown=" + notBuildShown;
            }
        };
        plot.setRenderer((CategoryItemRenderer)renderer);
        renderer.setSeriesPaint(0, (Paint)new Color(255, 255, 85));
        renderer.setSeriesPaint(1, (Paint)new Color(255, 85, 85));
        renderer.setSeriesPaint(2, (Paint)new Color(85, 85, 85));
        renderer.setSeriesPaint(3, (Paint)new Color(85, 85, 255));
        renderer.setSeriesPaint(4, (Paint)new Color(255, 85, 255));
        plot.setRenderer((CategoryItemRenderer)renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }

    private DataSetBuilder<String, DateRange> createDataSetBuilder(List<JobBuildResult> filteredJobBuildResults, BuildStatConfiguration config) {
        DataSetBuilder dsb = new DataSetBuilder();
        if (filteredJobBuildResults.size() == 0) {
            return dsb;
        }
        Calendar d2 = new GregorianCalendar();
        Calendar d1 = config.getHistoricScale().getPreviousStep(d2);
        int nbSuccess = 0;
        int nbFailures = 0;
        int nbUnstables = 0;
        int nbAborted = 0;
        int nbNotBuild = 0;
        int nbSteps = 0;
        Iterator<JobBuildResult> buildsIter = filteredJobBuildResults.iterator();
        JobBuildResult currentBuild = buildsIter.next();
        Calendar buildDate = currentBuild.getBuildDate();
        while (nbSteps != config.getHistoricLength()) {
            while (nbSteps < config.getHistoricLength() && d1.after(buildDate)) {
                DateRange range = new DateRange(d1, d2, config.getHistoricScale().getDateRangeFormatter());
                dsb.add((Number)nbSuccess, (Comparable)((Object)"success"), (Comparable)range);
                dsb.add((Number)nbFailures, (Comparable)((Object)"failures"), (Comparable)range);
                dsb.add((Number)nbUnstables, (Comparable)((Object)"unstables"), (Comparable)range);
                dsb.add((Number)nbAborted, (Comparable)((Object)"aborted"), (Comparable)range);
                dsb.add((Number)nbNotBuild, (Comparable)((Object)"not build"), (Comparable)range);
                d2 = (Calendar)d1.clone();
                d1 = config.getHistoricScale().getPreviousStep(d2);
                nbSuccess = 0;
                nbFailures = 0;
                nbUnstables = 0;
                nbAborted = 0;
                nbNotBuild = 0;
                ++nbSteps;
            }
            if (nbSteps == config.getHistoricLength() || currentBuild == null) continue;
            nbSuccess += config.isSuccessShown() ? currentBuild.getResult().getSuccessCount() : 0;
            nbFailures += config.isFailuresShown() ? currentBuild.getResult().getFailureCount() : 0;
            nbUnstables += config.isUnstablesShown() ? currentBuild.getResult().getUnstableCount() : 0;
            nbAborted += config.isAbortedShown() ? currentBuild.getResult().getAbortedCount() : 0;
            nbNotBuild += config.isNotBuildShown() ? currentBuild.getResult().getNotBuildCount() : 0;
            if (buildsIter.hasNext()) {
                currentBuild = buildsIter.next();
                buildDate = currentBuild.getBuildDate();
                continue;
            }
            currentBuild = null;
            buildDate = new GregorianCalendar();
            buildDate.setTimeInMillis(1L);
        }
        return dsb;
    }

    private List<JobBuildResult> createFilteredAndSortedBuildResults(BuildStatConfiguration config) {
        ArrayList<JobBuildResult> filteredJobBuildResults = new ArrayList<JobBuildResult>();
        for (JobBuildResult r : this.jobBuildResults) {
            if (!JobFilterFactory.createJobFilter(config.getJobFilter()).isJobApplicable(r.getJobName())) continue;
            filteredJobBuildResults.add(r);
        }
        GlobalBuildStatsPlugin.sortJobBuildResultsByBuildDate(filteredJobBuildResults);
        return filteredJobBuildResults;
    }

    private static void sortJobBuildResultsByBuildDate(List<JobBuildResult> c) {
        Collections.sort(c, Collections.reverseOrder(new Comparator<JobBuildResult>(){

            @Override
            public int compare(JobBuildResult o1, JobBuildResult o2) {
                return o1.getBuildDate().compareTo(o2.getBuildDate());
            }
        }));
    }

    private static void addBuildsFrom(List<JobBuildResult> jobBuildResultsRead, AbstractProject project) {
        List builds = project.getBuilds();
        Iterator buildIterator = builds.iterator();
        while (buildIterator.hasNext()) {
            GlobalBuildStatsPlugin.addBuild(jobBuildResultsRead, (AbstractBuild)buildIterator.next());
        }
    }

    private static void addBuild(List<JobBuildResult> jobBuildResultsRead, AbstractBuild build) {
        jobBuildResultsRead.add(JobBuildResultFactory.INSTANCE.createJobBuildResult(build));
    }

    protected static List<JobBuildResult> mergeJobBuildResults(List<JobBuildResult> existingJobResults, List<JobBuildResult> jobResultsToMerge) {
        ArrayList<JobBuildResult> mergedJobResultsList = new ArrayList<JobBuildResult>(existingJobResults);
        for (JobBuildResult jbrToMerge : jobResultsToMerge) {
            if (mergedJobResultsList.contains(jbrToMerge)) continue;
            mergedJobResultsList.add(jbrToMerge);
        }
        return mergedJobResultsList;
    }

    public BuildStatConfiguration[] getBuildStatConfigs() {
        return this.buildStatConfigs.toArray(new BuildStatConfiguration[0]);
    }

    public Permission getRequiredPermission() {
        return Hudson.ADMINISTER;
    }

    public HistoricScale[] getHistoricScales() {
        return HistoricScale.values();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GlobalBuildStatsRunListener
    extends RunListener<AbstractBuild> {
        public GlobalBuildStatsRunListener() {
            super(AbstractBuild.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCompleted(AbstractBuild r, TaskListener listener) {
            GlobalBuildStatsPlugin plugin;
            super.onCompleted((Run)r, listener);
            GlobalBuildStatsPlugin globalBuildStatsPlugin = plugin = (GlobalBuildStatsPlugin)Hudson.getInstance().getPlugin(GlobalBuildStatsPlugin.class);
            synchronized (globalBuildStatsPlugin) {
                GlobalBuildStatsPlugin.addBuild(plugin.jobBuildResults, r);
                try {
                    plugin.save();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    public static class GlobalBuildStatsManagementLink
    extends ManagementLink {
        public String getIconFileName() {
            return "/plugin/global-build-stats/icons/global-build-stats.png";
        }

        public String getDisplayName() {
            return "Global Builds Stats";
        }

        public String getUrlName() {
            return "plugin/global-build-stats/";
        }

        public String getDescription() {
            return "Displays stats about daily build results";
        }
    }
}

