/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.model;

import hudson.plugins.global_build_stats.model.BuildResult;
import hudson.plugins.global_build_stats.model.HistoricScale;
import java.io.Serializable;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class BuildStatConfiguration
implements Serializable {
    private static final long serialVersionUID = -2962124739645932894L;
    private String id;
    private String buildStatTitle;
    private int buildStatWidth = 400;
    private int buildStatHeight = 300;
    private int historicLength;
    private HistoricScale historicScale;
    private String jobFilter = "ALL";
    private short shownBuildResults;

    public BuildStatConfiguration() {
    }

    public BuildStatConfiguration(String _id, String _buildStatTitle, int _buildStatWidth, int _buildStatHeight, int _historicLength, HistoricScale _historicScale, String _jobFilter, boolean successShown, boolean failuresShown, boolean unstablesShown, boolean abortedShown, boolean notBuildsShown) {
        this.id = _id;
        this.buildStatTitle = _buildStatTitle;
        this.buildStatHeight = _buildStatHeight;
        this.buildStatWidth = _buildStatWidth;
        this.historicLength = _historicLength;
        this.historicScale = _historicScale;
        this.jobFilter = _jobFilter;
        this.shownBuildResults = 0;
        this.shownBuildResults = (short)(this.shownBuildResults | (successShown ? BuildResult.SUCCESS.code : (short)0));
        this.shownBuildResults = (short)(this.shownBuildResults | (failuresShown ? BuildResult.FAILURE.code : (short)0));
        this.shownBuildResults = (short)(this.shownBuildResults | (unstablesShown ? BuildResult.UNSTABLE.code : (short)0));
        this.shownBuildResults = (short)(this.shownBuildResults | (abortedShown ? BuildResult.ABORTED.code : (short)0));
        this.shownBuildResults = (short)(this.shownBuildResults | (notBuildsShown ? BuildResult.NOT_BUILD.code : (short)0));
    }

    @Exported
    public boolean isSuccessShown() {
        return (this.shownBuildResults & BuildResult.SUCCESS.code) != 0;
    }

    @Exported
    public boolean isFailuresShown() {
        return (this.shownBuildResults & BuildResult.FAILURE.code) != 0;
    }

    @Exported
    public boolean isUnstablesShown() {
        return (this.shownBuildResults & BuildResult.UNSTABLE.code) != 0;
    }

    @Exported
    public boolean isAbortedShown() {
        return (this.shownBuildResults & BuildResult.ABORTED.code) != 0;
    }

    @Exported
    public boolean isNotBuildShown() {
        return (this.shownBuildResults & BuildResult.NOT_BUILD.code) != 0;
    }

    @Exported
    public String getBuildStatTitle() {
        return this.buildStatTitle;
    }

    @Exported
    public int getHistoricLength() {
        return this.historicLength;
    }

    @Exported
    public HistoricScale getHistoricScale() {
        return this.historicScale;
    }

    public short getShownBuildResults() {
        return this.shownBuildResults;
    }

    @Exported
    public int getBuildStatWidth() {
        return this.buildStatWidth;
    }

    @Exported
    public int getBuildStatHeight() {
        return this.buildStatHeight;
    }

    @Exported
    public String getJobFilter() {
        return this.jobFilter;
    }

    public void setBuildStatTitle(String buildStatTitle) {
        this.buildStatTitle = buildStatTitle;
    }

    public void setBuildStatWidth(int buildStatWidth) {
        this.buildStatWidth = buildStatWidth;
    }

    public void setBuildStatHeight(int buildStatHeight) {
        this.buildStatHeight = buildStatHeight;
    }

    public void setHistoricLength(int historicLength) {
        this.historicLength = historicLength;
    }

    public void setHistoricScale(String historicScale) {
        this.historicScale = HistoricScale.valueOf((String)historicScale);
    }

    public void setJobFilter(String jobFilter) {
        this.jobFilter = jobFilter;
    }

    @Exported
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

