/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.model;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HistoricScale {
    HOURLY(11, new Integer[]{12}, "hours", "EEE HH:mm"),
    HOURLY_FROM_NOW(11, "hours", "EEE HH:mm"),
    DAILY(6, new Integer[]{11, 12}, "days", "EEE dd HH'h'"),
    DAILY_FROM_NOW(6, "days", "EEE dd HH'h'"),
    WEEKLY(3, new Integer[]{7, 11, 12}, "weeks", "'W'w, EEE"),
    WEEKLY_FROM_NOW(3, "weeks", "'W'w, EEE"),
    MONTHLY(2, new Integer[]{5, 11, 12}, "monthes", "dd MMM ''yy"),
    MONTHLY_FROM_NOW(2, "monthes", "dd MMM ''yy"),
    YEARLY(1, new Integer[]{2, 6, 11, 12}, "years", "''yy 'd'D"),
    YEARLY_FROM_NOW(1, "years", "''yy 'd'D");

    private int calendarField;
    private Integer[] fieldsToReset;
    private String tickLabel;
    private DateFormat dateRangeFormatter;

    private HistoricScale(int _calendarField, String tickLabel, String dateRangeFormatterPattern) {
        this(string, n, _calendarField, new Integer[0], tickLabel, dateRangeFormatterPattern);
    }

    private HistoricScale(int _calendarField, Integer[] _fieldsToReset, String tickLabel, String dateRangeFormatterPattern) {
        this.calendarField = _calendarField;
        this.fieldsToReset = _fieldsToReset;
        this.tickLabel = tickLabel;
        this.dateRangeFormatter = new SimpleDateFormat(dateRangeFormatterPattern);
    }

    public String getLabel() {
        return this.tickLabel;
    }

    public Calendar getPreviousStep(Calendar currentStep) {
        int i;
        Calendar previousStep = (Calendar)currentStep.clone();
        boolean atLeastOneFieldToResetIsNotReseted = false;
        for (i = 0; !atLeastOneFieldToResetIsNotReseted && i < this.fieldsToReset.length; ++i) {
            atLeastOneFieldToResetIsNotReseted = !this.isFieldReseted(this.fieldsToReset[i].intValue(), currentStep);
        }
        if (atLeastOneFieldToResetIsNotReseted) {
            for (i = 0; i < this.fieldsToReset.length; ++i) {
                previousStep.set(this.fieldsToReset[i], this.getResetValueForCalendarField(this.fieldsToReset[i].intValue(), previousStep));
            }
        } else {
            previousStep.add(this.calendarField, -1);
        }
        return previousStep;
    }

    private boolean isFieldReseted(int calendarField, Calendar c) {
        return c.get(calendarField) == this.getResetValueForCalendarField(calendarField, c);
    }

    private int getResetValueForCalendarField(int calendarField, Calendar c) {
        int resetValue = -1;
        resetValue = calendarField == 6 || calendarField == 5 ? 1 : (calendarField == 7 ? c.getFirstDayOfWeek() : 0);
        return resetValue;
    }

    public DateFormat getDateRangeFormatter() {
        return this.dateRangeFormatter;
    }
}

