/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.validation;

import hudson.plugins.global_build_stats.JobFilterFactory;
import hudson.plugins.global_build_stats.model.HistoricScale;
import hudson.plugins.global_build_stats.validation.ValidationHelper;
import hudson.util.FormValidation;

public class GlobalBuildStatsValidator {
    public FormValidation checkJobFilter(String value) {
        try {
            JobFilterFactory.createJobFilter(value);
            return FormValidation.ok();
        }
        catch (Throwable t) {
            return FormValidation.error((String)"JobFilter is invalid");
        }
    }

    public FormValidation checkFailuresShown(String value) {
        if (!ValidationHelper.isBool(value)) {
            return FormValidation.error((String)"FailuresShown must be a boolean");
        }
        return FormValidation.ok();
    }

    public FormValidation checkUnstablesShown(String value) {
        if (!ValidationHelper.isBool(value)) {
            return FormValidation.error((String)"UnstablesShown must be a boolean");
        }
        return FormValidation.ok();
    }

    public FormValidation checkAbortedShown(String value) {
        if (!ValidationHelper.isBool(value)) {
            return FormValidation.error((String)"AbortedShown must be a boolean");
        }
        return FormValidation.ok();
    }

    public FormValidation checkNotBuildsShown(String value) {
        if (!ValidationHelper.isBool(value)) {
            return FormValidation.error((String)"NotBuildsShown must be a boolean");
        }
        return FormValidation.ok();
    }

    public FormValidation checkSuccessShown(String value) {
        if (!ValidationHelper.isBool(value)) {
            return FormValidation.error((String)"SuccessShown must be a boolean");
        }
        return FormValidation.ok();
    }

    public FormValidation checkHistoricScale(String value) {
        if (!ValidationHelper.isMandatory(value)) {
            return FormValidation.error((String)"Historic scale is mandatory");
        }
        try {
            HistoricScale.valueOf(value);
            return FormValidation.ok();
        }
        catch (Throwable t) {
            return FormValidation.error((String)"HistoricScale is invalid");
        }
    }

    public FormValidation checkHistoricLength(String value) {
        if (!ValidationHelper.isMandatory(value)) {
            return FormValidation.error((String)"Historic length is mandatory");
        }
        if (!ValidationHelper.isInt(value)) {
            return FormValidation.error((String)"Historic length should be an integer");
        }
        return FormValidation.ok();
    }

    public FormValidation checkBuildStatHeight(String value) {
        if (!ValidationHelper.isMandatory(value)) {
            return FormValidation.error((String)"Build stats height is mandatory");
        }
        if (!ValidationHelper.isInt(value)) {
            return FormValidation.error((String)"Build stats height should be an integer");
        }
        return FormValidation.ok();
    }

    public FormValidation checkBuildStatWidth(String value) {
        if (!ValidationHelper.isMandatory(value)) {
            return FormValidation.error((String)"Build stats width is mandatory");
        }
        if (!ValidationHelper.isInt(value)) {
            return FormValidation.error((String)"Build stats width should be an integer");
        }
        return FormValidation.ok();
    }

    public FormValidation checkTitle(String value) {
        if (!ValidationHelper.isMandatory(value)) {
            return FormValidation.error((String)"Title is mandatory");
        }
        return FormValidation.ok();
    }
}

