/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.model;

import hudson.plugins.global_build_stats.Messages;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HistoricScale {
    HOURLY(11, new Integer[]{12}, "EEE HH:mm"){

        public String getUnitLabel() {
            return Messages.Historic_Scales_Unit_Labels_hours();
        }

        public String getLabel() {
            return Messages.Historic_Scales_Labels_Hourly();
        }
    }
    ,
    HOURLY_FROM_NOW(11, "EEE HH:mm"){

        public String getUnitLabel() {
            return Messages.Historic_Scales_Unit_Labels_hours();
        }

        public String getLabel() {
            return Messages.Historic_Scales_Labels_Hourly_From_Now();
        }
    }
    ,
    DAILY(6, new Integer[]{11, 12}, "EEE dd HH'h'"){

        public String getUnitLabel() {
            return Messages.Historic_Scales_Unit_Labels_days();
        }

        public String getLabel() {
            return Messages.Historic_Scales_Labels_Daily();
        }
    }
    ,
    DAILY_FROM_NOW(6, "EEE dd HH'h'"){

        public String getUnitLabel() {
            return Messages.Historic_Scales_Unit_Labels_days();
        }

        public String getLabel() {
            return Messages.Historic_Scales_Labels_Daily_From_Now();
        }
    }
    ,
    WEEKLY(3, new Integer[]{7, 11, 12}, "'W'w, EEE"){

        public String getUnitLabel() {
            return Messages.Historic_Scales_Unit_Labels_weeks();
        }

        public String getLabel() {
            return Messages.Historic_Scales_Labels_Weekly();
        }
    }
    ,
    WEEKLY_FROM_NOW(3, "'W'w, EEE"){

        public String getUnitLabel() {
            return Messages.Historic_Scales_Unit_Labels_weeks();
        }

        public String getLabel() {
            return Messages.Historic_Scales_Labels_Weekly_From_Now();
        }
    }
    ,
    MONTHLY(2, new Integer[]{5, 11, 12}, "dd MMM ''yy"){

        public String getUnitLabel() {
            return Messages.Historic_Scales_Unit_Labels_monthes();
        }

        public String getLabel() {
            return Messages.Historic_Scales_Labels_Monthly();
        }
    }
    ,
    MONTHLY_FROM_NOW(2, "dd MMM ''yy"){

        public String getUnitLabel() {
            return Messages.Historic_Scales_Unit_Labels_monthes();
        }

        public String getLabel() {
            return Messages.Historic_Scales_Labels_Monthly_From_Now();
        }
    }
    ,
    YEARLY(1, new Integer[]{2, 6, 11, 12}, "''yy 'd'D"){

        public String getUnitLabel() {
            return Messages.Historic_Scales_Unit_Labels_years();
        }

        public String getLabel() {
            return Messages.Historic_Scales_Labels_Yearly();
        }
    }
    ,
    YEARLY_FROM_NOW(1, "''yy 'd'D"){

        public String getUnitLabel() {
            return Messages.Historic_Scales_Unit_Labels_years();
        }

        public String getLabel() {
            return Messages.Historic_Scales_Labels_Yearly_From_Now();
        }
    };

    private int calendarField;
    private Integer[] fieldsToReset;
    private DateFormat dateRangeFormatter;

    private HistoricScale(int _calendarField, String dateRangeFormatterPattern) {
        this(_calendarField, new Integer[0], dateRangeFormatterPattern);
    }

    private HistoricScale(int _calendarField, Integer[] _fieldsToReset, String dateRangeFormatterPattern) {
        this.calendarField = _calendarField;
        this.fieldsToReset = _fieldsToReset;
        this.dateRangeFormatter = new SimpleDateFormat(dateRangeFormatterPattern);
    }

    public Calendar getPreviousStep(Calendar currentStep) {
        int i;
        Calendar previousStep = (Calendar)currentStep.clone();
        boolean atLeastOneFieldToResetIsNotReseted = false;
        for (i = 0; !atLeastOneFieldToResetIsNotReseted && i < this.fieldsToReset.length; ++i) {
            atLeastOneFieldToResetIsNotReseted = !this.isFieldReseted(this.fieldsToReset[i], currentStep);
        }
        if (atLeastOneFieldToResetIsNotReseted) {
            for (i = 0; i < this.fieldsToReset.length; ++i) {
                previousStep.set(this.fieldsToReset[i], this.getResetValueForCalendarField(this.fieldsToReset[i], previousStep));
            }
        } else {
            previousStep.add(this.calendarField, -1);
        }
        return previousStep;
    }

    private boolean isFieldReseted(int calendarField, Calendar c) {
        return c.get(calendarField) == this.getResetValueForCalendarField(calendarField, c);
    }

    private int getResetValueForCalendarField(int calendarField, Calendar c) {
        int resetValue = -1;
        resetValue = calendarField == 6 || calendarField == 5 ? 1 : (calendarField == 7 ? c.getFirstDayOfWeek() : 0);
        return resetValue;
    }

    public DateFormat getDateRangeFormatter() {
        return this.dateRangeFormatter;
    }

    public abstract String getLabel();

    public abstract String getUnitLabel();
}

