/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.model;

import hudson.plugins.global_build_stats.Messages;
import hudson.plugins.global_build_stats.model.DateRange;
import hudson.util.DataSetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum YAxisChartType {
    COUNT{

        @Override
        public void provideDataInDataSet(DataSetBuilder<String, DateRange> dsb, DateRange range, int nbSuccess, int nbFailures, int nbUnstables, int nbAborted, int nbNotBuild) {
            dsb.add((Number)nbSuccess, (Comparable)((Object)Messages.Build_Results_Statuses_5_SUCCESS()), (Comparable)range);
            dsb.add((Number)nbFailures, (Comparable)((Object)Messages.Build_Results_Statuses_4_FAILURES()), (Comparable)range);
            dsb.add((Number)nbUnstables, (Comparable)((Object)Messages.Build_Results_Statuses_3_UNSTABLES()), (Comparable)range);
            dsb.add((Number)nbAborted, (Comparable)((Object)Messages.Build_Results_Statuses_2_ABORTED()), (Comparable)range);
            dsb.add((Number)nbNotBuild, (Comparable)((Object)Messages.Build_Results_Statuses_1_NOT_BUILD()), (Comparable)range);
        }

        @Override
        public String getLabel() {
            return Messages.YAxis_Chart_Types_Count();
        }
    }
    ,
    PERCENTAGE{

        @Override
        public void provideDataInDataSet(DataSetBuilder<String, DateRange> dsb, DateRange range, int nbSuccess, int nbFailures, int nbUnstables, int nbAborted, int nbNotBuild) {
            double total = nbSuccess + nbFailures + nbUnstables + nbAborted + nbNotBuild;
            if (total == 0.0) {
                dsb.add((Number)0.0, (Comparable)((Object)Messages.Build_Results_Statuses_5_SUCCESS()), (Comparable)range);
                dsb.add((Number)0.0, (Comparable)((Object)Messages.Build_Results_Statuses_4_FAILURES()), (Comparable)range);
                dsb.add((Number)0.0, (Comparable)((Object)Messages.Build_Results_Statuses_3_UNSTABLES()), (Comparable)range);
                dsb.add((Number)0.0, (Comparable)((Object)Messages.Build_Results_Statuses_2_ABORTED()), (Comparable)range);
                dsb.add((Number)0.0, (Comparable)((Object)Messages.Build_Results_Statuses_1_NOT_BUILD()), (Comparable)range);
            } else {
                dsb.add((Number)((double)nbSuccess * 100.0 / total), (Comparable)((Object)Messages.Build_Results_Statuses_5_SUCCESS()), (Comparable)range);
                dsb.add((Number)((double)nbFailures * 100.0 / total), (Comparable)((Object)Messages.Build_Results_Statuses_4_FAILURES()), (Comparable)range);
                dsb.add((Number)((double)nbUnstables * 100.0 / total), (Comparable)((Object)Messages.Build_Results_Statuses_3_UNSTABLES()), (Comparable)range);
                dsb.add((Number)((double)nbAborted * 100.0 / total), (Comparable)((Object)Messages.Build_Results_Statuses_2_ABORTED()), (Comparable)range);
                dsb.add((Number)((double)nbNotBuild * 100.0 / total), (Comparable)((Object)Messages.Build_Results_Statuses_1_NOT_BUILD()), (Comparable)range);
            }
        }

        @Override
        public String getLabel() {
            return Messages.YAxis_Chart_Types_Percentage();
        }
    };


    public abstract String getLabel();

    public abstract void provideDataInDataSet(DataSetBuilder<String, DateRange> var1, DateRange var2, int var3, int var4, int var5, int var6, int var7);
}

