/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.model;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HistoricScale {
    HOURLY/* Unavailable Anonymous Inner Class!! */,
    HOURLY_FROM_NOW/* Unavailable Anonymous Inner Class!! */,
    DAILY/* Unavailable Anonymous Inner Class!! */,
    DAILY_FROM_NOW/* Unavailable Anonymous Inner Class!! */,
    WEEKLY/* Unavailable Anonymous Inner Class!! */,
    WEEKLY_FROM_NOW/* Unavailable Anonymous Inner Class!! */,
    MONTHLY/* Unavailable Anonymous Inner Class!! */,
    MONTHLY_FROM_NOW/* Unavailable Anonymous Inner Class!! */,
    YEARLY/* Unavailable Anonymous Inner Class!! */,
    YEARLY_FROM_NOW/* Unavailable Anonymous Inner Class!! */;

    private int calendarField;
    private Integer[] fieldsToReset;
    private DateFormat dateRangeFormatter;

    private HistoricScale(int _calendarField, String dateRangeFormatterPattern) {
        this(string, n, _calendarField, new Integer[0], dateRangeFormatterPattern);
    }

    private HistoricScale(int _calendarField, Integer[] _fieldsToReset, String dateRangeFormatterPattern) {
        this.calendarField = _calendarField;
        this.fieldsToReset = _fieldsToReset;
        this.dateRangeFormatter = new SimpleDateFormat(dateRangeFormatterPattern);
    }

    public Calendar getPreviousStep(Calendar currentStep) {
        int i;
        Calendar previousStep = (Calendar)currentStep.clone();
        boolean atLeastOneFieldToResetIsNotReseted = false;
        for (i = 0; !atLeastOneFieldToResetIsNotReseted && i < this.fieldsToReset.length; ++i) {
            atLeastOneFieldToResetIsNotReseted = !this.isFieldReseted(this.fieldsToReset[i].intValue(), currentStep);
        }
        if (atLeastOneFieldToResetIsNotReseted) {
            for (i = 0; i < this.fieldsToReset.length; ++i) {
                previousStep.set(this.fieldsToReset[i], this.getResetValueForCalendarField(this.fieldsToReset[i].intValue(), previousStep));
            }
        } else {
            previousStep.add(this.calendarField, -1);
        }
        return previousStep;
    }

    private boolean isFieldReseted(int calendarField, Calendar c) {
        return c.get(calendarField) == this.getResetValueForCalendarField(calendarField, c);
    }

    private int getResetValueForCalendarField(int calendarField, Calendar c) {
        int resetValue = -1;
        resetValue = calendarField == 6 || calendarField == 5 ? 1 : (calendarField == 7 ? c.getFirstDayOfWeek() : 0);
        return resetValue;
    }

    public DateFormat getDateRangeFormatter() {
        return this.dateRangeFormatter;
    }

    public abstract String getLabel();

    public abstract String getUnitLabel();
}

