/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.business;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.TopLevelItem;
import hudson.plugins.global_build_stats.GlobalBuildStatsPlugin;
import hudson.plugins.global_build_stats.JobBuildResultFactory;
import hudson.plugins.global_build_stats.JobFilter;
import hudson.plugins.global_build_stats.JobFilterFactory;
import hudson.plugins.global_build_stats.Messages;
import hudson.plugins.global_build_stats.model.BuildHistorySearchCriteria;
import hudson.plugins.global_build_stats.model.BuildResult;
import hudson.plugins.global_build_stats.model.BuildStatConfiguration;
import hudson.plugins.global_build_stats.model.DateRange;
import hudson.plugins.global_build_stats.model.JobBuildResult;
import hudson.plugins.global_build_stats.model.JobBuildSearchResult;
import hudson.plugins.global_build_stats.model.ModelIdGenerator;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalBuildStatsBusiness {
    private GlobalBuildStatsPlugin plugin;

    public GlobalBuildStatsBusiness(GlobalBuildStatsPlugin _plugin) {
        this.plugin = _plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onJobCompleted(AbstractBuild job) {
        GlobalBuildStatsPlugin globalBuildStatsPlugin = this.plugin;
        synchronized (globalBuildStatsPlugin) {
            GlobalBuildStatsBusiness.addBuild(this.plugin.getJobBuildResults(), job);
            try {
                this.plugin.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public BuildStatConfiguration searchBuildStatConfigById(String buildStatId) {
        int index = this.searchBuildStatConfigIndexById(buildStatId);
        if (index != -1) {
            return this.plugin.getBuildStatConfigs().get(index);
        }
        return null;
    }

    private int searchBuildStatConfigIndexById(String id) {
        int idx = 0;
        for (BuildStatConfiguration c : this.plugin.getBuildStatConfigs()) {
            if (id.equals(c.getId())) break;
            ++idx;
        }
        if (idx == this.plugin.getBuildStatConfigs().size()) {
            idx = -1;
        }
        return idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordBuildInfos() throws IOException {
        ArrayList<JobBuildResult> jobBuildResultsRead = new ArrayList<JobBuildResult>();
        GlobalBuildStatsPlugin globalBuildStatsPlugin = this.plugin;
        synchronized (globalBuildStatsPlugin) {
            for (TopLevelItem item : Hudson.getInstance().getItems()) {
                if (!(item instanceof AbstractProject)) continue;
                GlobalBuildStatsBusiness.addBuildsFrom(jobBuildResultsRead, (AbstractProject)item);
            }
            this.plugin.setJobBuildResults(GlobalBuildStatsBusiness.mergeJobBuildResults(this.plugin.getJobBuildResults(), jobBuildResultsRead));
            this.plugin.save();
        }
    }

    public JFreeChart createChart(BuildStatConfiguration config) {
        DataSetBuilder<String, DateRange> dsb = this.createDataSetBuilder(config);
        return this.createChart(config, dsb.build(), config.getBuildStatTitle());
    }

    public List<JobBuildSearchResult> searchBuilds(BuildHistorySearchCriteria searchCriteria) {
        ArrayList<JobBuildSearchResult> filteredJobBuildResults = new ArrayList<JobBuildSearchResult>();
        JobFilter jobFilter = JobFilterFactory.createJobFilter(searchCriteria.jobFilter);
        for (JobBuildResult r : this.plugin.getJobBuildResults()) {
            if (r.getBuildDate().getTimeInMillis() < searchCriteria.start || r.getBuildDate().getTimeInMillis() >= searchCriteria.end || !GlobalBuildStatsBusiness.jobResultStatusMatchesWith(r.getResult(), searchCriteria) || !jobFilter.isJobApplicable(r.getJobName())) continue;
            boolean isJobAccessible = false;
            boolean isBuildAccessible = false;
            Job targetJob = (Job)Hudson.getInstance().getItem(r.getJobName());
            if (targetJob != null) {
                isJobAccessible = true;
                if (targetJob.getBuildByNumber(r.getBuildNumber()) != null) {
                    isBuildAccessible = true;
                }
            }
            filteredJobBuildResults.add(new JobBuildSearchResult(r, isJobAccessible, isBuildAccessible));
        }
        GlobalBuildStatsBusiness.sortJobBuildResultsByBuildDate(filteredJobBuildResults);
        return filteredJobBuildResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBuildStatConfiguration(String oldBuildStatId, BuildStatConfiguration config, boolean regenerateId) throws IOException {
        GlobalBuildStatsPlugin globalBuildStatsPlugin = this.plugin;
        synchronized (globalBuildStatsPlugin) {
            if (regenerateId) {
                String newBuildStatId = ModelIdGenerator.INSTANCE.generateIdForClass(BuildStatConfiguration.class);
                config.setId(newBuildStatId);
            }
            int buildStatIndex = this.searchBuildStatConfigIndexById(oldBuildStatId);
            this.plugin.getBuildStatConfigs().set(buildStatIndex, config);
            this.plugin.save();
            if (regenerateId) {
                ModelIdGenerator.INSTANCE.unregisterIdForClass(BuildStatConfiguration.class, oldBuildStatId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBuildStatConfiguration(BuildStatConfiguration config) throws IOException {
        GlobalBuildStatsPlugin globalBuildStatsPlugin = this.plugin;
        synchronized (globalBuildStatsPlugin) {
            this.plugin.getBuildStatConfigs().add(config);
            this.plugin.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBuildStatConfiguration(String buildStatId) throws IOException {
        GlobalBuildStatsPlugin globalBuildStatsPlugin = this.plugin;
        synchronized (globalBuildStatsPlugin) {
            int index = this.searchBuildStatConfigIndexById(buildStatId);
            this.plugin.getBuildStatConfigs().remove(index);
            this.plugin.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveUpConf(String buildStatId) throws IOException {
        int index = this.searchBuildStatConfigIndexById(buildStatId);
        if (index <= 0) {
            throw new IllegalArgumentException("Can't move up first build stat configuration !");
        }
        GlobalBuildStatsPlugin globalBuildStatsPlugin = this.plugin;
        synchronized (globalBuildStatsPlugin) {
            BuildStatConfiguration b = this.plugin.getBuildStatConfigs().get(index);
            this.plugin.getBuildStatConfigs().set(index, this.plugin.getBuildStatConfigs().get(index - 1));
            this.plugin.getBuildStatConfigs().set(index - 1, b);
            this.plugin.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveDownConf(String buildStatId) throws IOException {
        int index = this.searchBuildStatConfigIndexById(buildStatId);
        if (index >= this.plugin.getBuildStatConfigs().size() - 1) {
            throw new IllegalArgumentException("Can't move down last build stat configuration !");
        }
        GlobalBuildStatsPlugin globalBuildStatsPlugin = this.plugin;
        synchronized (globalBuildStatsPlugin) {
            BuildStatConfiguration b = this.plugin.getBuildStatConfigs().get(index);
            this.plugin.getBuildStatConfigs().set(index, this.plugin.getBuildStatConfigs().get(index + 1));
            this.plugin.getBuildStatConfigs().set(index + 1, b);
            this.plugin.save();
        }
    }

    public static String escapeAntiSlashes(String value) {
        if (value != null) {
            return value.replaceAll("\\\\", "\\\\\\\\");
        }
        return null;
    }

    protected static boolean jobResultStatusMatchesWith(BuildResult r, BuildHistorySearchCriteria c) {
        return BuildResult.ABORTED.equals((Object)r) && c.abortedShown || BuildResult.FAILURE.equals((Object)r) && c.failuresShown || BuildResult.NOT_BUILD.equals((Object)r) && c.notBuildShown || BuildResult.SUCCESS.equals((Object)r) && c.successShown || BuildResult.UNSTABLE.equals((Object)r) && c.unstablesShown;
    }

    private JFreeChart createChart(final BuildStatConfiguration config, CategoryDataset dataset, String title) {
        JFreeChart chart = ChartFactory.createStackedAreaChart((String)title, null, (String)config.getyAxisChartType().getLabel(), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setForegroundAlpha(0.85f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.darkGray);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        StackedAreaRenderer2 renderer = new StackedAreaRenderer2(){

            public String generateURL(CategoryDataset dataset, int row, int column) {
                DateRange range = (DateRange)dataset.getColumnKey(column);
                String status = (String)((Object)dataset.getRowKey(row));
                boolean successShown = Messages.Build_Results_Statuses_5_SUCCESS().equals(status);
                boolean failuresShown = Messages.Build_Results_Statuses_4_FAILURES().equals(status);
                boolean unstablesShown = Messages.Build_Results_Statuses_3_UNSTABLES().equals(status);
                boolean abortedShown = Messages.Build_Results_Statuses_2_ABORTED().equals(status);
                boolean notBuildShown = Messages.Build_Results_Statuses_1_NOT_BUILD().equals(status);
                return "buildHistory?jobFilter=" + config.getJobFilter() + "&start=" + range.getStart().getTimeInMillis() + "&end=" + range.getEnd().getTimeInMillis() + "&successShown=" + successShown + "&failuresShown=" + failuresShown + "&unstablesShown=" + unstablesShown + "&abortedShown=" + abortedShown + "&notBuildShown=" + notBuildShown;
            }
        };
        plot.setRenderer((CategoryItemRenderer)renderer);
        renderer.setSeriesPaint(0, (Paint)new Color(85, 85, 85));
        renderer.setSeriesPaint(1, (Paint)new Color(255, 85, 255));
        renderer.setSeriesPaint(2, (Paint)new Color(255, 255, 85));
        renderer.setSeriesPaint(3, (Paint)new Color(255, 85, 85));
        renderer.setSeriesPaint(4, (Paint)new Color(85, 85, 255));
        plot.setRenderer((CategoryItemRenderer)renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }

    public DataSetBuilder<String, DateRange> createDataSetBuilder(BuildStatConfiguration config) {
        DataSetBuilder dsb = new DataSetBuilder();
        List<JobBuildResult> filteredJobBuildResults = this.createFilteredAndSortedBuildResults(config);
        if (filteredJobBuildResults.size() == 0) {
            return dsb;
        }
        Calendar d2 = new GregorianCalendar();
        Calendar d1 = config.getHistoricScale().getPreviousStep(d2);
        int nbSuccess = 0;
        int nbFailures = 0;
        int nbUnstables = 0;
        int nbAborted = 0;
        int nbNotBuild = 0;
        int nbSteps = 0;
        Iterator<JobBuildResult> buildsIter = filteredJobBuildResults.iterator();
        JobBuildResult currentBuild = buildsIter.next();
        Calendar buildDate = currentBuild.getBuildDate();
        while (nbSteps != config.getHistoricLength()) {
            while (nbSteps < config.getHistoricLength() && d1.after(buildDate)) {
                DateRange range = new DateRange(d1, d2, config.getHistoricScale().getDateRangeFormatter());
                config.getyAxisChartType().provideDataInDataSet((DataSetBuilder<String, DateRange>)dsb, range, nbSuccess, nbFailures, nbUnstables, nbAborted, nbNotBuild);
                d2 = (Calendar)d1.clone();
                d1 = config.getHistoricScale().getPreviousStep(d2);
                nbSuccess = 0;
                nbFailures = 0;
                nbUnstables = 0;
                nbAborted = 0;
                nbNotBuild = 0;
                ++nbSteps;
            }
            if (nbSteps == config.getHistoricLength() || currentBuild == null) continue;
            nbSuccess += config.isSuccessShown() ? currentBuild.getResult().getSuccessCount() : 0;
            nbFailures += config.isFailuresShown() ? currentBuild.getResult().getFailureCount() : 0;
            nbUnstables += config.isUnstablesShown() ? currentBuild.getResult().getUnstableCount() : 0;
            nbAborted += config.isAbortedShown() ? currentBuild.getResult().getAbortedCount() : 0;
            nbNotBuild += config.isNotBuildShown() ? currentBuild.getResult().getNotBuildCount() : 0;
            if (buildsIter.hasNext()) {
                currentBuild = buildsIter.next();
                buildDate = currentBuild.getBuildDate();
                continue;
            }
            currentBuild = null;
            buildDate = new GregorianCalendar();
            buildDate.setTimeInMillis(1L);
        }
        return dsb;
    }

    private static void sortJobBuildResultsByBuildDate(List<? extends JobBuildResult> c) {
        Collections.sort(c, Collections.reverseOrder(new Comparator<JobBuildResult>(){

            @Override
            public int compare(JobBuildResult o1, JobBuildResult o2) {
                return o1.getBuildDate().compareTo(o2.getBuildDate());
            }
        }));
    }

    private List<JobBuildResult> createFilteredAndSortedBuildResults(BuildStatConfiguration config) {
        ArrayList<JobBuildResult> filteredJobBuildResults = new ArrayList<JobBuildResult>();
        for (JobBuildResult r : this.plugin.getJobBuildResults()) {
            if (!JobFilterFactory.createJobFilter(config.getJobFilter()).isJobApplicable(r.getJobName())) continue;
            filteredJobBuildResults.add(r);
        }
        GlobalBuildStatsBusiness.sortJobBuildResultsByBuildDate(filteredJobBuildResults);
        return filteredJobBuildResults;
    }

    private static void addBuild(List<JobBuildResult> jobBuildResultsRead, AbstractBuild build) {
        jobBuildResultsRead.add(JobBuildResultFactory.INSTANCE.createJobBuildResult(build));
    }

    private static void addBuildsFrom(List<JobBuildResult> jobBuildResultsRead, AbstractProject project) {
        List builds = project.getBuilds();
        Iterator buildIterator = builds.iterator();
        while (buildIterator.hasNext()) {
            GlobalBuildStatsBusiness.addBuild(jobBuildResultsRead, (AbstractBuild)buildIterator.next());
        }
    }

    protected static List<JobBuildResult> mergeJobBuildResults(List<JobBuildResult> existingJobResults, List<JobBuildResult> jobResultsToMerge) {
        ArrayList<JobBuildResult> mergedJobResultsList = new ArrayList<JobBuildResult>(existingJobResults);
        for (JobBuildResult jbrToMerge : jobResultsToMerge) {
            if (mergedJobResultsList.contains(jbrToMerge)) continue;
            mergedJobResultsList.add(jbrToMerge);
        }
        return mergedJobResultsList;
    }
}

