/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats;

import com.thoughtworks.xstream.converters.Converter;
import hudson.Plugin;
import hudson.model.Api;
import hudson.model.Hudson;
import hudson.plugins.global_build_stats.FromRequestObjectFactory;
import hudson.plugins.global_build_stats.GlobalBuildStatsPlugin;
import hudson.plugins.global_build_stats.business.GlobalBuildStatsBusiness;
import hudson.plugins.global_build_stats.model.BuildHistorySearchCriteria;
import hudson.plugins.global_build_stats.model.BuildSearchCriteria;
import hudson.plugins.global_build_stats.model.BuildStatConfiguration;
import hudson.plugins.global_build_stats.model.HistoricScale;
import hudson.plugins.global_build_stats.model.JobBuildResult;
import hudson.plugins.global_build_stats.model.ModelIdGenerator;
import hudson.plugins.global_build_stats.model.YAxisChartDimension;
import hudson.plugins.global_build_stats.model.YAxisChartType;
import hudson.plugins.global_build_stats.validation.GlobalBuildStatsValidator;
import hudson.plugins.global_build_stats.xstream.GlobalBuildStatsXStreamConverter;
import hudson.security.Permission;
import hudson.util.ChartUtil;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.sf.json.JSONObject;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@ExportedBean
public class GlobalBuildStatsPlugin
extends Plugin {
    private static final Logger LOGGER = Logger.getLogger(GlobalBuildStatsPlugin.class.getName());
    private List<JobBuildResult> jobBuildResults = new ArrayList();
    private List<BuildStatConfiguration> buildStatConfigs = new ArrayList();
    private final transient GlobalBuildStatsBusiness business = new GlobalBuildStatsBusiness(this);
    private final transient GlobalBuildStatsValidator validator = new GlobalBuildStatsValidator();

    public void start() throws Exception {
        super.start();
        Hudson.XSTREAM.registerConverter((Converter)new GlobalBuildStatsXStreamConverter());
        Hudson.XSTREAM.alias("jbr", JobBuildResult.class);
        Hudson.XSTREAM.alias("bsc", BuildStatConfiguration.class);
        Hudson.XSTREAM.alias("bscr", BuildSearchCriteria.class);
        Hudson.XSTREAM.alias("GBS_HS", HistoricScale.class);
        Hudson.XSTREAM.alias("GBS_YACT", YAxisChartType.class);
        Hudson.XSTREAM.alias("GBS_YACD", YAxisChartDimension.class);
        Hudson.XSTREAM.aliasField("t", BuildStatConfiguration.class, "buildStatTitle");
        Hudson.XSTREAM.aliasField("w", BuildStatConfiguration.class, "buildStatWidth");
        Hudson.XSTREAM.aliasField("h", BuildStatConfiguration.class, "buildStatHeight");
        Hudson.XSTREAM.aliasField("l", BuildStatConfiguration.class, "historicLength");
        Hudson.XSTREAM.aliasField("s", BuildStatConfiguration.class, "historicScale");
        Hudson.XSTREAM.aliasField("yact", BuildStatConfiguration.class, "yAxisChartType");
        Hudson.XSTREAM.aliasField("ds", BuildStatConfiguration.class, "dimensionsShown");
        Hudson.XSTREAM.aliasField("f", BuildStatConfiguration.class, "buildFilters");
        Hudson.XSTREAM.aliasField("jf", BuildStatConfiguration.class, "jobFilter");
        Hudson.XSTREAM.aliasField("sbr", BuildStatConfiguration.class, "shownBuildResults");
        Hudson.XSTREAM.aliasField("jf", BuildSearchCriteria.class, "jobFilter");
        Hudson.XSTREAM.aliasField("nf", BuildSearchCriteria.class, "nodeFilter");
        Hudson.XSTREAM.aliasField("sbr", BuildSearchCriteria.class, "shownBuildResults");
        Hudson.XSTREAM.aliasField("r", JobBuildResult.class, "result");
        Hudson.XSTREAM.aliasField("n", JobBuildResult.class, "jobName");
        Hudson.XSTREAM.aliasField("nb", JobBuildResult.class, "buildNumber");
        Hudson.XSTREAM.aliasField("d", JobBuildResult.class, "buildDate");
        Hudson.XSTREAM.aliasField("du", JobBuildResult.class, "duration");
        Hudson.XSTREAM.aliasField("nn", JobBuildResult.class, "nodeName");
    }

    public Api getApi() {
        return new GlobalBuildStatsApi((Object)this);
    }

    private static GlobalBuildStatsBusiness getPluginBusiness() {
        return ((GlobalBuildStatsPlugin)Hudson.getInstance().getPlugin(GlobalBuildStatsPlugin.class)).business;
    }

    public FormValidation doCheckJobFilter(@QueryParameter String value) {
        return this.validator.checkJobFilter(value);
    }

    public FormValidation doCheckFailuresShown(@QueryParameter String value) {
        return this.validator.checkFailuresShown(value);
    }

    public FormValidation doCheckUnstablesShown(@QueryParameter String value) {
        return this.validator.checkUnstablesShown(value);
    }

    public FormValidation doCheckAbortedShown(@QueryParameter String value) {
        return this.validator.checkAbortedShown(value);
    }

    public FormValidation doCheckNotBuildsShown(@QueryParameter String value) {
        return this.validator.checkNotBuildsShown(value);
    }

    public FormValidation doCheckSuccessShown(@QueryParameter String value) {
        return this.validator.checkSuccessShown(value);
    }

    public FormValidation doCheckHistoricScale(@QueryParameter String value) {
        return this.validator.checkHistoricScale(value);
    }

    public FormValidation doCheckHistoricLength(@QueryParameter String value) {
        return this.validator.checkHistoricLength(value);
    }

    public FormValidation doCheckBuildStatHeight(@QueryParameter String value) {
        return this.validator.checkBuildStatHeight(value);
    }

    public FormValidation doCheckBuildStatWidth(@QueryParameter String value) {
        return this.validator.checkBuildStatWidth(value);
    }

    public FormValidation doCheckTitle(@QueryParameter String value) {
        return this.validator.checkTitle(value);
    }

    public FormValidation doCheckYAxisChartType(@QueryParameter String value) {
        return this.validator.checkYAxisChartType(value);
    }

    public HttpResponse doRecordBuildInfos() throws IOException {
        Hudson.getInstance().checkPermission(this.getRequiredPermission());
        this.business.recordBuildInfos();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void doShowChart(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        BuildStatConfiguration config = this.business.searchBuildStatConfigById(req.getParameter("buildStatId"));
        if (config == null) {
            throw new IllegalArgumentException("Unknown buildStatId parameter !");
        }
        JFreeChart chart = this.business.createChart(config);
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)res, (JFreeChart)chart, (int)config.getBuildStatWidth(), (int)config.getBuildStatHeight());
    }

    public void doCreateChart(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(this.getRequiredPermission());
        BuildStatConfiguration config = FromRequestObjectFactory.createBuildStatConfiguration(null, (StaplerRequest)req);
        JFreeChart chart = this.business.createChart(config);
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)res, (JFreeChart)chart, (int)config.getBuildStatWidth(), (int)config.getBuildStatHeight());
    }

    public void doCreateChartMap(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(this.getRequiredPermission());
        String buildStatId = req.getParameter("buildStatId");
        BuildStatConfiguration config = null;
        config = buildStatId != null ? this.business.searchBuildStatConfigById(buildStatId) : FromRequestObjectFactory.createBuildStatConfiguration(null, (StaplerRequest)req);
        JFreeChart chart = this.business.createChart(config);
        ChartUtil.generateClickableMap((StaplerRequest)req, (StaplerResponse)res, (JFreeChart)chart, (int)config.getBuildStatWidth(), (int)config.getBuildStatHeight());
    }

    public void doBuildHistory(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(this.getRequiredPermission());
        BuildHistorySearchCriteria searchCriteria = FromRequestObjectFactory.createBuildHistorySearchCriteria((StaplerRequest)req);
        List filteredJobBuildResults = this.business.searchBuilds(searchCriteria);
        req.setAttribute("jobResults", (Object)filteredJobBuildResults);
        req.setAttribute("searchCriteria", (Object)searchCriteria);
        req.getView((Object)this, "/hudson/plugins/global_build_stats/GlobalBuildStatsPlugin/buildHistory.jelly").forward((ServletRequest)req, (ServletResponse)res);
    }

    public void doUpdateBuildStatConfiguration(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(this.getRequiredPermission());
        boolean regenerateId = Boolean.valueOf(req.getParameter("regenerateId"));
        BuildStatConfiguration config = FromRequestObjectFactory.createBuildStatConfiguration((String)req.getParameter("buildStatId"), (StaplerRequest)req);
        this.business.updateBuildStatConfiguration(req.getParameter("buildStatId"), config, regenerateId);
        String json = JSONObject.fromObject((Object)config).toString();
        res.getWriter().write(json);
    }

    public void doAddBuildStatConfiguration(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(this.getRequiredPermission());
        BuildStatConfiguration config = FromRequestObjectFactory.createBuildStatConfiguration((String)ModelIdGenerator.INSTANCE.generateIdForClass(BuildStatConfiguration.class), (StaplerRequest)req);
        this.business.addBuildStatConfiguration(config);
        String json = JSONObject.fromObject((Object)config).toString();
        res.getWriter().write(json);
    }

    public void doDeleteConfiguration(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(this.getRequiredPermission());
        this.business.deleteBuildStatConfiguration(req.getParameter("buildStatId"));
        res.getWriter().write("{ status : 'ok' }");
    }

    public void doMoveUpConf(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(this.getRequiredPermission());
        this.business.moveUpConf(req.getParameter("buildStatId"));
        res.getWriter().write("{ status : 'ok' }");
    }

    public void doMoveDownConf(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(this.getRequiredPermission());
        this.business.moveDownConf(req.getParameter("buildStatId"));
        res.getWriter().write("{ status : 'ok' }");
    }

    public static String escapeAntiSlashes(String value) {
        return GlobalBuildStatsBusiness.escapeAntiSlashes((String)value);
    }

    public static String getFieldFilterALL() {
        return "ALL";
    }

    public static String getFieldFilterRegex() {
        return "fieldRegex";
    }

    public BuildStatConfiguration[] getBuildStatConfigsArrayed() {
        return this.buildStatConfigs.toArray(new BuildStatConfiguration[0]);
    }

    @Exported
    public List<BuildStatConfiguration> getBuildStatConfigs() {
        return this.buildStatConfigs;
    }

    public Permission getRequiredPermission() {
        return Hudson.ADMINISTER;
    }

    public HistoricScale[] getHistoricScales() {
        return HistoricScale.values();
    }

    public YAxisChartType[] getYAxisChartTypes() {
        return YAxisChartType.values();
    }

    public List<JobBuildResult> getJobBuildResults() {
        return this.jobBuildResults;
    }

    public void setJobBuildResults(List<JobBuildResult> jobBuildResults) {
        this.jobBuildResults = jobBuildResults;
    }

    static /* synthetic */ GlobalBuildStatsBusiness access$000() {
        return GlobalBuildStatsPlugin.getPluginBusiness();
    }

    static /* synthetic */ void access$100(GlobalBuildStatsPlugin x0) throws IOException {
        x0.load();
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }
}

