/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.model;

import hudson.plugins.global_build_stats.FieldFilter;
import hudson.plugins.global_build_stats.FieldFilterFactory;
import hudson.plugins.global_build_stats.model.BuildResult;
import hudson.plugins.global_build_stats.model.BuildSearchCriteria;
import hudson.plugins.global_build_stats.model.HistoricScale;
import hudson.plugins.global_build_stats.model.YAxisChartDimension;
import hudson.plugins.global_build_stats.model.YAxisChartType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class BuildStatConfiguration
implements Serializable {
    private static final long serialVersionUID = -2962124739645932894L;
    private String id;
    private String buildStatTitle;
    private int buildStatWidth = 400;
    private int buildStatHeight = 300;
    private int historicLength;
    private HistoricScale historicScale;
    private YAxisChartType yAxisChartType = YAxisChartType.COUNT;
    private YAxisChartDimension[] dimensionsShown;
    private BuildSearchCriteria buildFilters;
    @Deprecated
    private transient String jobFilter = "ALL";
    transient FieldFilter calculatedJobFilter = null;
    @Deprecated
    private transient String nodeFilter = "ALL";
    transient FieldFilter calculatedNodeFilter = null;
    @Deprecated
    private transient short shownBuildResults;

    public BuildStatConfiguration() {
    }

    public BuildStatConfiguration(String _id, String _buildStatTitle, int _buildStatWidth, int _buildStatHeight, int _historicLength, HistoricScale _historicScale, YAxisChartType _yAxisChartType, boolean _buildCountsShown, boolean _totalBuildTimeShown, boolean _averageBuildTimeShown, BuildSearchCriteria _buildFilters) {
        this.id = _id;
        this.buildStatTitle = _buildStatTitle;
        this.buildStatHeight = _buildStatHeight;
        this.buildStatWidth = _buildStatWidth;
        this.historicLength = _historicLength;
        this.historicScale = _historicScale;
        this.yAxisChartType = _yAxisChartType;
        this.buildFilters = _buildFilters;
        ArrayList<YAxisChartDimension> dimensionsList = new ArrayList<YAxisChartDimension>();
        if (_buildCountsShown) {
            dimensionsList.add(YAxisChartDimension.BUILD_COUNTER);
        }
        if (_totalBuildTimeShown) {
            dimensionsList.add(YAxisChartDimension.BUILD_TOTAL_DURATION);
        }
        if (_averageBuildTimeShown) {
            dimensionsList.add(YAxisChartDimension.BUILD_AVERAGE_DURATION);
        }
        this.dimensionsShown = dimensionsList.toArray(new YAxisChartDimension[0]);
    }

    @Exported
    public String getBuildStatTitle() {
        return this.buildStatTitle;
    }

    @Exported
    public int getHistoricLength() {
        return this.historicLength;
    }

    @Exported
    public HistoricScale getHistoricScale() {
        return this.historicScale;
    }

    @Exported
    public int getBuildStatWidth() {
        return this.buildStatWidth;
    }

    @Exported
    public int getBuildStatHeight() {
        return this.buildStatHeight;
    }

    @Exported
    public String getId() {
        return this.id;
    }

    @Exported
    public YAxisChartType getyAxisChartType() {
        return this.yAxisChartType;
    }

    public void setBuildStatTitle(String buildStatTitle) {
        this.buildStatTitle = buildStatTitle;
    }

    public void setBuildStatWidth(int buildStatWidth) {
        this.buildStatWidth = buildStatWidth;
    }

    public void setBuildStatHeight(int buildStatHeight) {
        this.buildStatHeight = buildStatHeight;
    }

    public void setHistoricLength(int historicLength) {
        this.historicLength = historicLength;
    }

    public void setHistoricScale(String historicScale) {
        this.historicScale = HistoricScale.valueOf((String)historicScale);
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setyAxisChartType(YAxisChartType yAxisChartType) {
        this.yAxisChartType = yAxisChartType;
    }

    @Exported
    public YAxisChartDimension[] getDimensionsShown() {
        return this.dimensionsShown;
    }

    public void setDimensionsShown(YAxisChartDimension[] dimensionsShown) {
        this.dimensionsShown = dimensionsShown;
    }

    @Exported
    public boolean isBuildStatusesShown() {
        return Arrays.binarySearch(this.dimensionsShown, YAxisChartDimension.BUILD_COUNTER) >= 0;
    }

    @Exported
    public boolean isTotalBuildTimeShown() {
        return Arrays.binarySearch(this.dimensionsShown, YAxisChartDimension.BUILD_TOTAL_DURATION) >= 0;
    }

    @Exported
    public boolean isAverageBuildTimeShown() {
        return Arrays.binarySearch(this.dimensionsShown, YAxisChartDimension.BUILD_AVERAGE_DURATION) >= 0;
    }

    @Exported
    public BuildSearchCriteria getBuildFilters() {
        return this.buildFilters;
    }

    public void setBuildFilters(BuildSearchCriteria buildFilters) {
        this.buildFilters = buildFilters;
    }

    @Deprecated
    public boolean isSuccessShown() {
        return (this.shownBuildResults & BuildResult.SUCCESS.code) != 0;
    }

    @Deprecated
    public boolean isFailuresShown() {
        return (this.shownBuildResults & BuildResult.FAILURE.code) != 0;
    }

    @Deprecated
    public boolean isUnstablesShown() {
        return (this.shownBuildResults & BuildResult.UNSTABLE.code) != 0;
    }

    @Deprecated
    public boolean isAbortedShown() {
        return (this.shownBuildResults & BuildResult.ABORTED.code) != 0;
    }

    @Deprecated
    public boolean isNotBuildShown() {
        return (this.shownBuildResults & BuildResult.NOT_BUILD.code) != 0;
    }

    @Deprecated
    public String getJobFilter() {
        return this.jobFilter;
    }

    @Deprecated
    public String getNodeFilter() {
        return this.nodeFilter;
    }

    @Deprecated
    public void setJobFilter(String jobFilter) {
        this.jobFilter = jobFilter;
        this.calculatedJobFilter = FieldFilterFactory.createFieldFilter((String)jobFilter);
    }

    @Deprecated
    public void setNodeFilter(String nodeFilter) {
        this.nodeFilter = nodeFilter;
        this.calculatedNodeFilter = FieldFilterFactory.createFieldFilter((String)nodeFilter);
    }

    @Deprecated
    public void setShownBuildResults(short shownBuildResults) {
        this.shownBuildResults = shownBuildResults;
    }
}

