/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import hudson.plugins.global_build_stats.GlobalBuildStatsPlugin;
import hudson.plugins.global_build_stats.model.BuildStatConfiguration;
import hudson.plugins.global_build_stats.model.JobBuildResult;
import hudson.plugins.global_build_stats.xstream.migration.GlobalBuildStatsDataMigrator;
import hudson.plugins.global_build_stats.xstream.migration.GlobalBuildStatsPOJO;
import hudson.plugins.global_build_stats.xstream.migration.GlobalBuildStatsXStreamReader;
import hudson.plugins.global_build_stats.xstream.migration.v0.V0XStreamReader;
import hudson.plugins.global_build_stats.xstream.migration.v1.V0ToV1Migrator;
import hudson.plugins.global_build_stats.xstream.migration.v1.V1XStreamReader;
import hudson.plugins.global_build_stats.xstream.migration.v2.V1ToV2Migrator;
import hudson.plugins.global_build_stats.xstream.migration.v2.V2XStreamReader;
import hudson.plugins.global_build_stats.xstream.migration.v3.V2ToV3Migrator;
import hudson.plugins.global_build_stats.xstream.migration.v3.V3XStreamReader;
import hudson.plugins.global_build_stats.xstream.migration.v4.V3ToV4Migrator;
import hudson.plugins.global_build_stats.xstream.migration.v4.V4XStreamReader;
import hudson.plugins.global_build_stats.xstream.migration.v5.V4ToV5Migrator;
import hudson.plugins.global_build_stats.xstream.migration.v5.V5XStreamReader;
import hudson.plugins.global_build_stats.xstream.migration.v6.V5ToV6Migrator;
import hudson.plugins.global_build_stats.xstream.migration.v6.V6GlobalBuildStatsPOJO;
import hudson.plugins.global_build_stats.xstream.migration.v6.V6XStreamReader;
import java.util.logging.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class GlobalBuildStatsXStreamConverter
implements Converter {
    private static final Logger LOGGER = Logger.getLogger(GlobalBuildStatsXStreamConverter.class.getName());
    public static final String BUILD_STAT_CONFIG_CLASS_ALIAS = "bsc";
    public static final String JOB_BUILD_RESULT_CLASS_ALIAS = "jbr";
    public static final String BUILD_SEARCH_CRITERIA_CLASS_ALIAS = "bscr";
    public static final String HISTORIC_SCALE_CLASS_ALIAS = "GBS_HS";
    public static final String YAXIS_CHART_TYPE_CLASS_ALIAS = "GBS_YACT";
    public static final String YAXIS_CHART_DIMENSION_CLASS_ALIAS = "GBS_YACD";
    private static final GlobalBuildStatsXStreamReader[] READERS = new GlobalBuildStatsXStreamReader[]{new V0XStreamReader(), new V1XStreamReader(), new V2XStreamReader(), new V3XStreamReader(), new V4XStreamReader(), new V5XStreamReader(), new V6XStreamReader()};
    private static final GlobalBuildStatsDataMigrator[] MIGRATORS = new GlobalBuildStatsDataMigrator[]{new V0ToV1Migrator(), new V1ToV2Migrator(), new V2ToV3Migrator(), new V3ToV4Migrator(), new V4ToV5Migrator(), new V5ToV6Migrator()};

    public boolean canConvert(Class type) {
        return GlobalBuildStatsPlugin.class.isAssignableFrom(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        GlobalBuildStatsPlugin plugin = (GlobalBuildStatsPlugin)source;
        writer.addAttribute("version", String.valueOf(GlobalBuildStatsXStreamConverter.getCurrentGlobalBuildStatsVersionNumber()));
        writer.startNode("jobBuildResults");
        if (plugin.getJobBuildResults() != null) {
            for (JobBuildResult r : plugin.getJobBuildResults()) {
                writer.startNode("bsc");
                context.convertAnother((Object)r);
                writer.endNode();
            }
        }
        writer.endNode();
        writer.startNode("buildStatConfigs");
        if (plugin.getBuildStatConfigs() != null) {
            for (BuildStatConfiguration c : plugin.getBuildStatConfigs()) {
                writer.startNode("jbr");
                context.convertAnother((Object)c);
                writer.endNode();
            }
        }
        writer.endNode();
    }

    private static int getCurrentGlobalBuildStatsVersionNumber() {
        return MIGRATORS.length;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        GlobalBuildStatsPlugin plugin = context.currentObject() == null || !(context.currentObject() instanceof GlobalBuildStatsPlugin) ? new GlobalBuildStatsPlugin() : (GlobalBuildStatsPlugin)context.currentObject();
        String version = reader.getAttribute("version");
        int versionNumber = 0;
        if (version != null) {
            versionNumber = Integer.parseInt(version);
        }
        if (versionNumber != GlobalBuildStatsXStreamConverter.getCurrentGlobalBuildStatsVersionNumber()) {
            LOGGER.info("Your version of persisted GlobalBuildStatsPlugin data is not up-to-date (v" + versionNumber + " < v" + GlobalBuildStatsXStreamConverter.getCurrentGlobalBuildStatsVersionNumber() + ") : data will be migrated !");
        }
        GlobalBuildStatsPOJO pojo = READERS[versionNumber].readGlobalBuildStatsPOJO(reader, context);
        for (int i = versionNumber; i < GlobalBuildStatsXStreamConverter.getCurrentGlobalBuildStatsVersionNumber(); ++i) {
            pojo = MIGRATORS[i].migrate(pojo);
        }
        this.populateGlobalBuildStatsPlugin(plugin, pojo);
        return plugin;
    }

    protected void populateGlobalBuildStatsPlugin(GlobalBuildStatsPlugin plugin, GlobalBuildStatsPOJO pojo) {
        V6GlobalBuildStatsPOJO versionedPojo = (V6GlobalBuildStatsPOJO)pojo;
        plugin.getBuildStatConfigs().clear();
        plugin.getBuildStatConfigs().addAll(versionedPojo.buildStatConfigs);
        plugin.getJobBuildResults().clear();
        plugin.getJobBuildResults().addAll(versionedPojo.jobBuildResults);
    }
}

