/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.model;

import hudson.plugins.global_build_stats.model.BuildResult;
import java.io.Serializable;
import java.util.Calendar;

public class JobBuildResult
implements Serializable {
    private static final long serialVersionUID = -4697202185011561179L;
    public static long EMPTY_DURATION = -1L;
    public static final String EMPTY_NODE_NAME = null;
    public static final String MASTER_NODE_NAME = "master";
    private BuildResult result;
    private String jobName;
    private int buildNumber;
    private Calendar buildDate;
    private long duration = -1L;
    private String nodeName;

    public JobBuildResult(BuildResult _result, String _jobName, int _buildNumber, Calendar _buildDate, long duration, String nodeName) {
        this.result = _result;
        this.jobName = _jobName;
        this.buildNumber = _buildNumber;
        this.buildDate = (Calendar)_buildDate.clone();
        this.duration = duration;
        this.setNodeName(nodeName);
    }

    public String toString() {
        return "jobName=" + this.jobName + ", buildNumber=" + this.buildNumber + ", result=" + (Object)((Object)this.result) + ", buildDate=" + this.buildDate + ", duration=" + this.duration + ", nodeName=" + this.nodeName;
    }

    public BuildResult getResult() {
        return this.result;
    }

    public String getJobName() {
        return this.jobName;
    }

    public Calendar getBuildDate() {
        return this.buildDate;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public boolean isJobBuiltOnMaster() {
        return MASTER_NODE_NAME.equals(this.nodeName);
    }

    public boolean isDurationEmpty() {
        return EMPTY_DURATION == this.duration;
    }

    public boolean isNodeNameEmpty() {
        return this.nodeName == EMPTY_NODE_NAME;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JobBuildResult) {
            JobBuildResult r = (JobBuildResult)obj;
            return r.buildNumber == this.buildNumber && r.jobName.equals(this.jobName) && r.result.equals((Object)this.result);
        }
        return false;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = "".equals(nodeName) ? MASTER_NODE_NAME : nodeName;
    }
}

