/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats;

import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Result;
import hudson.plugins.global_build_stats.model.BuildResult;
import hudson.plugins.global_build_stats.model.JobBuildResult;

/*
 * Exception performing whole class analysis ignored.
 */
public class JobBuildResultFactory {
    public static final JobBuildResultFactory INSTANCE = new JobBuildResultFactory();
    private static final String SYSTEM_USERNAME = "SYSTEM";

    private JobBuildResultFactory() {
    }

    public JobBuildResult createJobBuildResult(AbstractBuild build) {
        String buildName = build.getProject().getName();
        long duration = build.getDuration();
        String nodeName = build.getBuiltOnStr();
        return new JobBuildResult(this.createBuildResult(build.getResult()), buildName, build.getNumber(), build.getTimestamp(), duration, nodeName, JobBuildResultFactory.extractUserNameIn((AbstractBuild)build));
    }

    public static String extractUserNameIn(AbstractBuild build) {
        String userName = null;
        Cause.UserCause uc = JobBuildResultFactory.retrieveUserCause((AbstractBuild)build);
        userName = uc != null ? uc.getUserName() : "SYSTEM";
        return userName;
    }

    private static Cause.UserCause retrieveUserCause(AbstractBuild build) {
        for (CauseAction a : build.getActions(CauseAction.class)) {
            for (Cause c : a.getCauses()) {
                if (!(c instanceof Cause.UserCause)) continue;
                return (Cause.UserCause)c;
            }
        }
        return null;
    }

    public BuildResult createBuildResult(Result result) {
        if (Result.ABORTED.equals(result)) {
            return BuildResult.ABORTED;
        }
        if (Result.FAILURE.equals(result)) {
            return BuildResult.FAILURE;
        }
        if (Result.NOT_BUILT.equals(result)) {
            return BuildResult.NOT_BUILD;
        }
        if (Result.SUCCESS.equals(result)) {
            return BuildResult.SUCCESS;
        }
        return BuildResult.UNSTABLE;
    }
}

