/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.business;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.TopLevelItem;
import hudson.plugins.global_build_stats.GlobalBuildStatsPlugin;
import hudson.plugins.global_build_stats.JobBuildResultFactory;
import hudson.plugins.global_build_stats.model.AbstractBuildStatChartDimension;
import hudson.plugins.global_build_stats.model.BuildHistorySearchCriteria;
import hudson.plugins.global_build_stats.model.BuildStatConfiguration;
import hudson.plugins.global_build_stats.model.DateRange;
import hudson.plugins.global_build_stats.model.JobBuildResult;
import hudson.plugins.global_build_stats.model.JobBuildSearchResult;
import hudson.plugins.global_build_stats.model.ModelIdGenerator;
import hudson.plugins.global_build_stats.model.YAxisChartDimension;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class GlobalBuildStatsBusiness {
    private GlobalBuildStatsPlugin plugin;

    public GlobalBuildStatsBusiness(GlobalBuildStatsPlugin _plugin) {
        this.plugin = _plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onJobCompleted(AbstractBuild job) {
        GlobalBuildStatsPlugin globalBuildStatsPlugin = this.plugin;
        synchronized (globalBuildStatsPlugin) {
            GlobalBuildStatsBusiness.addBuild((List)this.plugin.getJobBuildResults(), (AbstractBuild)job);
            try {
                this.plugin.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public BuildStatConfiguration searchBuildStatConfigById(String buildStatId) {
        int index = this.searchBuildStatConfigIndexById(buildStatId);
        if (index != -1) {
            return (BuildStatConfiguration)this.plugin.getBuildStatConfigs().get(index);
        }
        return null;
    }

    private int searchBuildStatConfigIndexById(String id) {
        BuildStatConfiguration c;
        int idx = 0;
        Iterator i$ = this.plugin.getBuildStatConfigs().iterator();
        while (i$.hasNext() && !id.equals((c = (BuildStatConfiguration)i$.next()).getId())) {
            ++idx;
        }
        if (idx == this.plugin.getBuildStatConfigs().size()) {
            idx = -1;
        }
        return idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordBuildInfos() throws IOException {
        ArrayList jobBuildResultsRead = new ArrayList();
        GlobalBuildStatsPlugin globalBuildStatsPlugin = this.plugin;
        synchronized (globalBuildStatsPlugin) {
            for (TopLevelItem item : Hudson.getInstance().getItems()) {
                if (!(item instanceof AbstractProject)) continue;
                GlobalBuildStatsBusiness.addBuildsFrom(jobBuildResultsRead, (AbstractProject)((AbstractProject)item));
            }
            this.plugin.setJobBuildResults(GlobalBuildStatsBusiness.mergeJobBuildResults((List)this.plugin.getJobBuildResults(), jobBuildResultsRead));
            this.plugin.save();
        }
    }

    public JFreeChart createChart(BuildStatConfiguration config) {
        List dimensions = this.createDataSetBuilder(config);
        return this.createChart(config, dimensions, config.getBuildStatTitle());
    }

    public List<JobBuildSearchResult> searchBuilds(BuildHistorySearchCriteria searchCriteria) {
        ArrayList<JobBuildSearchResult> filteredJobBuildResults = new ArrayList<JobBuildSearchResult>();
        for (JobBuildResult r : this.plugin.getJobBuildResults()) {
            if (!searchCriteria.isJobResultEligible(r)) continue;
            boolean isJobAccessible = false;
            boolean isBuildAccessible = false;
            Job targetJob = (Job)Hudson.getInstance().getItem(r.getJobName());
            if (targetJob != null) {
                isJobAccessible = true;
                if (targetJob.getBuildByNumber(r.getBuildNumber()) != null) {
                    isBuildAccessible = true;
                }
            }
            filteredJobBuildResults.add(new JobBuildSearchResult(r, isJobAccessible, isBuildAccessible));
        }
        GlobalBuildStatsBusiness.sortJobBuildResultsByBuildDate(filteredJobBuildResults);
        return filteredJobBuildResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBuildStatConfiguration(String oldBuildStatId, BuildStatConfiguration config, boolean regenerateId) throws IOException {
        GlobalBuildStatsPlugin globalBuildStatsPlugin = this.plugin;
        synchronized (globalBuildStatsPlugin) {
            if (regenerateId) {
                String newBuildStatId = ModelIdGenerator.INSTANCE.generateIdForClass(BuildStatConfiguration.class);
                config.setId(newBuildStatId);
            }
            int buildStatIndex = this.searchBuildStatConfigIndexById(oldBuildStatId);
            this.plugin.getBuildStatConfigs().set(buildStatIndex, config);
            this.plugin.save();
            if (regenerateId) {
                ModelIdGenerator.INSTANCE.unregisterIdForClass(BuildStatConfiguration.class, oldBuildStatId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBuildStatConfiguration(BuildStatConfiguration config) throws IOException {
        GlobalBuildStatsPlugin globalBuildStatsPlugin = this.plugin;
        synchronized (globalBuildStatsPlugin) {
            this.plugin.getBuildStatConfigs().add(config);
            this.plugin.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBuildStatConfiguration(String buildStatId) throws IOException {
        GlobalBuildStatsPlugin globalBuildStatsPlugin = this.plugin;
        synchronized (globalBuildStatsPlugin) {
            int index = this.searchBuildStatConfigIndexById(buildStatId);
            this.plugin.getBuildStatConfigs().remove(index);
            this.plugin.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveUpConf(String buildStatId) throws IOException {
        int index = this.searchBuildStatConfigIndexById(buildStatId);
        if (index <= 0) {
            throw new IllegalArgumentException("Can't move up first build stat configuration !");
        }
        GlobalBuildStatsPlugin globalBuildStatsPlugin = this.plugin;
        synchronized (globalBuildStatsPlugin) {
            BuildStatConfiguration b = (BuildStatConfiguration)this.plugin.getBuildStatConfigs().get(index);
            this.plugin.getBuildStatConfigs().set(index, this.plugin.getBuildStatConfigs().get(index - 1));
            this.plugin.getBuildStatConfigs().set(index - 1, b);
            this.plugin.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveDownConf(String buildStatId) throws IOException {
        int index = this.searchBuildStatConfigIndexById(buildStatId);
        if (index >= this.plugin.getBuildStatConfigs().size() - 1) {
            throw new IllegalArgumentException("Can't move down last build stat configuration !");
        }
        GlobalBuildStatsPlugin globalBuildStatsPlugin = this.plugin;
        synchronized (globalBuildStatsPlugin) {
            BuildStatConfiguration b = (BuildStatConfiguration)this.plugin.getBuildStatConfigs().get(index);
            this.plugin.getBuildStatConfigs().set(index, this.plugin.getBuildStatConfigs().get(index + 1));
            this.plugin.getBuildStatConfigs().set(index + 1, b);
            this.plugin.save();
        }
    }

    public static String escapeAntiSlashes(String value) {
        if (value != null) {
            return value.replaceAll("\\\\", "\\\\\\\\");
        }
        return null;
    }

    private JFreeChart createChart(BuildStatConfiguration config, List<AbstractBuildStatChartDimension> dimensions, String title) {
        JFreeChart chart = ChartFactory.createStackedAreaChart((String)title, null, (String)"", (CategoryDataset)new DataSetBuilder().build(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setForegroundAlpha(0.85f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.darkGray);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        for (int i = 0; i < dimensions.size(); ++i) {
            AbstractBuildStatChartDimension dimension = dimensions.get(dimensions.size() - 1 - i);
            plot.setRangeAxis(i, dimension.getRangeAxis());
            plot.setRenderer(i, dimension.getRenderer());
            plot.setDataset(i, dimension.getDatasetBuilder().build());
            plot.mapDatasetToRangeAxis(i, i);
        }
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }

    private static LegendItemCollection sortLegendItems(LegendItemCollection legendItems) {
        LegendItemCollection sortedLegendItems = new LegendItemCollection();
        List sortedLegendItemsLabels = AbstractBuildStatChartDimension.getSortedLegendItemsLabels();
        for (AbstractBuildStatChartDimension.LegendItemData legendItemData : sortedLegendItemsLabels) {
            Iterator legendItemsIter = legendItems.iterator();
            LegendItem legendItemMatchingCurrentLabel = null;
            while (legendItemMatchingCurrentLabel == null && legendItemsIter.hasNext()) {
                LegendItem currentLegendItem = (LegendItem)legendItemsIter.next();
                if (!legendItemData.label.equals(currentLegendItem.getLabel())) continue;
                legendItemMatchingCurrentLabel = new LegendItem(legendItemData.label, currentLegendItem.getDescription(), currentLegendItem.getToolTipText(), "", (Shape)new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0), (Paint)legendItemData.color);
            }
            if (legendItemMatchingCurrentLabel == null) continue;
            sortedLegendItems.add(legendItemMatchingCurrentLabel);
        }
        return sortedLegendItems;
    }

    public List<AbstractBuildStatChartDimension> createDataSetBuilder(BuildStatConfiguration config) {
        ArrayList<AbstractBuildStatChartDimension> dimensions = new ArrayList<AbstractBuildStatChartDimension>();
        for (YAxisChartDimension dimensionShown : config.getDimensionsShown()) {
            dimensions.add(dimensionShown.createBuildStatChartDimension(config, new DataSetBuilder()));
        }
        ArrayList sortedJobResults = new ArrayList(this.plugin.getJobBuildResults());
        GlobalBuildStatsBusiness.sortJobBuildResultsByBuildDate(sortedJobResults);
        Calendar d2 = new GregorianCalendar();
        Calendar d1 = config.getHistoricScale().getPreviousStep(d2);
        int tickCount = 0;
        Iterator buildsIter = sortedJobResults.iterator();
        JobBuildResult currentBuild = (JobBuildResult)buildsIter.next();
        Calendar buildDate = currentBuild.getBuildDate();
        while (tickCount != config.getHistoricLength()) {
            while (tickCount < config.getHistoricLength() && d1.after(buildDate)) {
                DateRange range = new DateRange(d1, d2, config.getHistoricScale().getDateRangeFormatter());
                for (AbstractBuildStatChartDimension dimension : dimensions) {
                    dimension.provideDataInDataSet(range);
                }
                d2 = (Calendar)d1.clone();
                d1 = config.getHistoricScale().getPreviousStep(d2);
                ++tickCount;
            }
            if (tickCount == config.getHistoricLength() || currentBuild == null) continue;
            if (config.getBuildFilters().isJobResultEligible(currentBuild)) {
                for (AbstractBuildStatChartDimension dimension : dimensions) {
                    dimension.saveDataForBuild(currentBuild);
                }
            }
            if (buildsIter.hasNext()) {
                currentBuild = (JobBuildResult)buildsIter.next();
                buildDate = currentBuild.getBuildDate();
                continue;
            }
            currentBuild = null;
            buildDate = new GregorianCalendar();
            buildDate.setTimeInMillis(1L);
        }
        return dimensions;
    }

    private static void sortJobBuildResultsByBuildDate(List<? extends JobBuildResult> c) {
        Collections.sort(c, Collections.reverseOrder(new /* Unavailable Anonymous Inner Class!! */));
    }

    private static void addBuild(List<JobBuildResult> jobBuildResultsRead, AbstractBuild build) {
        jobBuildResultsRead.add(JobBuildResultFactory.INSTANCE.createJobBuildResult(build));
    }

    private static void addBuildsFrom(List<JobBuildResult> jobBuildResultsRead, AbstractProject project) {
        List builds = project.getBuilds();
        Iterator buildIterator = builds.iterator();
        while (buildIterator.hasNext()) {
            GlobalBuildStatsBusiness.addBuild(jobBuildResultsRead, (AbstractBuild)((AbstractBuild)buildIterator.next()));
        }
    }

    protected static List<JobBuildResult> mergeJobBuildResults(List<JobBuildResult> existingJobResults, List<JobBuildResult> jobResultsToMerge) {
        ArrayList<JobBuildResult> mergedJobResultsList = new ArrayList<JobBuildResult>(existingJobResults);
        for (JobBuildResult jbrToMerge : jobResultsToMerge) {
            if (mergedJobResultsList.contains(jbrToMerge)) continue;
            mergedJobResultsList.add(jbrToMerge);
        }
        return mergedJobResultsList;
    }
}

